/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;

public class SnapshotCreateParameters
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_WRITE_THROTTLING_THRESHOLD = 0;
    private CompressionOption compressionOption = CompressionOption.NONE;
    private int compressionLevel = -1;
    private int writeThrottlingThreshold = 0;
    private boolean exchangelessSnapshot;

    public SnapshotCreateParameters() {
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel) {
        this(compressionOption, compressionLevel, 0);
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold) {
        this(compressionOption, compressionLevel, writeThrottlingThreshold, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true));
    }

    public SnapshotCreateParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold, boolean exchangelessSnapshot) {
        this.compressionOption = compressionOption;
        this.compressionLevel = compressionLevel;
        this.writeThrottlingThreshold = writeThrottlingThreshold;
        this.exchangelessSnapshot = exchangelessSnapshot;
    }

    public byte getProtocolVersion() {
        return 4;
    }

    public CompressionOption getCompressionOption() {
        return this.compressionOption;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getWriteThrottlingThreshold() {
        return this.writeThrottlingThreshold;
    }

    public boolean exchangelessSnapshot() {
        return this.exchangelessSnapshot;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeByte(this.compressionOption.ordinal());
        out.writeByte(this.compressionLevel);
        out.writeInt(this.writeThrottlingThreshold);
        out.writeBoolean(this.exchangelessSnapshot);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.compressionOption = CompressionOption.fromOrdinal(in.readByte());
        if (protoVer > 1) {
            this.compressionLevel = in.readByte();
        }
        if (protoVer > 2) {
            this.writeThrottlingThreshold = in.readInt();
        }
        this.exchangelessSnapshot = protoVer > 3 && in.readBoolean();
    }

    public String toString() {
        return S.toString(SnapshotCreateParameters.class, (Object)((Object)this));
    }
}

