/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;

public class SnapshotCreateTransferParameters
extends SnapshotCreateParameters {
    private static final long serialVersionUID = 0L;
    private File destPath;
    private SnapshotUpdateOperationParameters transferParameters;

    public SnapshotCreateTransferParameters() {
    }

    public SnapshotCreateTransferParameters(CompressionOption compressionOption, int compressionLevel, int writeThrottlingThreshold, File destPath, SnapshotUpdateOperationParameters transferParameters) {
        super(compressionOption, compressionLevel, writeThrottlingThreshold, false);
        this.destPath = destPath;
        this.transferParameters = transferParameters;
    }

    public File destinationPath() {
        return this.destPath;
    }

    public SnapshotUpdateOperationParameters transferParameters() {
        return this.transferParameters;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        super.writeExternalData(out);
        if (this.destPath == null) {
            out.writeInt(0);
        } else {
            byte[] pathBytes = this.destPath.getPath().getBytes(StandardCharsets.UTF_8);
            out.writeInt(pathBytes.length);
            out.write(pathBytes);
        }
        if (this.transferParameters == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            this.transferParameters.writeExternalData(out);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalData(protoVer, in);
        int pathLen = in.readInt();
        if (pathLen > 0) {
            byte[] pathBytes = new byte[pathLen];
            in.read(pathBytes, 0, pathLen);
            this.destPath = new File(new String(pathBytes, StandardCharsets.UTF_8));
        }
        if (in.readByte() != 0) {
            this.transferParameters = new SnapshotUpdateOperationParameters();
            this.transferParameters.readExternalData(protoVer, in);
        }
    }

    @Override
    public String toString() {
        return S.toString(SnapshotCreateTransferParameters.class, (Object)((Object)this));
    }
}

