/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.cache.dr.CacheDrPauseReason;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheDrPauseInfo
implements Externalizable,
GridCacheInternal {
    private static final long serialVersionUID = 0L;
    private UUID nodeId;
    private CacheDrPauseReason reason;
    private String errMsg;
    private UUID creatorUUID;

    public CacheDrPauseInfo() {
    }

    public CacheDrPauseInfo(UUID nodeId, CacheDrPauseReason reason, @Nullable String errMsg, @NotNull UUID creatorUUID) {
        assert (nodeId != null);
        this.nodeId = nodeId;
        this.reason = reason;
        this.errMsg = errMsg;
        this.creatorUUID = creatorUUID;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public CacheDrPauseReason reason() {
        return this.reason;
    }

    @Nullable
    public String error() {
        return this.errMsg;
    }

    public UUID cacheCreatorUUID() {
        return this.creatorUUID;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CacheDrPauseInfo) {
            CacheDrPauseInfo other = (CacheDrPauseInfo)obj;
            return F.eq((Object)this.nodeId, (Object)other.nodeId) && F.eq((Object)((Object)this.reason), (Object)((Object)other.reason)) && F.eq((Object)this.errMsg, (Object)other.errMsg);
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid((DataOutput)out, (UUID)this.nodeId);
        U.writeEnum((DataOutput)out, (Enum)this.reason);
        U.writeString((DataOutput)out, (String)this.errMsg);
        U.writeUuid((DataOutput)out, (UUID)this.creatorUUID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid((DataInput)in);
        this.reason = CacheDrPauseReason.fromOrdinal(in.readByte());
        this.errMsg = U.readString((DataInput)in);
        try {
            this.creatorUUID = U.readUuid((DataInput)in);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public String toString() {
        return S.toString(CacheDrPauseInfo.class, (Object)this);
    }
}

