/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.cache.dr.CacheDrReceiverMetrics;
import org.jetbrains.annotations.Nullable;

public class CacheDrReceiverMetricsAdapter
implements CacheDrReceiverMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private LongAdder entriesReceived = new LongAdder();
    private LongAdder conflictNew = new LongAdder();
    private LongAdder conflictOld = new LongAdder();
    private LongAdder conflictMerge = new LongAdder();

    public CacheDrReceiverMetricsAdapter() {
    }

    CacheDrReceiverMetricsAdapter(CacheDrReceiverMetrics m) {
        this.entriesReceived.add(m.entriesReceived());
        this.conflictNew.add(m.conflictNew());
        this.conflictOld.add(m.conflictOld());
        this.conflictMerge.add(m.conflictMerge());
    }

    @Override
    public long entriesReceived() {
        return this.entriesReceived.longValue();
    }

    @Override
    public long conflictNew() {
        return this.conflictNew.longValue();
    }

    @Override
    public long conflictOld() {
        return this.conflictOld.longValue();
    }

    @Override
    public long conflictMerge() {
        return this.conflictMerge.longValue();
    }

    public void onReceiveCacheConflictResolved(boolean usedNew, boolean usedOld, boolean usedMerge) {
        if (usedNew) {
            this.conflictNew.increment();
        } else if (usedOld) {
            this.conflictOld.increment();
        } else if (usedMerge) {
            this.conflictMerge.increment();
        }
    }

    public void onReceiveCacheEntriesReceived(int entriesCnt) {
        this.entriesReceived.add(entriesCnt);
    }

    @Nullable
    public static CacheDrReceiverMetricsAdapter copyOf(@Nullable CacheDrReceiverMetrics m) {
        if (m == null) {
            return null;
        }
        return new CacheDrReceiverMetricsAdapter(m);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.entriesReceived.longValue());
        out.writeLong(this.conflictNew.longValue());
        out.writeLong(this.conflictOld.longValue());
        out.writeLong(this.conflictMerge.longValue());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.entriesReceived.add(in.readInt());
        this.conflictNew.add(in.readInt());
        this.conflictOld.add(in.readLong());
        this.conflictMerge.add(in.readInt());
    }

    public String toString() {
        return S.toString(CacheDrReceiverMetricsAdapter.class, (Object)this);
    }
}

