/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.cache.dr.CacheDrPauseReason;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.jetbrains.annotations.Nullable;

public class CacheDrSenderMetricsAdapter
implements CacheDrSenderMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private LongAdder batchesSent = new LongAdder();
    private LongAdder entriesSent = new LongAdder();
    private LongAdder entriesFiltered = new LongAdder();
    private LongAdder batchesAcked = new LongAdder();
    private LongAdder entriesAcked = new LongAdder();
    private LongAdder batchesFailed = new LongAdder();
    private LongAdder fstThrottlingMilliseconds = new LongAdder();
    private volatile long backupQueueSize;
    private volatile CacheDrStatus status;

    public CacheDrSenderMetricsAdapter() {
    }

    CacheDrSenderMetricsAdapter(CacheDrSenderMetrics m) {
        this.batchesSent.add(m.batchesSent());
        this.entriesSent.add(m.entriesSent());
        this.entriesFiltered.add(m.entriesFiltered());
        this.batchesAcked.add(m.batchesAcked());
        this.entriesAcked.add(m.entriesAcked());
        this.batchesFailed.add(m.batchesFailed());
        this.backupQueueSize = m.backupQueueSize();
        this.fstThrottlingMilliseconds.add(m.fstThrottlingMilliseconds());
        this.status = m.status();
    }

    @Override
    public int batchesSent() {
        return this.batchesSent.intValue();
    }

    @Override
    public long entriesSent() {
        return this.entriesSent.longValue();
    }

    @Override
    public long entriesFiltered() {
        return this.entriesFiltered.longValue();
    }

    @Override
    public int batchesAcked() {
        return this.batchesAcked.intValue();
    }

    @Override
    public long entriesAcked() {
        return this.entriesAcked.longValue();
    }

    @Override
    public int batchesFailed() {
        return this.batchesFailed.intValue();
    }

    @Override
    public long backupQueueSize() {
        return this.backupQueueSize;
    }

    @Override
    public long fstThrottlingMilliseconds() {
        return this.fstThrottlingMilliseconds.longValue();
    }

    @Override
    @Nullable
    public CacheDrStatus status() {
        return this.status;
    }

    public void onBatchAcked(int entriesCnt) {
        this.batchesAcked.increment();
        this.entriesAcked.add(entriesCnt);
    }

    public void onBatchFailed(int entriesCnt) {
        this.batchesFailed.increment();
    }

    public void onBatchSent(int entriesCnt) {
        this.batchesSent.increment();
        this.entriesSent.add(entriesCnt);
    }

    public void onEntryFiltered() {
        this.entriesFiltered.increment();
    }

    public void backupQueueSize(int backupQueueSize) {
        this.backupQueueSize = backupQueueSize;
    }

    public void onFstThrottling(long millis) {
        this.fstThrottlingMilliseconds.add(millis);
    }

    public void onStopStateChanged(@Nullable CacheDrPauseReason stopReason, @Nullable String errMsg) {
        assert (stopReason != null || errMsg == null);
        this.status = stopReason != null ? new CacheDrStatus(stopReason, errMsg) : CacheDrStatus.ACTIVE;
    }

    @Nullable
    public static CacheDrSenderMetricsAdapter copyOf(@Nullable CacheDrSenderMetrics m) {
        if (m == null) {
            return null;
        }
        return new CacheDrSenderMetricsAdapter(m);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.batchesSent.intValue());
        out.writeLong(this.entriesSent.longValue());
        out.writeLong(this.entriesFiltered.longValue());
        out.writeInt(this.batchesAcked.intValue());
        out.writeLong(this.entriesAcked.longValue());
        out.writeInt(this.batchesFailed.intValue());
        out.writeLong(this.backupQueueSize);
        out.writeObject(this.status);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchesSent.add(in.readInt());
        this.entriesSent.add(in.readLong());
        this.entriesFiltered.add(in.readLong());
        this.batchesAcked.add(in.readInt());
        this.entriesAcked.add(in.readLong());
        this.batchesFailed.add(in.readInt());
        this.backupQueueSize = in.readLong();
        this.status = (CacheDrStatus)in.readObject();
    }

    public String toString() {
        return S.toString(CacheDrSenderMetricsAdapter.class, (Object)this);
    }
}

