/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;

public class CacheDrStateTransferInfo
implements Externalizable,
GridCacheInternal {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id;
    private AffinityTopologyVersion topVer;
    private UUID nodeId;
    private long gridActivationTime;
    private long startTime;
    @GridToStringExclude
    private Map<Integer, UUID> parts;
    private long sentEntryCnt;
    private boolean syncFst;

    public CacheDrStateTransferInfo() {
    }

    public CacheDrStateTransferInfo(IgniteUuid id, @NotNull AffinityTopologyVersion topVer, UUID nodeId, long gridActivationTime, Map<Integer, UUID> parts, boolean syncFst) {
        this.id = id;
        this.topVer = topVer;
        this.nodeId = nodeId;
        this.gridActivationTime = gridActivationTime;
        this.parts = parts;
        this.syncFst = syncFst;
        this.startTime = System.currentTimeMillis();
    }

    public CacheDrStateTransferInfo(CacheDrStateTransferInfo info) {
        this.id = info.id;
        this.topVer = info.topVer;
        this.nodeId = info.nodeId;
        this.gridActivationTime = info.gridActivationTime;
        this.startTime = info.startTime;
        this.parts = info.parts;
        this.sentEntryCnt = info.sentEntryCnt;
        this.syncFst = info.syncFst;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public long gridActivationTime() {
        return this.gridActivationTime;
    }

    public long startTime() {
        return this.startTime;
    }

    public Map<Integer, UUID> partitions() {
        return this.parts;
    }

    public CacheDrStateTransferInfo partitions(Map<Integer, UUID> parts) {
        this.parts = parts;
        return this;
    }

    public long entryCount() {
        return this.sentEntryCnt;
    }

    public CacheDrStateTransferInfo entryCount(long sentEntryCnt) {
        assert (sentEntryCnt >= 0L);
        this.sentEntryCnt = sentEntryCnt;
        return this;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    @Deprecated
    public boolean isSyncTransfer() {
        return this.syncFst;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.topVer);
        U.writeGridUuid((DataOutput)out, (IgniteUuid)this.id);
        U.writeMap((ObjectOutput)out, this.parts);
        out.writeLong(this.gridActivationTime);
        out.writeBoolean(this.syncFst);
        if (this.syncFst) {
            out.writeLong(this.sentEntryCnt);
            U.writeMap((ObjectOutput)out, null);
        }
        out.writeLong(this.startTime);
        U.writeUuid((DataOutput)out, (UUID)this.nodeId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.topVer = (AffinityTopologyVersion)in.readObject();
        this.id = U.readGridUuid((DataInput)in);
        this.parts = U.readMap((ObjectInput)in);
        try {
            this.gridActivationTime = in.readLong();
            this.syncFst = in.readBoolean();
            if (this.syncFst) {
                this.sentEntryCnt = in.readLong();
                U.readMap((ObjectInput)in);
            }
            this.startTime = in.readLong();
            this.nodeId = U.readUuid((DataInput)in);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public String toString() {
        return S.toString(CacheDrStateTransferInfo.class, (Object)this);
    }
}

