/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.store.local;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class CacheFileLocalStoreChannelScanner {
    private final ByteBuffer buf;
    private final SeekableByteChannel ch;

    public CacheFileLocalStoreChannelScanner(ByteBuffer buf, SeekableByteChannel ch) {
        assert (ch != null);
        assert (buf.capacity() >= 8);
        CacheFileLocalStoreChannelScanner.clear(buf);
        this.buf = buf;
        this.ch = ch;
    }

    private void need(int bytes) throws IOException {
        if (this.buf.remaining() < bytes) {
            this.buf.compact();
            this.ch.read(this.buf);
            this.buf.flip();
            if (this.buf.remaining() < bytes) {
                throw new EOFException();
            }
        }
    }

    public byte get() throws IOException {
        this.need(1);
        return this.buf.get();
    }

    public short getShort() throws IOException {
        this.need(2);
        return this.buf.getShort();
    }

    public int getInt() throws IOException {
        this.need(4);
        return this.buf.getInt();
    }

    public long getLong() throws IOException {
        this.need(8);
        return this.buf.getLong();
    }

    public boolean skip(long bytes) throws IOException {
        assert (bytes >= 0L) : bytes;
        if (bytes == 0L) {
            return true;
        }
        if (bytes <= (long)this.buf.remaining()) {
            this.buf.position(this.buf.position() + (int)bytes);
        } else {
            long newPos = this.position() + bytes;
            if (newPos > this.ch.size()) {
                return false;
            }
            CacheFileLocalStoreChannelScanner.clear(this.buf);
            this.ch.position(newPos);
        }
        return true;
    }

    private static void clear(ByteBuffer buf) {
        buf.clear();
        buf.limit(0);
    }

    public long position() throws IOException {
        return this.ch.position() - (long)this.buf.remaining();
    }
}

