/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.store.local;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.store.local.CacheFileLocalStoreMap;
import org.jetbrains.annotations.Nullable;

public class CacheFileLocalStoreStripedMap
implements AutoCloseable {
    private final CacheFileLocalStoreMap[] segments;
    private final int shift;
    private final GridLongList zeroKeyVals = new GridLongList();

    public CacheFileLocalStoreStripedMap(int segmentsNum, int segmentCap) {
        if (segmentCap == 0) {
            segmentCap = 64;
        }
        assert (U.isPow2((int)segmentsNum)) : "segmentsNum must be positive and power of 2: " + segmentsNum;
        assert (U.isPow2((int)segmentCap)) : "segmentCap must be power of 2: " + segmentCap;
        this.segments = new CacheFileLocalStoreMap[segmentsNum];
        this.shift = 32 - Integer.numberOfTrailingZeros(segmentsNum);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new CacheFileLocalStoreMap(segmentCap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int key, long val) {
        CacheFileLocalStoreMap t;
        assert (val >>> 48 == 0L) : val;
        if ((key = U.hash((int)key)) == 0) {
            GridLongList gridLongList = this.zeroKeyVals;
            synchronized (gridLongList) {
                this.zeroKeyVals.add(val);
            }
        }
        CacheFileLocalStoreMap cacheFileLocalStoreMap = t = this.segment(key);
        synchronized (cacheFileLocalStoreMap) {
            t.add(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(int key, long oldVal, long newVal) {
        CacheFileLocalStoreMap t;
        assert (newVal >>> 48 == 0L);
        if ((key = U.hash((int)key)) == 0) {
            GridLongList gridLongList = this.zeroKeyVals;
            synchronized (gridLongList) {
                return this.zeroKeyVals.replaceValue(0, oldVal, newVal) != -1;
            }
        }
        CacheFileLocalStoreMap cacheFileLocalStoreMap = t = this.segment(key);
        synchronized (cacheFileLocalStoreMap) {
            return t.replace(key, oldVal, newVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int key, long val) {
        CacheFileLocalStoreMap t;
        assert (val >>> 48 == 0L) : val;
        if ((key = U.hash((int)key)) == 0) {
            GridLongList gridLongList = this.zeroKeyVals;
            synchronized (gridLongList) {
                return this.zeroKeyVals.removeValue(0, val) != -1;
            }
        }
        CacheFileLocalStoreMap cacheFileLocalStoreMap = t = this.segment(key);
        synchronized (cacheFileLocalStoreMap) {
            return t.remove(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridLongList get(int key) {
        CacheFileLocalStoreMap t;
        key = U.hash((int)key);
        GridLongList res = null;
        if (key == 0) {
            GridLongList gridLongList = this.zeroKeyVals;
            synchronized (gridLongList) {
                if (!this.zeroKeyVals.isEmpty()) {
                    res = new GridLongList();
                    res.addAll(this.zeroKeyVals);
                }
            }
        }
        CacheFileLocalStoreMap cacheFileLocalStoreMap = t = this.segment(key);
        synchronized (cacheFileLocalStoreMap) {
            res = t.get(key, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int key, long val) {
        CacheFileLocalStoreMap t;
        if ((key = U.hash((int)key)) == 0) {
            GridLongList gridLongList = this.zeroKeyVals;
            synchronized (gridLongList) {
                return this.zeroKeyVals.contains(val);
            }
        }
        CacheFileLocalStoreMap cacheFileLocalStoreMap = t = this.segment(key);
        synchronized (cacheFileLocalStoreMap) {
            return t.contains(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int res = 0;
        CacheFileLocalStoreMap[] cacheFileLocalStoreMapArray = this.zeroKeyVals;
        synchronized (this.zeroKeyVals) {
            res += this.zeroKeyVals.size();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            cacheFileLocalStoreMapArray = this.segments;
            int n = cacheFileLocalStoreMapArray.length;
            for (int i = 0; i < n; ++i) {
                CacheFileLocalStoreMap t;
                CacheFileLocalStoreMap cacheFileLocalStoreMap = t = cacheFileLocalStoreMapArray[i];
                synchronized (cacheFileLocalStoreMap) {
                    res += t.size(true);
                    continue;
                }
            }
            return res;
        }
    }

    private CacheFileLocalStoreMap segment(int hash) {
        return this.segments[hash >>> this.shift];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(CacheFileLocalStoreMap.Closure c) throws IgniteCheckedException {
        CacheFileLocalStoreMap[] cacheFileLocalStoreMapArray = this.zeroKeyVals;
        synchronized (this.zeroKeyVals) {
            for (int i = 0; i < this.zeroKeyVals.size(); ++i) {
                c.apply(this.zeroKeyVals.get(i));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            cacheFileLocalStoreMapArray = this.segments;
            int n = cacheFileLocalStoreMapArray.length;
            for (int i = 0; i < n; ++i) {
                CacheFileLocalStoreMap t;
                CacheFileLocalStoreMap cacheFileLocalStoreMap = t = cacheFileLocalStoreMapArray[i];
                synchronized (cacheFileLocalStoreMap) {
                    t.iterate(c);
                    continue;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CacheFileLocalStoreMap[] cacheFileLocalStoreMapArray = this.segments;
        int n = cacheFileLocalStoreMapArray.length;
        for (int i = 0; i < n; ++i) {
            CacheFileLocalStoreMap t;
            CacheFileLocalStoreMap cacheFileLocalStoreMap = t = cacheFileLocalStoreMapArray[i];
            synchronized (cacheFileLocalStoreMap) {
                t.close();
                continue;
            }
        }
    }
}

