/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

abstract class DrAbstractMetricsMBeanAdapter<T> {
    protected final GridKernalContext ctx;
    private final Class<T> beanIntf;
    private ObjectName mBeanName;
    private String name;

    DrAbstractMetricsMBeanAdapter(GridKernalContext ctx, String name, Class<T> beanIntf) {
        this.ctx = ctx;
        this.name = name;
        this.beanIntf = beanIntf;
    }

    public abstract void reset();

    public String toString() {
        return S.toString(DrAbstractMetricsMBeanAdapter.class, (Object)this);
    }

    void registerMBean() {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            this.mBeanName = U.registerMBean((MBeanServer)this.ctx.config().getMBeanServer(), (String)this.ctx.igniteInstanceName(), (String)"dr", (String)this.name, (Object)this, this.beanIntf);
        }
        catch (JMException e) {
            throw new IgniteException("Failed to register DR receiver hub MBean.", (Throwable)e);
        }
    }

    void unregister() {
        if (this.mBeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.ctx.config().getMBeanServer().unregisterMBean(this.mBeanName);
        }
        catch (JMException e) {
            throw new IgniteException("Failed to register DR receiver hub MBean.", (Throwable)e);
        }
    }
}

