/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrReceiverMetrics;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.cache.dr.CacheDrStateTransfer;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.dr.DrReceiverInMetrics;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.dr.DrSender;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderOutMetrics;
import org.gridgain.grid.internal.processors.cache.dr.GridGainCacheDrManager;
import org.gridgain.grid.internal.processors.dr.DrMetricsManager;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrReceiverInMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrSenderOutMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.jetbrains.annotations.Nullable;

public class DrImpl
implements GridDr,
Externalizable {
    private static final long serialVersionUID = 0L;
    private DrProcessor drProc;
    private GridCacheProcessor cacheProc;
    private Collection<Byte> allDcIds;
    private GridKernalContext ctx;

    public DrImpl() {
    }

    DrImpl(DrProcessor drProc, GridKernalContext ctx) {
        assert (drProc != null);
        assert (ctx.cache() != null);
        this.drProc = drProc;
        this.ctx = ctx;
        this.cacheProc = ctx.cache();
        ArrayList<Byte> allDcIds0 = new ArrayList<Byte>(31);
        for (int i = 1; i < 32; ++i) {
            byte dc = (byte)i;
            if (F.eq((Object)drProc.ggConfig().getDataCenterId(), (Object)dc)) continue;
            allDcIds0.add((byte)i);
        }
        this.allDcIds = allDcIds0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<?> stateTransfer(String cacheName, boolean sync, byte ... dataCenterIds) {
        IgniteFutureImpl igniteFutureImpl;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            Collection<Byte> dcIds;
            if (F.isEmpty((byte[])dataCenterIds)) {
                dcIds = this.allDcIds;
            } else {
                dcIds = new ArrayList<Byte>(dataCenterIds.length);
                for (byte id : dataCenterIds) {
                    dcIds.add(id);
                }
            }
            igniteFutureImpl = new IgniteFutureImpl(this.dr(cacheName).drStateTransfer(dcIds, sync));
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return igniteFutureImpl;
    }

    @Override
    public IgniteFuture<?> stateTransfer(String cacheName, byte ... dataCenterIds) {
        return this.stateTransfer(cacheName, false, dataCenterIds);
    }

    @Override
    public IgniteFuture<?> cancelStateTransfer(IgniteUuid uid) {
        IgniteFutureImpl igniteFutureImpl;
        Objects.requireNonNull(uid);
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            igniteFutureImpl = new IgniteFutureImpl(this.drProc.cancelStateTransfer(uid));
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return igniteFutureImpl;
    }

    @Override
    public Collection<CacheDrStateTransfer> listStateTransfers(String cacheName) {
        Collection<CacheDrStateTransfer> collection;
        Objects.requireNonNull(cacheName);
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            collection = this.dr(cacheName).drListStateTransfers();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return collection;
    }

    @Override
    public Collection<CacheDrStateTransfer> listStateTransfers() {
        Collection<CacheDrStateTransfer> collection;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            collection = this.drProc.listStateTransfers();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return collection;
    }

    @Override
    @Deprecated
    public void pause(String cacheName) {
        this.stopReplication(cacheName);
    }

    @Override
    @Deprecated
    public void resume(String cacheName) {
        this.startReplication(cacheName);
    }

    @Override
    public void stopReplication(String cacheName) {
        try {
            this.ctx.cache().awaitStarted();
            this.ctx.gateway().readLock();
            try {
                this.dr(cacheName).drStop();
            }
            finally {
                this.ctx.gateway().readUnlock();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public void startReplication(String cacheName) {
        try {
            this.ctx.cache().awaitStarted();
            this.ctx.gateway().readLock();
            try {
                if (this.cacheProc.internalCache(cacheName) == null) {
                    return;
                }
                this.dr(cacheName).drStart();
            }
            finally {
                this.ctx.gateway().readUnlock();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    @Nullable
    public CacheDrStatus senderCacheStatus(String cacheName) {
        CacheDrStatus cacheDrStatus;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            cacheDrStatus = this.dr(cacheName).drStopState();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return cacheDrStatus;
    }

    @Override
    public CacheDrSenderMetrics senderCacheMetrics(String cacheName) {
        CacheDrSenderMetrics cacheDrSenderMetrics;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            cacheDrSenderMetrics = this.dr(cacheName).metrics().drSendMetrics();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return cacheDrSenderMetrics;
    }

    @Override
    public CacheDrReceiverMetrics receiverCacheMetrics(String cacheName) {
        CacheDrReceiverMetrics cacheDrReceiverMetrics;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            cacheDrReceiverMetrics = this.dr(cacheName).metrics().drReceiveMetrics();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return cacheDrReceiverMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderInMetrics senderInMetrics(String cacheName) {
        DrSenderInMetrics drSenderInMetrics;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            drSenderInMetrics = metrics.senderHubInMetrics(cacheName);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drSenderInMetrics;
    }

    @Override
    public DrSenderInMetrics senderAggregatedInMetrics() {
        DrSenderInMetrics drSenderInMetrics;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            drSenderInMetrics = metrics.senderHubInMetrics();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drSenderInMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderOutMetrics senderOutMetrics(byte destDataCenterId, @Nullable String cacheName) {
        DrSenderOutMetrics drSenderOutMetrics;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            drSenderOutMetrics = metrics.senderHubOutMetrics(destDataCenterId, cacheName);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drSenderOutMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderOutMetrics senderAggregatedOutMetrics(byte destDataCenterId) {
        DrSenderOutMetricsHolder drSenderOutMetricsHolder;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            drSenderOutMetricsHolder = metrics.senderHubOutMetrics(destDataCenterId);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drSenderOutMetricsHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderOutMetrics senderAggregatedOutMetrics(@Nullable String cacheName) {
        DrSenderOutMetricsHolder drSenderOutMetricsHolder;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            drSenderOutMetricsHolder = metrics.senderHubOutMetrics(cacheName);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drSenderOutMetricsHolder;
    }

    @Override
    public DrSenderOutMetrics senderAggregatedOutMetrics() {
        DrSenderOutMetricsHolder drSenderOutMetricsHolder;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            drSenderOutMetricsHolder = metrics.senderHubOutMetrics();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drSenderOutMetricsHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverInMetrics receiverInMetrics(byte srcDataCenterId, @Nullable String cacheName) {
        DrReceiverInMetricsHolder drReceiverInMetricsHolder;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            drReceiverInMetricsHolder = metrics.receiverHubInMetrics(srcDataCenterId, cacheName);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drReceiverInMetricsHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverInMetrics receiverAggregatedInMetrics(byte srcDataCenterId) {
        DrReceiverInMetricsHolder drReceiverInMetricsHolder;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            drReceiverInMetricsHolder = metrics.receiverHubInMetrics(srcDataCenterId);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drReceiverInMetricsHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverInMetrics receiverAggregatedInMetrics(@Nullable String cacheName) {
        DrReceiverInMetricsHolder drReceiverInMetricsHolder;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            drReceiverInMetricsHolder = metrics.receiverHubInMetrics(cacheName);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drReceiverInMetricsHolder;
    }

    @Override
    public DrReceiverInMetrics receiverAggregatedInMetrics() {
        DrReceiverInMetricsHolder drReceiverInMetricsHolder;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            drReceiverInMetricsHolder = metrics.receiverHubInMetrics();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drReceiverInMetricsHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverOutMetrics receiverOutMetrics(@Nullable String cacheName) {
        DrReceiverOutMetrics drReceiverOutMetrics;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            drReceiverOutMetrics = metrics.receiverHubOutMetrics(cacheName);
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drReceiverOutMetrics;
    }

    @Override
    public DrReceiverOutMetrics receiverAggregatedOutMetrics() {
        DrReceiverOutMetrics drReceiverOutMetrics;
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            drReceiverOutMetrics = metrics.receiverHubOutMetrics();
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
        this.ctx.gateway().readUnlock();
        return drReceiverOutMetrics;
    }

    private GridGainCacheDrManager dr(String cacheName) {
        GridCacheAdapter cache = this.cacheProc.internalCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache is not configured: " + cacheName);
        }
        return DrUtils.drManagerSafe(cache.context().dr(), cacheName);
    }

    @Override
    public void resetMetrics() {
        this.drProc.resetMetrics();
    }

    @Override
    public boolean isLocalSender() {
        return this.drProc.senderHub() != null;
    }

    @Override
    public DrSender localSender() {
        if (!this.isLocalSender()) {
            throw new IllegalStateException("Data center replication sender is not configured for current node.");
        }
        return this.drProc.senderHub();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridKernalContext)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        GridGain plugin = (GridGain)this.ctx.grid().plugin("GridGain");
        return plugin.dr();
    }
}

