/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderOutMetrics;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsMBeanAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverInCacheMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverInCacheMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrReceiverInMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverInMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrReceiverOutMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrReceiverOutMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrSenderInMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrSenderInMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrSenderOutCacheMetricsAdapter;
import org.gridgain.grid.internal.processors.dr.DrSenderOutCacheMetricsAggregate;
import org.gridgain.grid.internal.processors.dr.DrSenderOutMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrSenderStoreMetricsAdapter;
import org.jetbrains.annotations.Nullable;

public class DrMetricsManager {
    private GridKernalContext ctx;
    private ConcurrentHashMap<String, DrSenderInMetricsAdapter> sndHubInMetrics;
    private ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter>[] sndHubOutMetrics;
    private ConcurrentHashMap<String, DrReceiverInCacheMetricsAdapter>[] rcvHubInMetrics;
    private ConcurrentHashMap<String, DrReceiverOutMetricsAdapter> rcvHubOutMetrics;
    private Map<Byte, DrSenderStoreMetricsAdapter> sndOutDcStoreMetrics = new HashMap<Byte, DrSenderStoreMetricsAdapter>();
    private DrSenderStoreMetricsAdapter sndOutGlobalStoreMetrics;
    private DrReceiverInMetricsAdapter rcvInMetrics;

    DrMetricsManager(GridKernalContext ctx, GridGainConfiguration cfg) {
        DrReceiverConfiguration rcvCfg;
        assert (cfg != null);
        this.ctx = ctx;
        DrSenderConfiguration sndCfg = cfg.getDrSenderConfiguration();
        if (sndCfg != null) {
            this.sndHubInMetrics = new ConcurrentHashMap();
            this.sndHubOutMetrics = new ConcurrentHashMap[32];
            for (DrSenderConnectionConfiguration rmtCfg : sndCfg.getConnectionConfiguration()) {
                this.sndHubOutMetrics[rmtCfg.getDataCenterId()] = new ConcurrentHashMap();
            }
        }
        if ((rcvCfg = cfg.getDrReceiverConfiguration()) != null) {
            this.rcvHubInMetrics = new ConcurrentHashMap[32];
            for (int i = 0; i < 32; ++i) {
                this.rcvHubInMetrics[i] = new ConcurrentHashMap();
            }
            this.rcvHubOutMetrics = new ConcurrentHashMap();
        }
    }

    public void registerSenderDcStoreMetrics(byte dcId, LongSupplier storeSizeSup) {
        DrSenderStoreMetricsAdapter m = new DrSenderStoreMetricsAdapter(this.ctx, "sender.store.dc" + dcId, storeSizeSup);
        m.registerMBean();
        this.sndOutDcStoreMetrics.put(dcId, m);
    }

    public void registerSenderGlobalStoreMetrics(LongSupplier storeSizeSup) {
        assert (Objects.isNull(this.sndOutGlobalStoreMetrics));
        this.sndOutGlobalStoreMetrics = new DrSenderStoreMetricsAdapter(this.ctx, "sender.store.global", storeSizeSup);
        this.sndOutGlobalStoreMetrics.registerMBean();
    }

    public DrReceiverInMetricsAdapter registerReceiverMetrics() {
        assert (Objects.isNull(this.rcvInMetrics));
        this.rcvInMetrics = new DrReceiverInMetricsAdapter(this.ctx);
        this.rcvInMetrics.registerMBean();
        return this.rcvInMetrics;
    }

    DrSenderInMetrics senderHubInMetrics(@Nullable String cacheName) {
        if (this.sndHubInMetrics != null) {
            DrSenderInMetricsAdapter metrics = this.senderHubInMetrics0(cacheName, false);
            return new DrSenderInMetricsAggregate(metrics);
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderInMetrics senderHubInMetrics() {
        if (this.sndHubInMetrics != null) {
            DrSenderInMetricsAggregate metricAgg = new DrSenderInMetricsAggregate();
            this.sndHubInMetrics.values().forEach(metricAgg::aggregate);
            return metricAgg;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetrics senderHubOutMetrics(byte destDataCenterId, @Nullable String cacheName) {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, false);
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metrics);
            res.storeSize(this.storeSizeBytes(destDataCenterId));
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetricsHolder senderHubOutMetrics(byte destDataCenterId) {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAggregate metricsAgg = new DrSenderOutCacheMetricsAggregate();
            ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter> metricsMap = this.sndHubOutMetrics[destDataCenterId];
            if (metricsMap == null) {
                throw new IllegalArgumentException("Sender hub doesn't work with data center: " + destDataCenterId);
            }
            metricsMap.values().forEach(metricsAgg::aggregate);
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metricsAgg);
            res.storeSize(this.storeSizeBytes(destDataCenterId));
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetricsHolder senderHubOutMetrics(@Nullable String cacheName) {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAggregate metricsAgg = new DrSenderOutCacheMetricsAggregate();
            Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).map(map -> (DrSenderOutCacheMetricsAdapter)map.get(cacheName)).filter(Objects::nonNull).forEach(metricsAgg::aggregate);
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metricsAgg);
            res.storeSize(this.storeSizeBytes(null));
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrSenderOutMetricsHolder senderHubOutMetrics() {
        if (this.sndHubOutMetrics != null) {
            DrSenderOutCacheMetricsAggregate metricsAgg = new DrSenderOutCacheMetricsAggregate();
            Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).forEach(map -> map.values().forEach(metricsAgg::aggregate));
            DrSenderOutMetricsHolder res = new DrSenderOutMetricsHolder(metricsAgg);
            res.storeSize(this.storeSizeBytes(null));
            return res;
        }
        throw new IllegalStateException("Node is not sender hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics(byte srcDataCenterId, @Nullable String cacheName) {
        if (this.rcvHubInMetrics != null) {
            DrReceiverInCacheMetricsAdapter metrics = this.receiverHubInMetrics0(srcDataCenterId, cacheName, false);
            DrReceiverInCacheMetricsAggregate metricsAgg = new DrReceiverInCacheMetricsAggregate(metrics);
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricsAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.getMessageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics(byte srcDataCenterId) {
        if (this.rcvHubInMetrics != null) {
            DrReceiverInCacheMetricsAggregate metricAgg = new DrReceiverInCacheMetricsAggregate();
            ConcurrentHashMap<String, DrReceiverInCacheMetricsAdapter> metricsMap = this.rcvHubInMetrics[srcDataCenterId];
            metricsMap.values().stream().forEach(metricAgg::aggregate);
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.getMessageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics(@Nullable String cacheName) {
        if (this.rcvHubInMetrics != null) {
            DrReceiverInCacheMetricsAggregate metricAgg = new DrReceiverInCacheMetricsAggregate();
            for (byte i = 0; i < 32; i = (byte)(i + 1)) {
                DrReceiverInCacheMetricsAdapter metrics = this.receiverHubInMetrics0(i, cacheName, false);
                metricAgg.aggregate(metrics);
            }
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.getMessageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverInMetricsHolder receiverHubInMetrics() {
        if (this.rcvHubInMetrics != null) {
            DrReceiverInCacheMetricsAggregate metricAgg = new DrReceiverInCacheMetricsAggregate();
            Arrays.stream(this.rcvHubInMetrics).forEach(map -> map.values().forEach(metricAgg::aggregate));
            DrReceiverInMetricsHolder res = new DrReceiverInMetricsHolder(metricAgg);
            if (this.rcvInMetrics != null) {
                res.messageQueueSizeBytes(this.rcvInMetrics.getMessageQueueSizeBytes());
            }
            return res;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverOutMetrics receiverHubOutMetrics(@Nullable String cacheName) {
        if (this.rcvHubOutMetrics != null) {
            DrReceiverOutMetricsAdapter metrics = this.receiverHubOutMetrics0(cacheName, false);
            return new DrReceiverOutMetricsAggregate(metrics);
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    DrReceiverOutMetrics receiverHubOutMetrics() {
        if (this.rcvHubOutMetrics != null) {
            DrReceiverOutMetricsAggregate metricAgg = new DrReceiverOutMetricsAggregate();
            this.rcvHubOutMetrics.values().forEach(metricAgg::aggregate);
            return metricAgg;
        }
        throw new IllegalStateException("Node is not receiver hub.");
    }

    @Nullable
    private DrReceiverInCacheMetricsAdapter receiverHubInMetrics0(byte srcDataCenterId, @Nullable String cacheName, boolean create) {
        if (this.rcvHubInMetrics != null) {
            ConcurrentHashMap<String, DrReceiverInCacheMetricsAdapter> metricsMap = this.rcvHubInMetrics[srcDataCenterId];
            DrReceiverInCacheMetricsAdapter metrics = metricsMap.get(cacheName = CU.mask((String)cacheName));
            if (metrics == null && create) {
                metrics = new DrReceiverInCacheMetricsAdapter(this.ctx, srcDataCenterId, cacheName);
                DrReceiverInCacheMetricsAdapter oldMetrics = metricsMap.putIfAbsent(cacheName, metrics);
                if (oldMetrics != null) {
                    metrics = oldMetrics;
                } else {
                    metrics.registerMBean();
                }
            }
            return metrics;
        }
        return null;
    }

    private DrReceiverOutMetricsAdapter receiverHubOutMetrics0(@Nullable String cacheName, boolean create) {
        if (this.rcvHubOutMetrics != null) {
            DrReceiverOutMetricsAdapter metrics = this.rcvHubOutMetrics.get(cacheName = CU.mask((String)cacheName));
            if (metrics == null && create) {
                metrics = new DrReceiverOutMetricsAdapter(this.ctx, cacheName);
                DrReceiverOutMetricsAdapter oldMetrics = this.rcvHubOutMetrics.putIfAbsent(cacheName, metrics);
                if (oldMetrics != null) {
                    metrics = oldMetrics;
                } else {
                    metrics.registerMBean();
                }
            }
            return metrics;
        }
        return null;
    }

    private DrSenderInMetricsAdapter senderHubInMetrics0(String cacheName, boolean create) {
        if (this.sndHubInMetrics != null) {
            DrSenderInMetricsAdapter metrics = this.sndHubInMetrics.get(cacheName = CU.mask((String)cacheName));
            if (metrics == null && create) {
                metrics = new DrSenderInMetricsAdapter(this.ctx, cacheName);
                DrSenderInMetricsAdapter oldMetrics = this.sndHubInMetrics.putIfAbsent(cacheName, metrics);
                if (oldMetrics != null) {
                    metrics = oldMetrics;
                } else {
                    metrics.registerMBean();
                }
            }
            return metrics;
        }
        return null;
    }

    private DrSenderOutCacheMetricsAdapter senderHubOutMetrics0(byte destDataCenterId, @Nullable String cacheName, boolean create) {
        ConcurrentHashMap<String, DrSenderOutCacheMetricsAdapter> metricsMap;
        if (this.sndHubOutMetrics != null && (metricsMap = this.sndHubOutMetrics[destDataCenterId]) != null) {
            DrSenderOutCacheMetricsAdapter metrics = (DrSenderOutCacheMetricsAdapter)metricsMap.get(cacheName = CU.mask((String)cacheName));
            if (metrics == null && create) {
                metrics = new DrSenderOutCacheMetricsAdapter(this.ctx, destDataCenterId, cacheName);
                DrSenderOutCacheMetricsAdapter oldMetrics = metricsMap.putIfAbsent(cacheName, metrics);
                if (oldMetrics != null) {
                    metrics = oldMetrics;
                } else {
                    metrics.registerMBean();
                }
            }
            return metrics;
        }
        return null;
    }

    public void onSenderHubBatchReceived(String cacheName, int entryCnt, int byteCnt) {
        assert (this.sndHubInMetrics != null);
        DrSenderInMetricsAdapter cacheMetrics = this.senderHubInMetrics0(cacheName, true);
        assert (cacheMetrics != null);
        cacheMetrics.onBatchReceived(entryCnt, byteCnt);
    }

    public void onSenderHubEntryFiltered(String cacheName, long entryCnt, long byteCnt) {
        assert (this.sndHubInMetrics != null);
        DrSenderInMetricsAdapter cacheMetrics = this.senderHubInMetrics0(cacheName, true);
        assert (cacheMetrics != null);
        cacheMetrics.onEntriesFiltered(entryCnt, byteCnt);
    }

    public void onSenderHubBatchSent(byte destDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt) {
        assert (this.sndHubOutMetrics != null);
        DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, true);
        assert (metrics != null);
        metrics.onBatchSent(entryCnt, byteCnt);
    }

    public void onSenderHubBatchAcked(byte destDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt, long dur) {
        assert (this.sndHubOutMetrics != null);
        DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, true);
        assert (metrics != null);
        metrics.onBatchAcked(entryCnt, byteCnt, dur);
    }

    public void onSenderHubBatchFailed(byte destDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt) {
        assert (this.sndHubOutMetrics != null);
        DrSenderOutCacheMetricsAdapter metrics = this.senderHubOutMetrics0(destDataCenterId, cacheName, true);
        assert (metrics != null);
        metrics.onBatchFailed(entryCnt, byteCnt);
    }

    public void onReceiverHubBatchReceived(byte srcDataCenterId, @Nullable String cacheName, int entryCnt, int byteCnt) {
        assert (this.rcvHubInMetrics != null);
        DrReceiverInCacheMetricsAdapter metrics = this.receiverHubInMetrics0(srcDataCenterId, cacheName, true);
        assert (metrics != null);
        metrics.onBatchReceived(entryCnt, byteCnt);
    }

    public void onReceiverHubBatchSent(@Nullable String cacheName, int entryCnt, int byteCnt) {
        assert (this.rcvHubOutMetrics != null);
        DrReceiverOutMetricsAdapter metrics = this.receiverHubOutMetrics0(cacheName, true);
        assert (metrics != null);
        metrics.onBatchSent(entryCnt, byteCnt);
    }

    public void onReceiverHubBatchAcked(@Nullable String cacheName, int entryCnt, int byteCnt, long dur) {
        assert (this.rcvHubOutMetrics != null);
        DrReceiverOutMetricsAdapter metrics = this.receiverHubOutMetrics0(cacheName, true);
        assert (metrics != null);
        metrics.onBatchAcked(entryCnt, byteCnt, dur);
    }

    public void reset() {
        if (this.rcvHubInMetrics != null) {
            Arrays.stream(this.rcvHubInMetrics).filter(Objects::nonNull).forEach(map -> map.values().forEach(DrReceiverInCacheMetricsAdapter::reset));
        }
        if (this.rcvHubOutMetrics != null) {
            this.rcvHubOutMetrics.values().forEach(DrReceiverOutMetricsAdapter::reset);
        }
        if (this.sndHubOutMetrics != null) {
            Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).forEach(map -> map.values().forEach(DrSenderOutCacheMetricsAdapter::reset));
        }
        if (this.sndHubInMetrics != null) {
            this.sndHubInMetrics.values().forEach(DrSenderInMetricsAdapter::reset);
        }
    }

    void onCacheDestroy(String cacheName) {
        DrAbstractMetricsMBeanAdapter metric;
        if (!F.isEmpty((Object[])this.sndHubOutMetrics)) {
            Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).forEach(map -> {
                DrSenderOutCacheMetricsAdapter metric = (DrSenderOutCacheMetricsAdapter)map.remove(cacheName);
                if (metric != null) {
                    metric.unregister();
                }
            });
        }
        if (!F.isEmpty(this.sndHubInMetrics) && (metric = this.sndHubInMetrics.remove(cacheName)) != null) {
            metric.unregister();
        }
        if (!F.isEmpty((Object[])this.rcvHubInMetrics)) {
            Arrays.stream(this.rcvHubInMetrics).filter(Objects::nonNull).forEach(map -> {
                DrReceiverInCacheMetricsAdapter metric = (DrReceiverInCacheMetricsAdapter)map.remove(cacheName);
                if (metric != null) {
                    metric.unregister();
                }
            });
        }
        if (!F.isEmpty(this.rcvHubOutMetrics) && (metric = this.rcvHubOutMetrics.remove(cacheName)) != null) {
            metric.unregister();
        }
    }

    @Deprecated
    private long storeSizeBytes(Byte dcId) {
        if (this.sndOutGlobalStoreMetrics != null) {
            return this.sndOutGlobalStoreMetrics.getStoreSize();
        }
        if (this.sndOutDcStoreMetrics != null) {
            if (dcId == null) {
                return this.sndOutDcStoreMetrics.values().stream().mapToLong(DrSenderStoreMetricsAdapter::getStoreSize).sum();
            }
            assert (Objects.nonNull(this.sndOutDcStoreMetrics.get(dcId)));
            return this.sndOutDcStoreMetrics.get(dcId).getStoreSize();
        }
        return 0L;
    }

    void stop() {
        if (!F.isEmpty((Object[])this.sndHubOutMetrics)) {
            Arrays.stream(this.sndHubOutMetrics).filter(Objects::nonNull).forEach(map -> {
                map.values().forEach(DrAbstractMetricsMBeanAdapter::unregister);
                map.clear();
            });
        }
        if (!F.isEmpty(this.sndHubInMetrics)) {
            this.sndHubInMetrics.values().forEach(DrAbstractMetricsMBeanAdapter::unregister);
            this.sndHubInMetrics.clear();
        }
        if (!F.isEmpty((Object[])this.rcvHubInMetrics)) {
            Arrays.stream(this.rcvHubInMetrics).filter(Objects::nonNull).forEach(map -> {
                map.values().forEach(DrAbstractMetricsMBeanAdapter::unregister);
                map.clear();
            });
        }
        if (!F.isEmpty(this.rcvHubOutMetrics)) {
            this.rcvHubOutMetrics.values().forEach(DrAbstractMetricsMBeanAdapter::unregister);
            this.rcvHubOutMetrics.clear();
        }
        if (this.sndOutGlobalStoreMetrics != null) {
            this.sndOutGlobalStoreMetrics.unregister();
            this.sndOutGlobalStoreMetrics = null;
        }
        if (!F.isEmpty(this.sndOutDcStoreMetrics)) {
            this.sndOutDcStoreMetrics.values().forEach(DrAbstractMetricsMBeanAdapter::unregister);
            this.sndOutDcStoreMetrics.clear();
        }
        if (this.rcvInMetrics != null) {
            this.rcvInMetrics.unregister();
            this.rcvInMetrics = null;
        }
    }
}

