/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverInCacheMetricsMBean;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsMBeanAdapter;

class DrReceiverInCacheMetricsAdapter
extends DrAbstractMetricsMBeanAdapter<DrReceiverInCacheMetricsMBean>
implements DrReceiverInCacheMetricsMBean {
    private static final String DR_RECEIVER_IN_REG_NAME = "receiver.";
    private final LongAdder batchesReceived = new LongAdder();
    private final LongAdder entriesReceived = new LongAdder();
    private final LongAdder bytesReceived = new LongAdder();

    DrReceiverInCacheMetricsAdapter(GridKernalContext ctx, byte dcId, String cacheName) {
        super(ctx, "receiver.dc" + dcId + "." + cacheName, DrReceiverInCacheMetricsMBean.class);
    }

    @Override
    public long getBatchesReceived() {
        return this.batchesReceived.longValue();
    }

    @Override
    public long getEntriesReceived() {
        return this.entriesReceived.longValue();
    }

    @Override
    public long getBytesReceived() {
        return this.bytesReceived.longValue();
    }

    public void onBatchReceived(int entriesCnt, int bytesCnt) {
        this.batchesReceived.increment();
        this.entriesReceived.add(entriesCnt);
        this.bytesReceived.add(bytesCnt);
    }

    @Override
    public void reset() {
        this.batchesReceived.reset();
        this.entriesReceived.reset();
        this.bytesReceived.reset();
    }

    @Override
    public String toString() {
        return S.toString(DrReceiverInCacheMetricsAdapter.class, (Object)this);
    }
}

