/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverInCacheMetrics;
import org.gridgain.grid.dr.DrReceiverInCacheMetricsMBean;
import org.gridgain.grid.internal.processors.dr.DrReceiverInCacheMetricsAdapter;
import org.jetbrains.annotations.Nullable;

class DrReceiverInCacheMetricsAggregate
implements DrReceiverInCacheMetrics {
    private long batchesReceived;
    private long entriesReceived;
    private long bytesReceived;

    public DrReceiverInCacheMetricsAggregate() {
    }

    public DrReceiverInCacheMetricsAggregate(@Nullable DrReceiverInCacheMetricsAdapter m) {
        if (m != null) {
            this.batchesReceived = m.getBatchesReceived();
            this.entriesReceived = m.getEntriesReceived();
            this.bytesReceived = m.getBytesReceived();
        }
    }

    @Override
    public int batchesReceived() {
        return (int)this.batchesReceived;
    }

    @Override
    public long entriesReceived() {
        return this.entriesReceived;
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived;
    }

    public void aggregate(DrReceiverInCacheMetricsMBean m) {
        if (m != null) {
            this.batchesReceived += m.getBatchesReceived();
            this.entriesReceived += m.getEntriesReceived();
            this.bytesReceived += m.getBytesReceived();
        }
    }

    public String toString() {
        return S.toString(DrReceiverInCacheMetricsAggregate.class, (Object)this);
    }
}

