/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverOutMetricsMBean;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsMBeanAdapter;

class DrReceiverOutMetricsAdapter
extends DrAbstractMetricsMBeanAdapter<DrReceiverOutMetricsMBean>
implements DrReceiverOutMetricsMBean {
    private static final String DR_RECEIVER_OUT_REG_NAME = "receiver.";
    private final LongAdder batchesAcked = new LongAdder();
    private final LongAdder entriesAcked = new LongAdder();
    private final LongAdder bytesAcked = new LongAdder();
    private final LongAdder batchesSent = new LongAdder();
    private final LongAdder entriesSent = new LongAdder();
    private final LongAdder bytesSent = new LongAdder();
    private final LongAdder ackSndTime = new LongAdder();

    DrReceiverOutMetricsAdapter(GridKernalContext ctx, String cacheName) {
        super(ctx, DR_RECEIVER_OUT_REG_NAME + cacheName, DrReceiverOutMetricsMBean.class);
    }

    @Override
    public void reset() {
        this.batchesAcked.reset();
        this.entriesAcked.reset();
        this.bytesAcked.reset();
        this.batchesSent.reset();
        this.entriesSent.reset();
        this.bytesSent.reset();
        this.ackSndTime.reset();
    }

    @Override
    public long getBatchesAcked() {
        return this.batchesAcked.longValue();
    }

    @Override
    public long getEntriesAcked() {
        return this.entriesAcked.longValue();
    }

    @Override
    public long getBytesAcked() {
        return this.bytesAcked.longValue();
    }

    @Override
    public long getBatchesSent() {
        return this.batchesSent.longValue();
    }

    @Override
    public long getEntriesSent() {
        return this.entriesSent.longValue();
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent.longValue();
    }

    @Override
    public double getAverageBatchAckTime() {
        long batches = this.getBatchesAcked();
        return batches > 0L ? (double)this.ackSndTime.longValue() * 1.0 / (double)batches : 0.0;
    }

    long ackSendTime() {
        return this.ackSndTime.longValue();
    }

    public void onBatchSent(int entryCnt, long byteCnt) {
        this.batchesSent.increment();
        this.entriesSent.add(entryCnt);
        this.bytesSent.add(byteCnt);
    }

    public void onBatchAcked(int entryCnt, long byteCnt, long spentTime) {
        this.batchesAcked.increment();
        this.ackSndTime.add(spentTime);
        this.entriesAcked.add(entryCnt);
        this.bytesAcked.add(byteCnt);
    }

    @Override
    public String toString() {
        return S.toString(DrReceiverOutMetricsAdapter.class, (Object)this);
    }
}

