/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.internal.processors.dr.DrReceiverOutMetricsAdapter;
import org.jetbrains.annotations.Nullable;

class DrReceiverOutMetricsAggregate
implements DrReceiverOutMetrics {
    private long batchesAcked;
    private long entriesAcked;
    private long bytesAcked;
    private long batchesSent;
    private long entriesSent;
    private long bytesSent;
    private long ackSndTime;

    public DrReceiverOutMetricsAggregate() {
    }

    public DrReceiverOutMetricsAggregate(@Nullable DrReceiverOutMetricsAdapter m) {
        if (m != null) {
            this.batchesAcked = m.getBatchesAcked();
            this.entriesAcked = m.getEntriesAcked();
            this.bytesAcked = m.getBytesAcked();
            this.batchesSent = m.getBatchesSent();
            this.entriesSent = m.getEntriesSent();
            this.bytesSent = m.getBytesSent();
            this.ackSndTime = m.ackSendTime();
        }
    }

    @Override
    public int batchesAcked() {
        return (int)this.batchesAcked;
    }

    @Override
    public long entriesAcked() {
        return this.entriesAcked;
    }

    @Override
    public long bytesAcked() {
        return this.bytesAcked;
    }

    @Override
    public int batchesSent() {
        return (int)this.batchesSent;
    }

    @Override
    public long entriesSent() {
        return this.entriesSent;
    }

    @Override
    public long bytesSent() {
        return this.bytesSent;
    }

    @Override
    public double averageBatchAckTime() {
        int batches = this.batchesAcked();
        return batches > 0 ? (double)this.ackSndTime * 1.0 / (double)batches : 0.0;
    }

    public void aggregate(DrReceiverOutMetricsAdapter m) {
        if (m != null) {
            this.batchesAcked += m.getBatchesAcked();
            this.entriesAcked += m.getEntriesAcked();
            this.bytesAcked += m.getBytesAcked();
            this.batchesSent += m.getBatchesSent();
            this.entriesSent += m.getEntriesSent();
            this.bytesSent += m.getBytesSent();
            this.ackSndTime += m.ackSendTime();
        }
    }

    public String toString() {
        return S.toString(DrReceiverOutMetricsAggregate.class, (Object)this);
    }
}

