/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderInMetricsMBean;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsMBeanAdapter;

class DrSenderInMetricsAdapter
extends DrAbstractMetricsMBeanAdapter<DrSenderInMetricsMBean>
implements DrSenderInMetricsMBean {
    private static final String DR_SENDER_IN_REG_NAME = "sender.";
    private final LongAdder batchesReceived = new LongAdder();
    private final LongAdder entriesReceived = new LongAdder();
    private final LongAdder bytesReceived = new LongAdder();
    private LongAdder entriesFiltered = new LongAdder();
    private LongAdder bytesFiltered = new LongAdder();

    DrSenderInMetricsAdapter(GridKernalContext ctx, String cacheName) {
        super(ctx, DR_SENDER_IN_REG_NAME + cacheName, DrSenderInMetricsMBean.class);
    }

    @Override
    public long getBatchesReceived() {
        return this.batchesReceived.longValue();
    }

    @Override
    public long getEntriesReceived() {
        return this.entriesReceived.longValue();
    }

    @Override
    public long getBytesReceived() {
        return this.bytesReceived.longValue();
    }

    @Override
    public long getEntriesFiltered() {
        return this.entriesFiltered.longValue();
    }

    @Override
    public long getBytesFiltered() {
        return this.bytesFiltered.longValue();
    }

    @Override
    public void reset() {
        this.batchesReceived.reset();
        this.entriesReceived.reset();
        this.bytesReceived.reset();
        this.entriesFiltered.reset();
        this.bytesFiltered.reset();
    }

    void onBatchReceived(long entryCnt, long bytesCnt) {
        this.batchesReceived.increment();
        this.entriesReceived.add(entryCnt);
        this.bytesReceived.add(bytesCnt);
    }

    void onEntriesFiltered(long entryCnt, long bytesCnt) {
        this.entriesFiltered.add(entryCnt);
        this.bytesFiltered.add(bytesCnt);
    }

    @Override
    public String toString() {
        return S.toString(DrSenderInMetricsAdapter.class, (Object)this);
    }
}

