/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderInMetricsMBean;
import org.gridgain.grid.internal.processors.dr.DrSenderInMetricsAdapter;
import org.jetbrains.annotations.Nullable;

class DrSenderInMetricsAggregate
implements DrSenderInMetrics {
    private long batchesReceived;
    private long entriesReceived;
    private long bytesReceived;

    public DrSenderInMetricsAggregate() {
    }

    public DrSenderInMetricsAggregate(@Nullable DrSenderInMetricsMBean m) {
        if (m != null) {
            this.batchesReceived = m.getBatchesReceived();
            this.entriesReceived = m.getEntriesReceived();
            this.bytesReceived = m.getBytesReceived();
        }
    }

    @Override
    public int batchesReceived() {
        return (int)this.batchesReceived;
    }

    @Override
    public long entriesReceived() {
        return this.entriesReceived;
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived;
    }

    void aggregate(DrSenderInMetricsAdapter m) {
        if (m != null) {
            this.batchesReceived += m.getBatchesReceived();
            this.entriesReceived += m.getEntriesReceived();
            this.bytesReceived += m.getBytesReceived();
        }
    }

    public String toString() {
        return S.toString(DrSenderInMetricsAggregate.class, (Object)this);
    }
}

