/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.dr.DrSender;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderMBean;
import org.gridgain.grid.internal.processors.dr.DrMetricsManager;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrSenderOutMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrUtils;

public class DrSenderMBeanImpl
implements DrSenderMBean {
    private final DrSenderConfiguration cfg;
    private final DrSender drSender;
    private final DrProcessor proc;

    public DrSenderMBeanImpl(DrProcessor proc, DrSender drSender) {
        this.proc = proc;
        this.drSender = drSender;
        this.cfg = drSender.getConfiguration();
    }

    @Override
    public int getMaxQueueSize() {
        return this.cfg.getMaxQueueSize();
    }

    @Override
    public long getHealthCheckFrequency() {
        return this.cfg.getHealthCheckFrequency();
    }

    @Override
    public long getSystemRequestTimeout() {
        return this.cfg.getSystemRequestTimeout();
    }

    @Override
    public long getReadTimeout() {
        return this.cfg.getReadTimeout();
    }

    @Override
    public int getMaxFailedConnectAttempts() {
        return this.cfg.getMaxFailedConnectAttempts();
    }

    @Override
    public int getMaxErrors() {
        return this.cfg.getMaxErrors();
    }

    @Override
    public long getReconnectOnFailureTimeout() {
        return this.cfg.getReconnectOnFailureTimeout();
    }

    @Override
    public String getCacheNames() {
        return "Cache names [" + F.concat(Arrays.asList(this.cfg.getCacheNames()), (String)", ") + ']';
    }

    @Override
    public void pause() {
        this.drSender.pause();
    }

    @Override
    public void pause(byte dcId) {
        this.drSender.pause(dcId);
    }

    @Override
    public boolean paused(byte dcId) {
        return this.drSender.paused(dcId);
    }

    @Override
    public void resume() {
        this.drSender.resume();
    }

    @Override
    public void resume(byte dcId) {
        this.drSender.resume(dcId);
    }

    @Override
    public String getSenderGroups() {
        String groups = this.proc.ggConfig().isDrUseCacheNames() ? "" : F.concat(Arrays.asList(DrUtils.effectiveSenderGroups(this.cfg)), (String)", ");
        return "Sender groups [" + groups + ']';
    }

    @Override
    public String remoteDataCentersFormatted() {
        Collection rmtDataCenters0 = F.viewReadOnly(Arrays.asList(this.cfg.getConnectionConfiguration()), (IgniteClosure)new IgniteClosure<DrSenderConnectionConfiguration, String>(){
            private static final long serialVersionUID = 0L;

            public String apply(DrSenderConnectionConfiguration e) {
                return e.toString();
            }
        }, (IgnitePredicate[])new IgnitePredicate[0]);
        return "Remote data centers [" + F.concat((Iterable)rmtDataCenters0, (String)", ") + ']';
    }

    @Override
    public String metricsFormatted() {
        DrMetricsManager m = this.proc.metrics();
        DrSenderInMetrics in = m.senderHubInMetrics();
        DrSenderOutMetricsHolder out = m.senderHubOutMetrics();
        assert (in != null);
        assert (out != null);
        return "Metrics [" + in + ", " + out + ']';
    }
}

