/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderOutCacheMetricsMBean;
import org.gridgain.grid.internal.processors.dr.DrAbstractMetricsMBeanAdapter;

class DrSenderOutCacheMetricsAdapter
extends DrAbstractMetricsMBeanAdapter<DrSenderOutCacheMetricsMBean>
implements DrSenderOutCacheMetricsMBean {
    private static final String DR_SENDER_OUT_REG_NAME = "sender.";
    private final LongAdder batchesSent = new LongAdder();
    private final LongAdder entriesSent = new LongAdder();
    private final LongAdder bytesSent = new LongAdder();
    private final LongAdder batchesAcked = new LongAdder();
    private final LongAdder entriesAcked = new LongAdder();
    private final LongAdder bytesAcked = new LongAdder();
    private final LongAdder ackSndTime = new LongAdder();
    private final LongAdder batchesFailed = new LongAdder();
    private final LongAdder entriesFailed = new LongAdder();
    private final LongAdder bytesFailed = new LongAdder();

    DrSenderOutCacheMetricsAdapter(GridKernalContext ctx, byte dcId, String cacheName) {
        super(ctx, "sender.dc" + dcId + "." + cacheName, DrSenderOutCacheMetricsMBean.class);
    }

    @Override
    public long getBatchesSent() {
        return this.batchesSent.longValue();
    }

    @Override
    public long getEntriesSent() {
        return this.entriesSent.longValue();
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent.longValue();
    }

    @Override
    public long getBatchesAcked() {
        return this.batchesAcked.longValue();
    }

    @Override
    public long getEntriesAcked() {
        return this.entriesAcked.longValue();
    }

    @Override
    public long getBytesAcked() {
        return this.bytesAcked.longValue();
    }

    @Override
    public double getAverageBatchAckTime() {
        long acked = this.getBatchesAcked();
        return acked > 0L ? (double)this.ackSendTime() * 1.0 / (double)acked : 0.0;
    }

    @Override
    public long getBatchesFailed() {
        return this.batchesFailed.longValue();
    }

    @Override
    public long getEntriesFailed() {
        return this.entriesFailed.longValue();
    }

    @Override
    public long getBytesFailed() {
        return this.bytesFailed.longValue();
    }

    long ackSendTime() {
        return this.ackSndTime.longValue();
    }

    void onBatchSent(int entryCnt, int byteCnt) {
        this.batchesSent.increment();
        this.entriesSent.add(entryCnt);
        this.bytesSent.add(byteCnt);
    }

    void onBatchAcked(int entryCnt, int byteCnt, long spentTime) {
        this.batchesAcked.increment();
        this.entriesAcked.add(entryCnt);
        this.bytesAcked.add(byteCnt);
        this.ackSndTime.add(spentTime);
    }

    void onBatchFailed(int entryCnt, int byteCnt) {
        this.batchesFailed.increment();
        this.entriesFailed.add(entryCnt);
        this.bytesFailed.add(byteCnt);
    }

    @Override
    public void reset() {
        this.batchesSent.reset();
        this.entriesSent.reset();
        this.bytesSent.reset();
        this.batchesAcked.reset();
        this.entriesAcked.reset();
        this.bytesAcked.reset();
        this.ackSndTime.reset();
    }

    @Override
    public String toString() {
        return S.toString(DrSenderOutCacheMetricsAdapter.class, (Object)this);
    }
}

