/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.io.GridUnsafeDataInput;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;
import org.apache.ignite.internal.util.lang.GridTuple4;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.dr.GridGainCacheDrManager;
import org.gridgain.grid.internal.processors.dr.DrSenderMetadataHolder;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalBatchRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalBatchResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalHandshakeRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalHandshakeResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMetadataRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMetadataResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalPingRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalPingResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrUtils {
    public static final byte RESCHEDULE = 1;
    public static final String DFLT_SENDER_GROUP_NAME = "<default>";
    public static final String[] DFLT_SENDER_GROUPS = new String[]{"<default>"};
    public static final String DFLT_GLOBAL_STORE_NAME = "global";
    public static ByteOrder DR_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static boolean DR_SND_DIRECT_BUF = true;
    public static final int MAX_DATA_CENTERS = 32;
    private static final byte TYP_HND_REQ = 0;
    private static final byte TYP_HND_RESP = 1;
    private static final byte TYP_PING_REQ = 2;
    private static final byte TYP_PING_RESP = 3;
    private static final byte TYP_BATCH_REQ = 4;
    private static final byte TYP_BATCH_RESP = 5;
    private static final byte TYP_META_REQ = 6;
    private static final byte TYP_META_RESP = 7;
    private static final DrExternalPingRequest PING_REQ = new DrExternalPingRequest();
    private static final DrExternalPingResponse PING_RESP = new DrExternalPingResponse();
    public static final byte[] PING_REQ_BYTES = new byte[]{2};
    public static final byte[] PING_RESP_BYTES = new byte[]{3};

    public static GridCacheRawVersionedEntry readDrEntry(DataInput in, byte dataCenterId) throws IOException {
        long expireTime;
        long ttl;
        byte[] keyBytes = U.readByteArray((DataInput)in);
        byte[] valBytes = U.readByteArray((DataInput)in);
        if (in.readBoolean()) {
            ttl = in.readLong();
            expireTime = in.readLong();
        } else {
            ttl = 0L;
            expireTime = 0L;
        }
        GridCacheVersion ver = new GridCacheVersion(in.readInt(), in.readLong(), in.readInt(), (int)dataCenterId);
        return new GridCacheRawVersionedEntry(keyBytes, valBytes, ttl, expireTime, ver);
    }

    public static void writeDrEntry(DataOutput out, GridCacheRawVersionedEntry entry) throws IOException {
        assert (entry.keyBytes() != null);
        U.writeByteArray((DataOutput)out, (byte[])entry.keyBytes());
        U.writeByteArray((DataOutput)out, (byte[])entry.valueBytes());
        if (entry.ttl() > 0L) {
            out.writeBoolean(true);
            out.writeLong(entry.ttl());
            out.writeLong(entry.expireTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(entry.version().topologyVersion());
        out.writeLong(entry.version().order());
        out.writeInt(entry.version().nodeOrder());
    }

    public static <K, V> int drEntrySize(GridCacheRawVersionedEntry<K, V> entry) {
        assert (entry.keyBytes() != null);
        int size = 17;
        size += 4 + entry.keyBytes().length;
        size += 4 + (entry.valueBytes() == null ? 0 : entry.valueBytes().length);
        if (entry.ttl() > 0L) {
            size += 16;
        }
        return size;
    }

    public static byte[] marshal(DrExternalHandshakeResponse resp) throws IgniteCheckedException {
        int size = 2;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(1);
            U.writeString((DataOutput)out, (String)resp.errorMessage());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR handshake response.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalBatchRequest req) throws IgniteCheckedException {
        assert (req.dataBytes() != null) : "DR batch request is not prepared: " + req;
        int size = 40 + req.dataSize();
        String cacheName = req.cacheName();
        if (cacheName != null) {
            size += 4 + cacheName.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(4);
            U.writeGridUuid((DataOutput)out, (IgniteUuid)req.requestId());
            U.writeString((DataOutput)out, (String)cacheName);
            out.writeInt(req.entryCount());
            out.writeInt(req.dataSize());
            out.writeByte((int)req.dataCenterId());
            U.writeByteArray((DataOutput)out, (byte[])req.dataBytes(), (int)req.dataSize());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR batch request.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalHandshakeRequest req) throws IgniteCheckedException {
        int size = 13 + req.protocolVersion().length() + req.marshallerClassName().length();
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(0);
            out.writeByte((int)req.dataCenterId());
            U.writeString((DataOutput)out, (String)req.protocolVersion());
            U.writeString((DataOutput)out, (String)req.marshallerClassName());
            out.writeBoolean(req.awaitAcknowledge());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR handshake request.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalBatchResponse resp) throws IgniteCheckedException {
        int size = 27;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(5);
            U.writeGridUuid((DataOutput)out, (IgniteUuid)resp.requestId());
            U.writeString((DataOutput)out, (String)resp.errorMessage());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR batch response.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalMetadataRequest req, boolean usingBinaryMarshaller) throws IgniteCheckedException {
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(128);
        try {
            out.writeByte(6);
            out.writeLong(req.version());
            for (Map.Entry<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> entry : req.metadata().entrySet()) {
                out.writeBoolean(true);
                out.writeUTF(entry.getKey());
                IgniteBiTuple<Byte, Integer> tup = entry.getValue().value();
                out.writeByte((int)((Byte)tup.get1()).byteValue());
                out.writeInt(((Integer)tup.get2()).intValue());
            }
            out.writeBoolean(false);
            if (usingBinaryMarshaller) {
                for (DrSenderMetadataHolder.Versioned versioned : req.binaryMetadata()) {
                    out.writeBoolean(true);
                    ((BinaryMetadata)versioned.value()).writeTo((DataOutput)out);
                }
                out.writeBoolean(false);
            }
            return out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR metadata request.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalMetadataResponse resp) throws IgniteCheckedException {
        int size = 10;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(7);
            out.writeLong(resp.version());
            U.writeString((DataOutput)out, (String)resp.errorMessage());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR metadata response.", (Throwable)e);
        }
    }

    public static Object unmarshal(byte[] data) throws IgniteCheckedException {
        return DrUtils.unmarshal(data, false);
    }

    public static Object unmarshal(byte[] data, boolean usingBinaryMarshaller) throws IgniteCheckedException {
        assert (data != null);
        GridUnsafeDataInput in = new GridUnsafeDataInput();
        in.bytes(data, data.length);
        try {
            byte typ = in.readByte();
            switch (typ) {
                case 0: {
                    return new DrExternalHandshakeRequest(in.readByte(), U.readString((DataInput)in), U.readString((DataInput)in), in.readBoolean());
                }
                case 1: {
                    return new DrExternalHandshakeResponse(U.readString((DataInput)in));
                }
                case 2: {
                    return PING_REQ;
                }
                case 3: {
                    return PING_RESP;
                }
                case 4: {
                    IgniteUuid reqId = U.readGridUuid((DataInput)in);
                    String cacheName = U.readString((DataInput)in);
                    int entryCnt = in.readInt();
                    in.readInt();
                    byte dataCenterId = in.readByte();
                    byte[] dataBytes = U.readByteArray((DataInput)in);
                    return new DrExternalBatchRequest(reqId, cacheName, dataCenterId, entryCnt, dataBytes, dataBytes.length);
                }
                case 5: {
                    return new DrExternalBatchResponse(U.readGridUuid((DataInput)in), U.readString((DataInput)in));
                }
                case 6: {
                    long ver = in.readLong();
                    HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> meta = new HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>>();
                    while (in.readBoolean()) {
                        String cls = in.readUTF();
                        byte platformId = in.readByte();
                        int typeId = in.readInt();
                        meta.put(cls, new DrSenderMetadataHolder.Versioned<IgniteBiTuple>(0L, F.t((Object)platformId, (Object)typeId)));
                    }
                    ArrayList<DrSenderMetadataHolder.Versioned<BinaryMetadata>> binaryMeta = new ArrayList<DrSenderMetadataHolder.Versioned<BinaryMetadata>>();
                    if (usingBinaryMarshaller) {
                        while (in.readBoolean()) {
                            BinaryMetadata binaryMetadataEntry = new BinaryMetadata();
                            binaryMetadataEntry.readFrom((DataInput)in);
                            binaryMeta.add(new DrSenderMetadataHolder.Versioned<BinaryMetadata>(0L, binaryMetadataEntry));
                        }
                    }
                    return new DrExternalMetadataRequest(ver, meta, binaryMeta);
                }
                case 7: {
                    return new DrExternalMetadataResponse(in.readLong(), U.readString((DataInput)in));
                }
            }
            throw new IgniteCheckedException("Unknown DR message type: " + typ);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to unmarshal DR message.", (Throwable)e);
        }
    }

    @NotNull
    public static String effectiveSenderGroup(CacheDrSenderConfiguration cfg) {
        return cfg.getSenderGroup() == null ? DFLT_SENDER_GROUP_NAME : cfg.getSenderGroup();
    }

    @NotNull
    public static String[] effectiveSenderGroups(DrSenderConfiguration cfg) {
        return F.isEmpty((Object[])cfg.getSenderGroups()) ? DFLT_SENDER_GROUPS : cfg.getSenderGroups();
    }

    public static GridTuple4<IgniteUuid, String, Integer, Integer> batchRequestHeader(byte[] data) throws IgniteCheckedException {
        GridUnsafeDataInput in = new GridUnsafeDataInput();
        in.bytes(data, data.length);
        try {
            in.skipBytes(1);
            return F.t((Object)U.readGridUuid((DataInput)in), (Object)U.readString((DataInput)in), (Object)in.readInt(), (Object)in.readInt());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to read DR batch request header.", (Throwable)e);
        }
    }

    public static GridGainCacheDrManager drManagerSafe(GridCacheDrManager mgr, @Nullable String cacheName) {
        if (mgr instanceof GridGainCacheDrManager) {
            return (GridGainCacheDrManager)mgr;
        }
        throw new IgniteException("Data center replication is not configured for cache: " + cacheName);
    }

    public static boolean isDrSenderEnabled(CacheConfiguration ccfg) {
        GridGainCacheConfiguration ggCfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)ccfg, GridGainCacheConfiguration.class);
        return ggCfg != null && ggCfg.getDrSenderConfiguration() != null;
    }

    public static boolean isDrEnabled(GridGainConfiguration ggCcfg) {
        return ggCcfg != null && ggCcfg.getDataCenterId() > 0;
    }

    public static boolean isDrEnabled(GridGainCacheConfiguration ggCcfg) {
        return ggCcfg != null && (ggCcfg.getDrSenderConfiguration() != null || ggCcfg.isDrReceiverEnabled());
    }

    public static int size(DrInternalRequest req) {
        int res = req.cacheName().getBytes().length;
        res += 4 + req.dataCenterIds().size();
        res += 4 + req.entries().stream().mapToInt(e -> 11 + e.dataBytes().length).sum();
        return res += 14;
    }

    private DrUtils() {
    }
}

