/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.fst;

import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.jetbrains.annotations.Nullable;

abstract class DrAffinityAwareWorker
extends GridWorker {
    private final GridKernalContext ctx;
    private final CountDownLatch started;

    protected DrAffinityAwareWorker(GridKernalContext ctx, String name, IgniteLogger log, CountDownLatch started, @Nullable GridWorkerListener lsnr) {
        super(ctx.igniteInstanceName(), name, log, lsnr);
        this.ctx = ctx;
        this.started = started;
    }

    protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
        this.awaitInitialized();
        this.body0();
    }

    protected abstract void body0() throws InterruptedException, IgniteInterruptedCheckedException;

    private void awaitInitialized() throws InterruptedException {
        this.started.await();
        GridCacheSharedContext sctx = this.ctx.cache().context();
        GridDhtPartitionsExchangeFuture topFuture = sctx.exchange().lastTopologyFuture();
        assert (topFuture != null) : "DR Worker should start after join to topology (last exchange future is null)";
        try {
            IgniteInternalFuture affinityReadyFuture = sctx.exchange().affinityReadyFuture(topFuture.initialVersion());
            affinityReadyFuture.get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to wait for affinity ready future [topVer=" + topFuture.initialVersion() + "]", (Throwable)e);
        }
    }
}

