/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.store;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.store.DrMetadataAwareStore;
import org.gridgain.grid.internal.processors.dr.store.DrStoreManager;

public class DrCommonStoreManager
extends DrStoreManager {
    private final DrMetadataAwareStore drStore;

    public DrCommonStoreManager(GridKernalContext ctx, DrProcessor proc, long fstBufferSize, DrSenderStore store) {
        super(ctx, proc, fstBufferSize);
        this.initStoreDefaults(store, null);
        this.drStore = new DrMetadataAwareStore(ctx, store);
    }

    @Override
    public boolean isGlobalStore() {
        return true;
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.drStore.start();
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        this.drStore.onKernalStart();
        this.proc.metrics().registerSenderGlobalStoreMetrics(this.drStore.getStore()::sizeBytes);
    }

    @Override
    public void stop() {
        super.stop();
        this.drStore.stop();
    }

    @Override
    public DrMetadataAwareStore getStore(byte dcID) {
        return this.drStore;
    }

    @Override
    public void clearGlobalStore() throws IgniteCheckedException {
        this.drStore.clear();
    }

    @Override
    public void storeRegularBatch(byte[] dataCenterIds, byte[] data, int cnt) throws IgniteCheckedException {
        this.drStore.store(dataCenterIds, data, cnt);
        for (byte id : dataCenterIds) {
            if (this.storeListeners[id] == null) continue;
            this.storeListeners[id].onBatchAdded();
        }
    }
}

