/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.store;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.LoggerResource;
import org.gridgain.grid.dr.store.DrSenderStoreCursor;
import org.gridgain.grid.dr.store.DrSenderStoreCursorClosedException;
import org.gridgain.grid.dr.store.DrSenderStoreEntry;
import org.jetbrains.annotations.Nullable;

public class DrFullStateTransferBuffer
implements LifecycleAware {
    public static final IgniteCheckedException CONCURRENT_CLEAR_EXCEPTION = new IgniteCheckedException("Full state transfer buffer has been cleared.");
    private final Entry DUMMY = Entry.createDummy();
    @LoggerResource
    @GridToStringExclude
    private IgniteLogger log;
    private final Set<Cursor> cursors = Collections.newSetFromMap(new IdentityHashMap());
    private final AtomicLong idGen = new AtomicLong();
    @GridToStringExclude
    private final ReentrantLock lock = new ReentrantLock();
    private final long maxSize;
    private Entry head;
    private Entry tail;
    private volatile long sizeBytes;

    public DrFullStateTransferBuffer(long capacity) {
        this.maxSize = capacity;
    }

    public void start() throws IgniteException {
        this.reset();
    }

    public void stop() throws IgniteException {
        this.clear();
    }

    public long sizeBytes() {
        return this.sizeBytes;
    }

    public long maxSizeBytes() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(byte[] dataCenterIds, byte[] data, int entryCnt, IgniteUuid fstId, GridFutureAdapter<Void> reqFut) {
        assert (fstId != null);
        this.lock.lock();
        try {
            if ((long)data.length > this.maxSize) {
                LT.warn((IgniteLogger)this.log, (String)"Full state transfer buffer capacity is too low.");
            }
            if (this.sizeBytes > 0L && this.sizeBytes + (long)data.length > this.maxSize) {
                boolean bl = false;
                return bl;
            }
            this.sizeBytes += (long)data.length;
            Entry entry = new Entry(this.idGen.incrementAndGet(), data, DrFullStateTransferBuffer.dataCenterIdsToMask(dataCenterIds), fstId, reqFut);
            this.link(entry);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrSenderStoreCursor cursor(byte dataCenterId) {
        this.lock.lock();
        try {
            Cursor res = new Cursor(dataCenterId);
            this.cursors.add(res);
            Cursor cursor = res;
            return cursor;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.reset();
            Iterator<Cursor> iter = this.cursors.iterator();
            while (iter.hasNext()) {
                Cursor cursor = iter.next();
                cursor.internalClose(false);
                iter.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return S.toString(DrFullStateTransferBuffer.class, (Object)this);
    }

    private static long dataCenterIdToMask(byte dcId) {
        return 1L << dcId;
    }

    private static long dataCenterIdsToMask(byte[] dcIds) {
        long res = 0L;
        for (byte dcId : dcIds) {
            res |= DrFullStateTransferBuffer.dataCenterIdToMask(dcId);
        }
        return res;
    }

    private void reset() {
        this.lock.lock();
        try {
            Entry cur = this.head;
            while (cur != null) {
                Entry next = cur.next;
                cur.cleanup();
                cur = next;
            }
            assert (this.DUMMY.prev == null);
            this.DUMMY.next = null;
            this.head = this.tail = this.DUMMY;
            this.sizeBytes = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void link(Entry entry) {
        assert (this.lock.isHeldByCurrentThread());
        assert (entry != null);
        assert (this.head != null);
        assert (this.tail != null);
        assert (entry.next == null);
        assert (this.tail.next == null);
        this.tail.next = entry;
        entry.prev = this.tail;
        this.tail = entry;
        if (this.head == this.DUMMY) {
            this.head = entry;
        }
    }

    private void unlink(Entry entry) {
        assert (this.lock.isHeldByCurrentThread());
        assert (entry != null);
        if (!entry.unlinked) {
            Entry prev = entry.prev;
            Entry next = entry.next;
            if (next == null) {
                assert (entry == this.tail);
            } else {
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
            }
            int size = entry.data().length;
            entry.cleanup();
            this.sizeBytes -= (long)size;
        }
        while (this.head.unlinked && this.head.next != null) {
            this.head = this.head.next;
        }
    }

    private static class Entry {
        private final long id;
        private byte[] data;
        private long dcMask;
        private final IgniteUuid fstId;
        private final GridFutureAdapter<Void> fut;
        @GridToStringExclude
        private Entry next;
        @GridToStringExclude
        private Entry prev;
        private boolean unlinked;

        static Entry createDummy() {
            return new Entry(-1L, null, 0L, null, null);
        }

        Entry(long id, byte[] data, long dcMask, IgniteUuid fstId, GridFutureAdapter<Void> fut) {
            this.id = id;
            this.data = data;
            this.dcMask = dcMask;
            this.fstId = fstId;
            this.fut = fut;
        }

        public byte[] data() {
            return this.data;
        }

        public boolean acknowledge(byte dcId) {
            if (this.dcMask != 0L) {
                this.dcMask &= DrFullStateTransferBuffer.dataCenterIdToMask(dcId) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return this.dcMask == 0L;
        }

        private void cleanup() {
            if (this.unlinked) {
                return;
            }
            this.unlinked = true;
            this.data = null;
            this.prev = null;
            if (this.id >= 0L) {
                if (this.dcMask == 0L) {
                    this.fut.onDone();
                } else {
                    this.fut.onDone((Throwable)CONCURRENT_CLEAR_EXCEPTION);
                }
            }
        }

        public IgniteUuid stateTransferId() {
            return this.fstId;
        }
    }

    private class EntryProxy
    implements DrSenderStoreEntry {
        private final Cursor cursor;
        private final Entry entry;
        private final byte[] data;

        EntryProxy(Cursor cursor, Entry entry) {
            this.entry = entry;
            this.cursor = cursor;
            this.data = entry.data();
        }

        @Override
        public byte[] data() {
            return this.data;
        }

        @Override
        public void acknowledge(byte dcId) {
            DrFullStateTransferBuffer.this.lock.lock();
            try {
                if (this.cursor.closed) {
                    return;
                }
                if (this.entry.acknowledge(dcId)) {
                    DrFullStateTransferBuffer.this.unlink(this.entry);
                }
            }
            finally {
                DrFullStateTransferBuffer.this.lock.unlock();
            }
        }

        @Override
        public IgniteUuid stateTransferId() {
            return this.entry.stateTransferId();
        }

        public String toString() {
            return S.toString(EntryProxy.class, (Object)this);
        }
    }

    private class Cursor
    implements DrSenderStoreCursor {
        private final long mask;
        private Entry last;
        private long lastCheckedId;
        private boolean closed;

        private Cursor(byte dcId) {
            assert (DrFullStateTransferBuffer.this.lock.isHeldByCurrentThread());
            this.mask = DrFullStateTransferBuffer.dataCenterIdToMask(dcId);
        }

        @Override
        @Nullable
        public DrSenderStoreEntry next() throws IgniteCheckedException {
            DrFullStateTransferBuffer.this.lock.lock();
            try {
                if (this.closed) {
                    throw new DrSenderStoreCursorClosedException("Cursor is closed.");
                }
                if (this.last == null) {
                    this.last = DrFullStateTransferBuffer.this.head;
                    assert (this.last != null);
                    if (this.matches(this.last)) {
                        DrSenderStoreEntry drSenderStoreEntry = this.proxy(this, this.last);
                        return drSenderStoreEntry;
                    }
                }
                assert (this.last != null);
                Entry res = null;
                while (res == null && this.last.next != null) {
                    if (this.matches(this.last.next)) {
                        res = this.last.next;
                    }
                    this.last = this.last.next;
                }
                DrSenderStoreEntry drSenderStoreEntry = this.proxy(this, res);
                return drSenderStoreEntry;
            }
            finally {
                DrFullStateTransferBuffer.this.lock.unlock();
            }
        }

        @Override
        public void close() {
            DrFullStateTransferBuffer.this.lock.lock();
            try {
                this.internalClose(true);
            }
            finally {
                DrFullStateTransferBuffer.this.lock.unlock();
            }
        }

        private void internalClose(boolean rmv) {
            if (!this.closed) {
                if (rmv) {
                    DrFullStateTransferBuffer.this.cursors.remove(this);
                }
                this.closed = true;
            }
        }

        private boolean matches(Entry entry) {
            boolean res;
            assert (entry != null);
            boolean bl = res = entry.id > this.lastCheckedId && (entry.dcMask & this.mask) == this.mask && !entry.unlinked;
            if (entry.id > this.lastCheckedId) {
                this.lastCheckedId = entry.id;
            }
            return res;
        }

        private DrSenderStoreEntry proxy(Cursor cursor, @Nullable Entry entry) {
            assert (DrFullStateTransferBuffer.this.lock.isHeldByCurrentThread());
            assert (entry == null || entry.data != null);
            return entry != null ? new EntryProxy(cursor, entry) : null;
        }

        public String toString() {
            return S.toString(Cursor.class, (Object)this);
        }
    }
}

