/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.store;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.event.CacheEntryListenerException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataUpdatedListener;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.marshaller.GridMarshallerMappingProcessor;
import org.apache.ignite.internal.processors.marshaller.MappingUpdatedListener;
import org.apache.ignite.internal.util.io.GridUnsafeDataInput;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.DrSenderStoreCorruptedException;
import org.gridgain.grid.dr.store.DrSenderStoreCursor;
import org.gridgain.grid.dr.store.DrSenderStoreEntry;
import org.gridgain.grid.dr.store.fs.DrSenderFsStore;
import org.gridgain.grid.events.DrStoreEvent;
import org.gridgain.grid.internal.processors.dr.DrSenderMetadataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrMetadataAwareStore {
    private static final byte META_STORE_DC_ID = 1;
    private static final byte[] META_STORE_DC_ID_ARR = new byte[]{1};
    private static final String META_DIR = "meta";
    private static final String BINARY_META_DIR = "meta-binary";
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final GridKernalContext kctx;
    protected final IgniteLogger log;
    private final DrSenderStore store;
    private final DrSenderFsStore metaStore;
    private final DrSenderFsStore binaryMetaStore;
    private final IgniteCacheObjectProcessor cacheObjProc;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final GridMarshallerMappingProcessor mappingProc;
    private DrSenderMetadataHolder meta = DrSenderMetadataHolder.INITIAL;

    DrMetadataAwareStore(GridKernalContext kctx, @NotNull DrSenderStore store) {
        this.kctx = kctx;
        this.store = store;
        this.log = kctx.log(DrMetadataAwareStore.class);
        this.cacheObjProc = kctx.cacheObjects();
        this.mappingProc = kctx.mapping();
        if (store instanceof DrSenderFsStore) {
            String path = ((DrSenderFsStore)store).getDirectoryPath();
            this.metaStore = new DrSenderFsStore();
            this.metaStore.setDirectoryPath(Paths.get(path, META_DIR).toString());
            this.metaStore.setOverflowMode(((DrSenderFsStore)store).getOverflowMode());
            this.binaryMetaStore = new DrSenderFsStore();
            this.binaryMetaStore.setDirectoryPath(Paths.get(path, BINARY_META_DIR).toString());
            this.binaryMetaStore.setOverflowMode(((DrSenderFsStore)store).getOverflowMode());
        } else {
            this.metaStore = null;
            this.binaryMetaStore = null;
        }
    }

    void start() throws IgniteCheckedException {
        IgniteCacheObjectProcessor cacheObjectProc;
        this.kctx.resource().injectGeneric((Object)this.store);
        U.startLifecycleAware(Collections.singleton(this.store));
        if (this.metaStore != null && this.binaryMetaStore != null) {
            this.kctx.resource().injectGeneric((Object)this.metaStore);
            this.kctx.resource().injectGeneric((Object)this.binaryMetaStore);
            U.startLifecycleAware(Collections.singleton(this.metaStore));
            U.startLifecycleAware(Collections.singleton(this.binaryMetaStore));
        }
        if ((cacheObjectProc = this.kctx.cacheObjects()) instanceof CacheObjectBinaryProcessorImpl) {
            ((CacheObjectBinaryProcessorImpl)cacheObjectProc).addBinaryMetadataUpdateListener((BinaryMetadataUpdatedListener)new BinaryMetadataUpdatesListener());
        }
        this.mappingProc.addMappingUpdatedListener((MappingUpdatedListener)new MarshallerUpdatesListener());
    }

    void onKernalStart() throws IgniteCheckedException {
        if (this.metaStore != null && this.binaryMetaStore != null) {
            try {
                this.loadMetadataFromStore();
            }
            catch (DrSenderStoreCorruptedException e) {
                this.recordMetaStoreCorruptedEvt();
                throw e;
            }
        }
        HashMap<String, IgniteBiTuple<Byte, Integer>> initMetas = new HashMap<String, IgniteBiTuple<Byte, Integer>>();
        Iterator mapIt = this.mappingProc.currentMappings();
        while (mapIt.hasNext()) {
            Map.Entry platfMappings = (Map.Entry)mapIt.next();
            Map mapping = (Map)platfMappings.getValue();
            for (Map.Entry e0 : mapping.entrySet()) {
                initMetas.put((String)e0.getValue(), (IgniteBiTuple<Byte, Integer>)F.t(platfMappings.getKey(), e0.getKey()));
            }
        }
        this.update(initMetas);
        HashMap<String, BinaryMetadata> initBinMetas = new HashMap<String, BinaryMetadata>();
        for (BinaryType type : this.cacheObjProc.metadata()) {
            if (!(type instanceof BinaryTypeImpl)) continue;
            BinaryMetadata binMeta = ((BinaryTypeImpl)type).metadata();
            initBinMetas.put(binMeta.typeName(), binMeta);
        }
        this.updateBinaryMetadata(initBinMetas);
    }

    private void recordMetaStoreCorruptedEvt() {
        ClusterNode node = this.kctx.discovery().localNode();
        if (this.kctx.event().isUserRecordable(1027)) {
            this.kctx.event().record((Event)new DrStoreEvent(node, "Meta store corrupted.", 1027, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadataFromStore() throws IgniteCheckedException {
        block37: {
            this.lock.writeLock().lock();
            try {
                HashMap<String, Object> storeVals;
                Throwable throwable;
                DrSenderStoreCursor cursor;
                if (this.isDataStoreEmpty()) {
                    assert (this.meta == DrSenderMetadataHolder.INITIAL);
                    this.metaStore.clear();
                    this.binaryMetaStore.clear();
                    break block37;
                }
                try {
                    cursor = this.metaStore.cursor((byte)1);
                    throwable = null;
                    try {
                        DrSenderStoreEntry metaEntry;
                        storeVals = new HashMap<String, IgniteBiTuple<Byte, Integer>>();
                        while ((metaEntry = cursor.next()) != null) {
                            IgniteBiTuple<String, IgniteBiTuple<Byte, Integer>> tuple = this.unmarshal(metaEntry.data());
                            storeVals.put((String)tuple.get1(), (IgniteBiTuple<Byte, Integer>)tuple.get2());
                        }
                        this.update(storeVals);
                    }
                    catch (Throwable metaEntry) {
                        throwable = metaEntry;
                        throw metaEntry;
                    }
                    finally {
                        if (cursor != null) {
                            if (throwable != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable metaEntry) {
                                    throwable.addSuppressed(metaEntry);
                                }
                            } else {
                                cursor.close();
                            }
                        }
                    }
                }
                catch (IgniteCheckedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
                try {
                    cursor = this.binaryMetaStore.cursor((byte)1);
                    throwable = null;
                    try {
                        DrSenderStoreEntry binaryMetaEntry;
                        storeVals = new HashMap();
                        while ((binaryMetaEntry = cursor.next()) != null) {
                            BinaryMetadata binaryMetadata = this.unmarshalBinaryMetadata(binaryMetaEntry.data());
                            storeVals.put(binaryMetadata.typeName(), (IgniteBiTuple<Byte, Integer>)binaryMetadata);
                        }
                        this.updateBinaryMetadata(storeVals);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cursor != null) {
                            if (throwable != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                cursor.close();
                            }
                        }
                    }
                }
                catch (IgniteCheckedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    void stop() {
        if (this.metaStore != null) {
            U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.metaStore));
        }
        if (this.binaryMetaStore != null) {
            U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.binaryMetaStore));
        }
        U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.store));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DrSenderMetadataHolder getMetadata(long metaVer) {
        DrSenderMetadataHolder metaSnapshot = null;
        this.lock.readLock().lock();
        try {
            if (this.meta.version() > metaVer) {
                metaSnapshot = this.meta;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (metaSnapshot == null) {
            return null;
        }
        HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> commonMetadataDifference = new HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>>();
        for (Map.Entry<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> entry : metaSnapshot.metadata().entrySet()) {
            if (entry.getValue().version() <= metaVer) continue;
            commonMetadataDifference.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> binaryMetadataDifference = new HashMap<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>>();
        for (Map.Entry<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> entry : metaSnapshot.binaryMetadata().entrySet()) {
            if (entry.getValue().version() <= metaVer) continue;
            binaryMetadataDifference.put(entry.getKey(), entry.getValue());
        }
        return new DrSenderMetadataHolder(metaSnapshot.version(), commonMetadataDifference, binaryMetadataDifference);
    }

    public void update(String name, byte platformId, int id) throws IgniteCheckedException {
        assert (name != null);
        this.update(Collections.singletonMap(name, F.t((Object)platformId, (Object)id)));
    }

    public void updateBinaryMetadata(BinaryMetadata binaryMetadata) throws IgniteCheckedException {
        this.updateBinaryMetadata(Collections.singletonMap(binaryMetadata.typeName(), binaryMetadata));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Map<String, IgniteBiTuple<Byte, Integer>> vals) throws IgniteCheckedException {
        if (vals == null || vals.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            long newVersion = this.meta.version() + 1L;
            Map<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> newValues = this.mergeMetadataValues(this.meta.metadata(), vals, newVersion);
            this.saveGeneralMetadataToStore(newValues, newVersion);
            this.meta = new DrSenderMetadataHolder(newVersion, newValues, this.meta.binaryMetadata());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBinaryMetadata(Map<String, BinaryMetadata> vals) throws IgniteCheckedException {
        if (vals == null || vals.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            long newVersion = this.meta.version() + 1L;
            Map<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> newValues = this.mergeMetadataValues(this.meta.binaryMetadata(), vals, newVersion);
            this.saveBinaryMetadataToStore(newValues, newVersion);
            this.meta = new DrSenderMetadataHolder(newVersion, this.meta.metadata(), newValues);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private <T> Map<String, DrSenderMetadataHolder.Versioned<T>> mergeMetadataValues(@Nullable Map<String, DrSenderMetadataHolder.Versioned<T>> oldValues, Map<String, T> newValues, long newVersion) {
        if (oldValues == null) {
            oldValues = Collections.emptyMap();
        }
        HashMap<String, DrSenderMetadataHolder.Versioned<T>> result = new HashMap<String, DrSenderMetadataHolder.Versioned<T>>(oldValues);
        for (Map.Entry<String, T> entry : newValues.entrySet()) {
            DrSenderMetadataHolder.Versioned<Object> oldValue = oldValues.get(entry.getKey());
            if (oldValue != null && oldValue.value().equals(entry.getValue())) continue;
            result.put(entry.getKey(), new DrSenderMetadataHolder.Versioned<T>(newVersion, entry.getValue()));
        }
        return result;
    }

    private void saveGeneralMetadataToStore(Map<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> values, long version) throws IgniteCheckedException {
        if (this.metaStore != null) {
            for (Map.Entry<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> entry : values.entrySet()) {
                if (entry.getValue().version() != version) continue;
                this.metaStore.store(META_STORE_DC_ID_ARR, this.marshal(entry.getKey(), entry.getValue().value()), 1, null);
            }
        }
    }

    private void saveBinaryMetadataToStore(Map<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> values, long version) throws IgniteCheckedException {
        if (this.metaStore != null) {
            for (Map.Entry<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> entry : values.entrySet()) {
                if (entry.getValue().version() != version) continue;
                this.binaryMetaStore.store(META_STORE_DC_ID_ARR, this.marshal(entry.getValue().value()), 1, null);
            }
        }
    }

    private boolean isDataStoreEmpty() {
        return this.store.sizeBytes() == 0L;
    }

    private byte[] marshal(String name, IgniteBiTuple<Byte, Integer> idTuple) {
        byte[] nameBytes = name.getBytes(UTF8);
        BinaryHeapOutputStream stream = new BinaryHeapOutputStream(nameBytes.length + 8);
        stream.writeByte(((Byte)idTuple.get1()).byteValue());
        stream.writeInt(((Integer)idTuple.get2()).intValue());
        stream.writeInt(nameBytes.length);
        stream.writeByteArray(nameBytes);
        return stream.array();
    }

    private byte[] marshal(BinaryMetadata binaryMetadata) throws IgniteCheckedException {
        try {
            GridUnsafeDataOutput out = new GridUnsafeDataOutput(128);
            binaryMetadata.writeTo((DataOutput)out);
            return out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Could not marshal binary metadata.", (Throwable)e);
        }
    }

    private IgniteBiTuple<String, IgniteBiTuple<Byte, Integer>> unmarshal(byte[] data) {
        BinaryHeapInputStream stream = new BinaryHeapInputStream(data);
        byte platformId = stream.readByte();
        int typeId = stream.readInt();
        int nameLen = stream.readInt();
        byte[] nameBytes = stream.readByteArray(nameLen);
        String name = new String(nameBytes, UTF8);
        return F.t((Object)name, (Object)F.t((Object)platformId, (Object)typeId));
    }

    private BinaryMetadata unmarshalBinaryMetadata(byte[] data) throws IgniteCheckedException {
        try {
            GridUnsafeDataInput in = new GridUnsafeDataInput();
            in.bytes(data, data.length);
            BinaryMetadata binaryMetadata = new BinaryMetadata();
            binaryMetadata.readFrom((DataInput)in);
            return binaryMetadata;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Could not unmarshal binary metadata.", (Throwable)e);
        }
    }

    DrSenderStoreCursor createCursor(byte dataCenterId) throws IgniteCheckedException {
        return this.store.cursor(dataCenterId);
    }

    public void store(byte[] dataCenterIds, byte[] data, int cnt) throws IgniteCheckedException {
        this.store.store(dataCenterIds, data, cnt, null);
    }

    public void clear() throws IgniteCheckedException {
        this.store.clear();
    }

    public boolean isOverflow() {
        return this.store.isOverflow();
    }

    public DrSenderStore getStore() {
        return this.store;
    }

    private class BinaryMetadataUpdatesListener
    implements BinaryMetadataUpdatedListener {
        private BinaryMetadataUpdatesListener() {
        }

        public void binaryMetadataUpdated(BinaryMetadata metadata) {
            try {
                DrMetadataAwareStore.this.updateBinaryMetadata(metadata);
            }
            catch (Exception e) {
                throw new CacheEntryListenerException("Failed to process DR marshaller metadata update.", (Throwable)e);
            }
        }
    }

    private class MarshallerUpdatesListener
    implements MappingUpdatedListener {
        private MarshallerUpdatesListener() {
        }

        public void mappingUpdated(byte platformId, int typeId, String typeName) throws CacheEntryListenerException {
            try {
                DrMetadataAwareStore.this.update(typeName, platformId, typeId);
            }
            catch (IgniteCheckedException e) {
                throw new CacheEntryListenerException("Failed to process DR marshaller metadata update.", (Throwable)e);
            }
        }
    }
}

