/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.license;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.util.GridTimerTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginContext;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.events.LicenseEvent;
import org.gridgain.grid.internal.GridPluginProcessorAdapter;
import org.gridgain.grid.internal.processors.license.GridLicenseFeature;
import org.gridgain.grid.internal.processors.license.GridLicenseProfile;
import org.gridgain.grid.internal.processors.license.GridLicenseUtil;
import org.gridgain.grid.internal.processors.license.GridLicenseV2;
import org.gridgain.grid.internal.processors.license.GridLicenseV2Adapter;
import org.gridgain.grid.internal.processors.license.GridProductImpl;
import org.gridgain.grid.internal.util.GridGainProperties;
import org.gridgain.grid.product.ProductLicense;
import org.gridgain.grid.product.ProductLicenseException;
import org.jetbrains.annotations.Nullable;

public class GridEntLicenseProcessor
extends GridPluginProcessorAdapter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String CERT_FILE_NAME = "gglicense.cer";
    private static final String[] LIC_VERS = new String[]{"2.0", "2.1"};
    private static final int SHUTDOWN_DELAY = 60000;
    private static final long PERIODIC_LIC_CHECK_DELAY = 60000L;
    private final long licExpireDaysThreshold = IgniteSystemProperties.getLong((String)"GG_LIC_EXPIRE_DAYS_THRESHOLD", (long)90L);
    public static final String ULTIMATE_FEATURE = "ultimate";
    public static final String ZOS_FEATURE = "zos";
    private static final DateFormat fmt = new SimpleDateFormat("MM/dd/yy");
    private static final AtomicReference<JAXBContext> jaxbCtx = new AtomicReference();
    private static final String EVAL_LIC = "<gridgain-license version=\"2.1\">\n    <id>31c879fe-ae36-406b-8812-911175c94862</id>\n    <issue-date>10/25/2018</issue-date>\n    <maintenance-time>0</maintenance-time>\n    <user-org>GridGain - In-Memory Computing Platform</user-org>\n    <license-note>30 Days Evaluation Only</license-note>\n    <type>ENT</type>\n    <max-nodes>2</max-nodes>\n    <max-cpus>16</max-cpus>\n    <max-computers>2</max-computers>\n    <grace-period>60</grace-period>\n    <max-uptime>0</max-uptime>\n    <signature>302C021469A0167EF97B61778130DF24235330A7D6C5312C0214210CEBAD6AC26E493147E0D1175ECFA36A5EA128</signature>\n    <enabled-feature name=\"ultimate\"/>\n</gridgain-license>";
    private volatile GridLicenseV2 lic;
    private String licContent;
    private long startTime;
    private long graceEnd;
    private boolean violating;
    private volatile long graceLeft = -1L;
    private Timer licTimer;
    private GridProductImpl product;

    public GridEntLicenseProcessor(PluginContext ctx, GridGainConfiguration cfg) {
        super(ctx, cfg);
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        try {
            if (System.getProperty("javax.xml.bind.context.factory") == null) {
                System.setProperty("javax.xml.bind.context.factory", "com.sun.xml.bind.v2.ContextFactory");
            }
            if (jaxbCtx.get() == null) {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{GridLicenseV2Adapter.class});
                jaxbCtx.compareAndSet(null, ctx);
            }
        }
        catch (JAXBException e) {
            throw new IgniteCheckedException("Failed to create JAXB context for " + GridLicenseV2Adapter.class.getSimpleName(), (Throwable)e);
        }
        this.reloadLicense();
        this.product = new GridProductImpl(this.igniteCtx, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadLicense() throws ProductLicenseException {
        GridEntLicenseProcessor gridEntLicenseProcessor = this;
        synchronized (gridEntLicenseProcessor) {
            String licContent = this.getLicenseContent();
            assert (licContent != null);
            if (!licContent.equals(this.licContent) || this.lic == null) {
                GridLicenseV2 tmp;
                try {
                    JAXBContext ctx = jaxbCtx.get();
                    assert (ctx != null) : "Missing JAXB context in reloadLicence.";
                    tmp = (GridLicenseV2)ctx.createUnmarshaller().unmarshal((Reader)new StringReader(licContent));
                }
                catch (JAXBException e) {
                    throw new ProductLicenseException("Failed to load or parse license: " + e.getMessage(), null, e);
                }
                assert (tmp != null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("License is " + (this.lic == null ? "loaded: " : "reloaded: ") + tmp);
                }
                GridEntLicenseProcessor.verifyLicenseIntegrity(tmp, this.log);
                this.licContent = licContent;
                this.lic = tmp;
                if (this.lic.getUpdateNotifierDisabled() != null && this.lic.getUpdateNotifierDisabled().booleanValue()) {
                    this.igniteCtx.cluster().disableUpdateNotifier();
                }
                U.log((IgniteLogger)this.log, (Object)"New license loaded.");
                this.ackLicense();
            }
        }
    }

    private File getFileWithLicense() throws ProductLicenseException {
        File file;
        URL url;
        String licUrl = this.cfg.getLicenseUrl();
        if (licUrl == null) {
            url = U.resolveIgniteUrl((String)"gridgain-license.xml");
            if (url != null) {
                try {
                    licUrl = url.toURI().toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (licUrl == null) {
                throw new ProductLicenseException("License URL is not provided and cannot be determined.", null);
            }
        }
        try {
            url = new URL(licUrl);
        }
        catch (MalformedURLException e) {
            throw new ProductLicenseException("Malformed license URL [url=" + licUrl + ", err=" + e.getMessage() + ']', null, e);
        }
        try {
            file = new File(url.toURI());
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new ProductLicenseException("Failed to load license (make sure you configured license URL using 'file' scheme).", null, e);
        }
        if (!file.exists()) {
            throw new ProductLicenseException("License file not found: " + file.getAbsolutePath(), null);
        }
        if (!file.isFile()) {
            throw new ProductLicenseException("License file is invalid: " + file.getAbsolutePath(), null);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLicenseContent() throws ProductLicenseException {
        String licUrl = this.cfg.getLicenseUrl();
        if (licUrl == null) {
            URL url = U.resolveIgniteUrl((String)"gridgain-license.xml");
            if (url != null) {
                try {
                    licUrl = url.toURI().toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (licUrl == null) {
                return EVAL_LIC;
            }
        }
        try {
            URL url;
            URI uri;
            File f = new File(licUrl);
            if (f.exists()) {
                uri = f.toURI();
                licUrl = uri.toString();
            } else {
                try {
                    if (licUrl.toLowerCase().startsWith("file:")) {
                        URL url2 = new URL(licUrl);
                        uri = new URI("file", null, url2.getPath(), null);
                    } else {
                        uri = new URI(licUrl);
                    }
                }
                catch (URISyntaxException e) {
                    throw new ProductLicenseException("Failed to load license [uri=" + licUrl + ']', null, e);
                }
            }
            boolean isClsPath = "classpath".equalsIgnoreCase(uri.getScheme());
            String clsPath = null;
            if (isClsPath) {
                if (uri.getAuthority() != null) {
                    throw new ProductLicenseException("Classpath URI can not contain authority [uri=" + licUrl + ']', null);
                }
                clsPath = uri.getRawSchemeSpecificPart();
                while (clsPath.startsWith("/")) {
                    clsPath = clsPath.replaceFirst("/", "");
                }
            }
            URL uRL = url = isClsPath ? this.getClass().getClassLoader().getResource(clsPath) : new URL(licUrl);
            if (url == null) {
                throw new ProductLicenseException("Failed to load license from classpath: " + licUrl, null);
            }
            try (Scanner s = new Scanner(url.openStream()).useDelimiter("\\A");){
                if (s.hasNext()) {
                    String string = s.next();
                    return string;
                }
                throw new ProductLicenseException("Failed to load license (license content is empty): " + licUrl, null);
            }
        }
        catch (MalformedURLException e) {
            throw new ProductLicenseException("Malformed license URL [url=" + licUrl + ", err=" + e.getMessage() + ']', null, e);
        }
        catch (IOException e) {
            throw new ProductLicenseException("Failed to load license: " + licUrl, null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLicense(String licTxt) throws ProductLicenseException {
        GridLicenseV2 lic;
        try {
            JAXBContext ctx = jaxbCtx.get();
            assert (ctx != null) : "Missing JAXB context in updateLicence.";
            lic = (GridLicenseV2)ctx.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(licTxt.getBytes(UTF_8)));
        }
        catch (JAXBException e) {
            throw new ProductLicenseException("Failed to load or parse license: " + licTxt, null, e);
        }
        GridEntLicenseProcessor.verifyLicenseIntegrity(lic, this.log);
        this.verifyLicenseViolation(lic);
        File licFile = this.getFileWithLicense();
        GridEntLicenseProcessor gridEntLicenseProcessor = this;
        synchronized (gridEntLicenseProcessor) {
            File licBakFile = new File(licFile.getParentFile(), "gridgain-license.bak." + U.id8((UUID)this.lic.getId()) + ".xml");
            if (!licBakFile.exists()) {
                this.backupOldLicense(licFile, licBakFile);
            }
            this.updateLicense(licTxt, lic, licFile);
        }
    }

    private void updateLicense(String licContent, GridLicenseV2 lic, File licFile) throws ProductLicenseException {
        try (RandomAccessFile file = new RandomAccessFile(licFile, "rw");
             FileChannel ch = file.getChannel();
             FileLock ignored = ch.lock();){
            byte[] b = licContent.getBytes();
            file.write(b);
            file.setLength(b.length);
            this.lic = lic;
            this.licContent = licContent;
        }
        catch (IOException e) {
            throw new ProductLicenseException("Failed to write the new license: " + e.getMessage(), "Write to disk problem.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupOldLicense(File licFile, File licBakFile) throws ProductLicenseException {
        block30: {
            try (RandomAccessFile file2 = new RandomAccessFile(licBakFile, "rw");
                 FileChannel bakCh = file2.getChannel();){
                FileLock fileLock = bakCh.tryLock();
                if (fileLock == null) break block30;
                try {
                    byte[] b = Files.readAllBytes(licFile.toPath());
                    file2.write(b);
                    file2.setLength(b.length);
                }
                finally {
                    fileLock.release();
                }
            }
            catch (OverlappingFileLockException file2) {
            }
            catch (IOException e) {
                throw new ProductLicenseException("Failed to backup old license to " + licBakFile + " " + e.getMessage(), "Backup problem.", e);
            }
        }
    }

    public static void verifyLicenseIntegrity(GridLicenseV2 licV2, IgniteLogger log) throws ProductLicenseException {
        PublicKey key;
        assert (licV2 != null);
        InputStream in = GridEntLicenseProcessor.class.getResourceAsStream(CERT_FILE_NAME);
        if (in == null) {
            throw new ProductLicenseException("License X509 certificate not found: gglicense.cer", "Certificate not found.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            U.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new ProductLicenseException("Failed to read license X509 certificate.", "Problem reading certificate.", e);
        }
        finally {
            U.close((AutoCloseable)in, (IgniteLogger)log);
        }
        byte[] cert = out.toByteArray();
        U.close((AutoCloseable)out, (IgniteLogger)log);
        try {
            key = X509Certificate.getInstance(cert).getPublicKey();
        }
        catch (CertificateException e) {
            throw new ProductLicenseException("Invalid license X509 certificate.", "Invalid X509 certificate.", e);
        }
        try {
            if (!GridLicenseUtil.verifySignatureV2(key, licV2)) {
                throw new ProductLicenseException("License is invalid or has been tempered with.", "Invalid license.");
            }
        }
        catch (GeneralSecurityException e) {
            throw new ProductLicenseException("License is invalid or has been tempered with.", "Invalid license.", e);
        }
        if (!Arrays.asList(LIC_VERS).contains(licV2.getVersion())) {
            throw new ProductLicenseException("Wrong license version (" + licV2.getVersion() + ").", "Wrong version.");
        }
        if (log.isDebugEnabled()) {
            log.debug("License is verified.");
        }
    }

    @Override
    public void onIgniteStart() throws IgniteCheckedException {
        this.startTime = U.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("License processor started.");
        }
        this.checkLicense();
        if (!this.igniteCtx.isDaemon()) {
            this.licTimer = new Timer("ignite-license-checker-" + this.ctx.grid().name());
            this.createPerDayTask(new Runnable(){

                @Override
                public void run() {
                    long expireTime;
                    if (GridEntLicenseProcessor.this.igniteCtx.clientDisconnected()) {
                        return;
                    }
                    GridLicenseV2 lic = GridEntLicenseProcessor.this.lic;
                    assert (lic != null);
                    long now = U.currentTimeMillis();
                    if (lic.getExpireDate() != null && (expireTime = lic.getExpireDate().getTime()) < now + TimeUnit.DAYS.toMillis(GridEntLicenseProcessor.this.licExpireDaysThreshold)) {
                        U.warn((IgniteLogger)GridEntLicenseProcessor.this.log, (Object)("The license will expire on " + GridLicenseUtil.format(lic.getExpireDate()) + ")"));
                    }
                }
            }).run();
            this.licTimer.scheduleAtFixedRate((TimerTask)new GridTimerTask(){

                public void safeRun() throws InterruptedException {
                    block5: {
                        try {
                            GridEntLicenseProcessor.this.checkLicense();
                        }
                        catch (ProductLicenseException ignored) {
                            U.error((IgniteLogger)GridEntLicenseProcessor.this.log, (Object)"License violation is unresolved. Ignite node will shutdown in 60 sec.");
                            U.error((IgniteLogger)GridEntLicenseProcessor.this.log, (Object)"  ^-- Contact your support for immediate assistance (!)");
                            Thread.sleep(60000L);
                            G.stop((String)GridEntLicenseProcessor.this.igniteCtx.igniteInstanceName(), (boolean)true);
                        }
                        catch (IgniteClientDisconnectedException | ClusterTopologyException e) {
                            if (GridEntLicenseProcessor.this.log.isDebugEnabled()) {
                                GridEntLicenseProcessor.this.log.debug("Unable to check the license because the node is out of topology [errMsg=" + e.getMessage() + ']');
                            }
                        }
                        catch (Throwable e) {
                            U.error((IgniteLogger)GridEntLicenseProcessor.this.log, (Object)"Unable to check the license due to system error.", (Throwable)e);
                            U.error((IgniteLogger)GridEntLicenseProcessor.this.log, (Object)"Grid instance will be stopped...");
                            G.stop((String)GridEntLicenseProcessor.this.igniteCtx.igniteInstanceName(), (boolean)true);
                            if (!(e instanceof Error)) break block5;
                            throw e;
                        }
                    }
                }
            }, 60000L, 60000L);
        }
    }

    @Override
    public void onIgniteStop(boolean cancel) {
        if (this.licTimer != null) {
            this.licTimer.cancel();
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug("License processor stopped.");
        }
    }

    private void ackLicense() {
        if (this.log.isInfoEnabled()) {
            GridLicenseV2 lic = this.lic;
            assert (lic != null);
            String note = lic.getLicenseNote();
            if (note == null || note.isEmpty()) {
                note = lic.getIssueDate() != null ? "Licensed to '" + lic.getUserOrganization() + "' on " + DateFormat.getDateInstance().format(lic.getIssueDate()) : "Licensed to '" + lic.getUserOrganization() + "'";
            }
            String txt1 = "License [ID=" + lic.getId().toString().toUpperCase() + ", type=" + (Object)((Object)lic.getType()) + ']';
            SB sb = new SB();
            if (lic.getExpireDate() != null) {
                sb.a("expire-date: ").a(fmt.format(lic.getExpireDate())).a(", ");
            } else {
                sb.a("expire-date: never, ");
            }
            if (lic.getGracePeriod() > 0L) {
                sb.a("grace-burst-period: ").a(lic.getGracePeriod()).a("min., ");
            }
            if (lic.getMaxComputers() > 0) {
                sb.a("max-hosts: ").a(lic.getMaxComputers()).a(", ");
            }
            if (lic.getMaxCpus() > 0) {
                sb.a("max-cpus: ").a(lic.getMaxCpus()).a(", ");
            }
            if (lic.getMaxNodes() > 0) {
                sb.a("max-nodes: ").a(lic.getMaxNodes()).a(", ");
            }
            if (lic.getMaxUpTime() > 0L) {
                sb.a("max-uptime: ").a(lic.getMaxUpTime()).a("min., ");
            }
            if (lic.getVersionRegexp() != null) {
                sb.a("ver-regexp: ").a(lic.getVersionRegexp()).a(", ");
            }
            String attrName = lic.getAttributeName();
            String attrVal = lic.getAttributeValue();
            if (attrName != null && attrVal != null) {
                sb.a("attr: " + attrName + "=" + attrVal + ", ");
            }
            String txt2 = "License limits [" + (sb.length() > 2 ? sb.d(sb.length() - 2, sb.length()).toString() : "<none>") + ']';
            if (this.log.isInfoEnabled()) {
                this.log.info(note);
                this.log.info(txt1);
                this.log.info(txt2);
            }
        }
    }

    public void checkLicense() throws ProductLicenseException {
        long now = U.currentTimeMillis();
        try {
            this.reloadLicense();
            GridLicenseV2 lic = this.lic;
            assert (lic != null);
            this.verifyLicenseViolation(lic);
            this.graceEnd = 0L;
            this.graceLeft = -1L;
            if (this.violating) {
                this.violating = false;
                String msg = "License violation cleared with new license.";
                if (this.igniteCtx.event().isRecordable(1009)) {
                    this.igniteCtx.event().record(this.mkEvent(1009, msg, lic.getId()));
                }
                U.log((IgniteLogger)this.log, (Object)msg);
            }
        }
        catch (ProductLicenseException e) {
            String msg;
            boolean isBursting;
            this.violating = true;
            boolean firstViolation = false;
            if (this.graceEnd == 0L) {
                if (this.lic.getGracePeriod() > 0L) {
                    this.graceEnd = now + this.lic.getGracePeriod() * 60L * 1000L;
                }
                firstViolation = true;
            }
            boolean bl = isBursting = now < this.graceEnd;
            if (firstViolation) {
                if (this.igniteCtx.event().isRecordable(1008)) {
                    this.igniteCtx.event().record(this.mkEvent(1008, e.getMessage(), this.lic.getId()));
                }
                U.error((IgniteLogger)this.log, (Object)e.getMessage());
                String logMsg = "Contact sales@gridgain.com for further assistance.";
                if (this.lic != null) {
                    logMsg = logMsg + " Make sure to include your license ID: " + this.lic.getId().toString().toUpperCase();
                }
                U.error((IgniteLogger)this.log, (Object)logMsg);
            }
            if (isBursting) {
                this.graceLeft = (this.graceEnd - now) / 1000L / 60L;
                msg = "License grace/burst period - left " + U.formatMins((long)this.graceLeft) + '.';
                U.error((IgniteLogger)this.log, (Object)msg);
                if (this.igniteCtx.event().isRecordable(1008)) {
                    this.igniteCtx.event().record(this.mkEvent(1008, msg, this.lic.getId()));
                }
            }
            this.graceLeft = -1L;
            if (this.graceEnd > 0L) {
                msg = "License grace/burst period **expired**.";
                if (this.igniteCtx.event().isRecordable(1010)) {
                    this.igniteCtx.event().record(this.mkEvent(1010, msg, this.lic.getId()));
                }
                U.error((IgniteLogger)this.log, (Object)msg);
            }
            throw e;
        }
    }

    private String formatViolationMessage(Collection<String> msgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("License violation detected:\n");
        int cnt = 0;
        for (String msg : msgs) {
            sb.append("  ^-- ").append(msg);
            if (++cnt >= msgs.size()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private String formatShortViolationMessage(Collection<String> msgs) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (String msg : msgs) {
            sb.append(msg);
            if (++cnt >= msgs.size()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private void verifyLicenseViolation(GridLicenseV2 lic) throws ProductLicenseException {
        Date maintenanceEndDate;
        if (this.igniteCtx.isDaemon() || this.igniteCtx.clientDisconnected()) {
            return;
        }
        Collection<ClusterNode> nodes = null;
        boolean locNodeIncluded = false;
        int maxCpus = 0;
        int maxNodes = 0;
        int maxComputers = 0;
        if (lic.getProfiles() != null) {
            for (GridLicenseProfile profile : lic.getProfiles()) {
                Collection<ClusterNode> profileNodes = this.nodes(profile.getClientMode(), profile.getAttributeName(), profile.getAttributeValue());
                if (!profileNodes.contains(this.igniteCtx.discovery().localNode())) continue;
                nodes = profileNodes;
                locNodeIncluded = true;
                maxCpus = profile.getMaxCpus();
                maxNodes = profile.getMaxNodes();
                maxComputers = profile.getMaxComputers();
                break;
            }
        }
        if (nodes == null) {
            nodes = this.nodes(lic.getClientMode(), lic.getAttributeName(), lic.getAttributeValue());
            locNodeIncluded = nodes.contains(this.igniteCtx.discovery().localNode());
            maxCpus = lic.getMaxCpus();
            maxNodes = lic.getMaxNodes();
            maxComputers = lic.getMaxComputers();
        }
        LinkedList<String> errMsgs = new LinkedList<String>();
        LinkedList<String> shortMsgs = new LinkedList<String>();
        long now = U.currentTimeMillis();
        long upTimeMin = (now - this.startTime) / 1000L / 60L;
        if (lic.getIssueDate() != null && lic.getIssueDate().getTime() > now) {
            errMsgs.add("License has not started yet. Issue date: " + GridLicenseUtil.format(lic.getIssueDate()) + ".");
            shortMsgs.add("License has not started yet.");
        }
        if (lic.getExpireDate() != null && lic.getExpireDate().getTime() <= now) {
            errMsgs.add("License is expired. Expiration date: " + GridLicenseUtil.format(lic.getExpireDate()) + ".");
            shortMsgs.add("License is expired.");
        }
        if ((maintenanceEndDate = this.maintenanceEndDate(lic)) != null && IgniteVersionUtils.VER.releaseDate().after(maintenanceEndDate)) {
            errMsgs.add("Release date is outside of maintenance period. Maintenance end date: " + GridLicenseUtil.format(maintenanceEndDate));
            shortMsgs.add("Release date is outside of maintenance period.");
        }
        if (lic.getMaxUpTime() > 0L && lic.getMaxUpTime() <= upTimeMin) {
            errMsgs.add("Maximum uptime (" + U.formatMins((long)lic.getMaxUpTime()) + ") is exceeded.");
            shortMsgs.add("Uptime is exceeded.");
        }
        if (errMsgs.isEmpty() && lic.getVersionRegexp() != null) {
            try {
                String ver = GridGainProperties.get("gridgain.version");
                if (!Pattern.compile(lic.getVersionRegexp()).matcher(ver).matches()) {
                    errMsgs.add("GridGain version (" + ver + ") does not match regular expression: '" + lic.getVersionRegexp() + "'.");
                    shortMsgs.add("Invalid version.");
                }
            }
            catch (PatternSyntaxException e) {
                errMsgs.add("Invalid license version regular expression: '" + e.getMessage() + "'.");
                shortMsgs.add("Invalid version.");
            }
        }
        if (locNodeIncluded) {
            if (maxCpus > 0 && maxCpus < this.getTotalCpus(nodes)) {
                errMsgs.add("Maximum number of CPUs (" + this.getTotalCpus(nodes) + "/" + maxCpus + ") is exceeded.");
                shortMsgs.add("Number of CPUs is exceeded.");
            }
            if (maxNodes > 0 && maxNodes < this.getTotalNodes(nodes)) {
                errMsgs.add("Maximum number of nodes (" + this.getTotalNodes(nodes) + "/" + maxNodes + ") is exceeded.");
                shortMsgs.add("Number of nodes is exceeded.");
            }
            if (maxComputers > 0 && maxComputers < this.getTotalComputers(nodes)) {
                errMsgs.add("Maximum number of hosts (" + this.getTotalComputers(nodes) + "/" + maxComputers + ") is exceeded.");
                shortMsgs.add("Number of hosts is exceeded.");
            }
        } else {
            errMsgs.add("Local node client mode or attribute value doesn't match license requirements.");
            shortMsgs.add("Invalid client mode or attribute value.");
        }
        assert (errMsgs.size() == shortMsgs.size());
        if (!errMsgs.isEmpty()) {
            throw new ProductLicenseException(this.formatViolationMessage(errMsgs), this.formatShortViolationMessage(shortMsgs));
        }
    }

    private Collection<ClusterNode> nodes(Boolean clientMode, String attrName, String attrVal) {
        Collection all = this.igniteCtx.discovery().allNodes();
        ArrayList<ClusterNode> filtered = new ArrayList<ClusterNode>(all.size());
        for (ClusterNode node : all) {
            if (clientMode != null && clientMode ^ node.isClient() || attrName != null && !F.eq((Object)node.attribute(attrName), (Object)attrVal)) continue;
            filtered.add(node);
        }
        return filtered;
    }

    private Event mkEvent(int type, String msg, UUID licId) {
        assert (msg != null);
        LicenseEvent evt = new LicenseEvent(this.igniteCtx.discovery().localNode(), msg, type);
        evt.licenseId(licId);
        return evt;
    }

    private Date maintenanceEndDate(GridLicenseV2 lic) {
        int maintenanceTime = lic.getMaintenanceTime();
        if (maintenanceTime <= 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(lic.getIssueDate());
        cal.add(2, maintenanceTime);
        return cal.getTime();
    }

    private int getTotalNodes(Collection<ClusterNode> nodes) {
        assert (nodes != null);
        return nodes.size();
    }

    private int getTotalComputers(Collection<ClusterNode> nodes) {
        assert (nodes != null);
        return U.neighborhood(nodes).size();
    }

    private int getTotalCpus(Collection<ClusterNode> nodes) {
        assert (nodes != null);
        int sum = 0;
        for (Collection hood : U.neighborhood(nodes).values()) {
            ClusterNode first = (ClusterNode)F.first((Iterable)hood);
            sum += first == null ? 0 : first.metrics().getTotalCpus();
        }
        return sum;
    }

    @Nullable
    public ProductLicense license() {
        GridLicenseV2 lic = this.lic;
        assert (lic != null);
        return new LicenseImpl(lic);
    }

    public long gracePeriodLeft() {
        return this.graceLeft;
    }

    public GridProduct product() {
        return this.product;
    }

    @Override
    public String toString() {
        return S.toString(GridEntLicenseProcessor.class, (Object)this);
    }

    private TimerTask createPerDayTask(final Runnable job) {
        return new TimerTask(){

            @Override
            public void run() {
                GridEntLicenseProcessor.this.licTimer.schedule(GridEntLicenseProcessor.this.createPerDayTask(job), GridEntLicenseProcessor.this.getDateOfStartOfNextDay());
                try {
                    job.run();
                }
                catch (Throwable e) {
                    U.error((IgniteLogger)GridEntLicenseProcessor.this.log, (Object)"Failed to execute job", (Throwable)e);
                }
            }
        };
    }

    private Date getDateOfStartOfNextDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static class LicenseImpl
    implements ProductLicense {
        private static final long serialVersionUID = 5017234673450008213L;
        private UUID id;
        private String ver;
        private String verRegexp;
        private Date issueDate;
        private int maintenanceTime;
        private String issueOrg;
        private String userOrg;
        private String note;
        private String usrWww;
        private String usrEmail;
        private String usrName;
        private Date expireDate;
        private int maxNodes;
        private int maxComps;
        private int maxCpus;
        private long maxUpTime;
        private long gracePeriod;
        private String attrName;
        private String attrVal;
        private Collection<GridLicenseFeature> enabledFeatures;

        private LicenseImpl(GridLicenseV2 lic) {
            assert (lic != null);
            this.id = lic.getId();
            this.ver = lic.getVersion();
            this.verRegexp = lic.getVersionRegexp();
            this.issueDate = lic.getIssueDate();
            this.maintenanceTime = lic.getMaintenanceTime();
            this.issueOrg = lic.getIssueOrganization();
            this.userOrg = lic.getUserOrganization();
            this.note = lic.getLicenseNote();
            this.usrWww = lic.getUserWww();
            this.usrEmail = lic.getUserEmail();
            this.usrName = lic.getUserName();
            this.expireDate = lic.getExpireDate();
            this.maxNodes = lic.getMaxNodes();
            this.maxComps = lic.getMaxComputers();
            this.maxCpus = lic.getMaxCpus();
            this.maxUpTime = lic.getMaxUpTime();
            this.gracePeriod = lic.getGracePeriod();
            this.attrName = lic.getAttributeName();
            this.attrVal = lic.getAttributeValue();
            this.enabledFeatures = lic.getEnabledFeatures();
        }

        @Override
        public String version() {
            return this.ver;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public String versionRegexp() {
            return this.verRegexp;
        }

        @Override
        public Date issueDate() {
            return this.issueDate;
        }

        @Override
        public int maintenanceTime() {
            return this.maintenanceTime;
        }

        @Override
        public String issueOrganization() {
            return this.issueOrg;
        }

        @Override
        public String userOrganization() {
            return this.userOrg;
        }

        @Override
        public String licenseNote() {
            return this.note;
        }

        @Override
        public String userWww() {
            return this.usrWww;
        }

        @Override
        public String userEmail() {
            return this.usrEmail;
        }

        @Override
        public String userName() {
            return this.usrName;
        }

        @Override
        public Date expireDate() {
            return this.expireDate;
        }

        @Override
        public int maxNodes() {
            return this.maxNodes;
        }

        @Override
        public int maxComputers() {
            return this.maxComps;
        }

        @Override
        public int maxCpus() {
            return this.maxCpus;
        }

        @Override
        public long maxUpTime() {
            return this.maxUpTime;
        }

        @Override
        public long gracePeriod() {
            return this.gracePeriod;
        }

        @Override
        public String attributeName() {
            return this.attrName;
        }

        @Override
        public String attributeValue() {
            return this.attrVal;
        }

        @Override
        public Collection<GridLicenseFeature> getEnabledFeatures() {
            return this.enabledFeatures;
        }

        public String toString() {
            return S.toString(LicenseImpl.class, (Object)this);
        }
    }
}

