/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.nodevalidation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.ru.RollingUpgradeModeChangeResult;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.GridGainFeatures;
import org.gridgain.grid.internal.processors.nodevalidation.DistributedRollingUpgradeStatus;
import org.gridgain.grid.internal.processors.nodevalidation.NodeValidationException;
import org.gridgain.grid.internal.processors.nodevalidation.RollingUpgradeMXBeanImpl;
import org.gridgain.grid.internal.util.GridGainProperties;
import org.gridgain.grid.ru.GridGainRollingUpgradeStatus;
import org.gridgain.grid.ru.RollingUpgradeMXBean;
import org.jetbrains.annotations.Nullable;

public class GridEntDiscoveryNodeValidationProcessor
extends GridProcessorAdapter
implements DiscoveryNodeValidationProcessor {
    public static final String DISTRIBUTED_ROLLING_UPGRADE_STATUS = "distributedRollingUpgradeStatus";
    public static final String ROLLING_UPGRADE_REJECT_MSG = "Local node's build version differs from remote node's [locBuildVer=%s, rmtBuildVer=%s]. The node has been rejected due to disabled Rolling Upgrade. Please consider to enable it via control.sh utility with the following command: `--rolling-upgrade on` or using GridGain.enableRollingUpgrade() method.";
    private static final String ROLLING_UPGRADE_MBEAN_NAME = "RollingUpgrade";
    private static String compVers = GridGainProperties.get("gridgain.compatible.vers");
    private static String incompVers = GridGainProperties.get("gridgain.incompatible.vers");
    private static String vers = GridGainProperties.get("gridgain.version");
    private static final String BUILD_TSTAMP_STR = IgniteVersionUtils.formatBuildTimeStamp((long)(Long.valueOf(GridGainProperties.get("gridgain.build")) * 1000L));
    private final DistributedRollingUpgradeStatus distributedRollingUpgradeStatus = DistributedRollingUpgradeStatus.detachedProperty("distributedRollingUpgradeStatus");
    @GridToStringExclude
    private final Collection<String> compatibleVers;
    @GridToStringExclude
    private final Collection<String> incompatibleVers;
    @GridToStringExclude
    private final boolean isRolUpd;
    @GridToStringExclude
    private final Object mux = new Object();
    @GridToStringExclude
    private GridGainRollingUpgradeStatus rollingUpgradeStatus;
    private volatile ObjectName rollingUpgradeMBeanName;

    public GridEntDiscoveryNodeValidationProcessor(GridKernalContext ctx) {
        super(ctx);
        if (IgniteSystemProperties.getBoolean((String)IgniteFeatures.DISTRIBUTED_ROLLING_UPGRADE_MODE.name(), (boolean)false)) {
            ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
                this.distributedRollingUpgradeStatus.addListener((name, oldVal, newVal) -> {
                    Object object = this.mux;
                    synchronized (object) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Rolling upgrade state was updated [oldVal= " + (Object)oldVal + ", newVal=" + (Object)newVal + "]");
                        }
                        this.rollingUpgradeStatus = newVal;
                    }
                });
                dispatcher.registerProperty((DistributedChangeableProperty)this.distributedRollingUpgradeStatus);
            });
        }
        String[] compatibleVers = compVers.split(",");
        for (int i = 0; i < compatibleVers.length; ++i) {
            compatibleVers[i] = compatibleVers[i].trim();
        }
        String[] incompatibleVers = incompVers.split(",");
        for (int i = 0; i < incompatibleVers.length; ++i) {
            incompatibleVers[i] = incompatibleVers[i].trim();
        }
        this.compatibleVers = Collections.unmodifiableList(Arrays.asList(compatibleVers));
        this.incompatibleVers = Collections.unmodifiableList(Arrays.asList(incompatibleVers));
        GridGain gg = (GridGain)ctx.pluginProvider("GridGain").plugin();
        this.isRolUpd = gg.configuration().isRollingUpdatesEnabled();
    }

    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute("plugins.gg.build.ver", (Object)vers);
        this.ctx.addNodeAttribute("plugins.gg.compatible.vers", this.compatibleVers);
        this.ctx.addNodeAttribute("plugins.gg.incompatible.vers", this.incompatibleVers);
        this.ctx.addNodeAttribute("plugins.gg.build.date", (Object)BUILD_TSTAMP_STR);
        this.ctx.addNodeAttribute("plugins.ggrolling.updates", (Object)this.isRolUpd);
        this.ctx.addNodeAttribute("plugins.gg.supported.features", (Object)GridGainFeatures.allFeatures());
    }

    public void onKernalStart(boolean active) throws IgniteCheckedException {
        Collection remotes = this.ctx.discovery().remoteNodes();
        if (!this.distributedRollingUpgradeAvailable()) {
            for (ClusterNode node : remotes) {
                this.checkRemoteNode(node);
            }
        } else {
            this.registerRollingUpgradeMXBean();
        }
    }

    public void onKernalStop(boolean cancel) {
        this.unregisterRollingUpgradeMXBean();
    }

    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode joiningNode) {
        try {
            this.securitySupportCheck(joiningNode);
            this.checkRemoteNode(joiningNode);
            return this.distributedRollingUpgradeAvailable() ? this.rollingUpgradeProcessValidation(joiningNode) : null;
        }
        catch (NodeValidationException e) {
            return new IgniteNodeValidationResult(joiningNode.id(), e.getMessage(), e.getSendMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RollingUpgradeModeChangeResult setMode(boolean enable) {
        Object object = this.mux;
        synchronized (object) {
            if (!this.distributedRollingUpgradeAvailable()) {
                return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, (Exception)new UnsupportedOperationException("Rolling Upgrade is not supported."), (RollingUpgradeStatus)this.getStatus());
            }
            if (enable && !this.isRolUpd) {
                return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, (Exception)((Object)new IgniteException("Rolling Upgrade mode cannot be enabled. Consider changing 'GridGainConfiguration.rollingUpdatesEnabled' configuration property.")), (RollingUpgradeStatus)this.getStatus());
            }
            try {
                if (enable) {
                    this.enableRollingUpgrade();
                } else {
                    this.disableRollingUpgrade();
                }
            }
            catch (IgniteCheckedException e) {
                return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, (Exception)((Object)new IgniteException("Rolling Upgrade mode cannot be " + (enable ? "enabled" : "disabled") + ". " + e.getMessage(), (Throwable)e)), (RollingUpgradeStatus)this.getStatus());
            }
            return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.SUCCESS, (RollingUpgradeStatus)this.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RollingUpgradeModeChangeResult enableForcedMode() {
        Object object = this.mux;
        synchronized (object) {
            if (!this.distributedRollingUpgradeAvailable()) {
                return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, (Exception)new UnsupportedOperationException("Forced mode of Rolling Upgrade is not supported."), (RollingUpgradeStatus)this.getStatus());
            }
            if (!this.isRolUpd) {
                return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, (Exception)((Object)new IgniteException("Rolling Upgrade mode cannot be enabled. Consider changing 'GridGainConfiguration.rollingUpdatesEnabled' configuration property.")), (RollingUpgradeStatus)this.getStatus());
            }
            try {
                GridGainRollingUpgradeStatus newStatus = new GridGainRollingUpgradeStatus(true, true, this.ctx.discovery().localNode().version(), null, new HashSet<IgniteFeatures>(Arrays.asList(IgniteFeatures.values())), new HashSet<GridGainFeatures>(Arrays.asList(GridGainFeatures.values())));
                this.distributedRollingUpgradeStatus.propagateAsync((Serializable)((Object)newStatus));
                this.rollingUpgradeStatus = newStatus;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Forced rolling upgrade mode enabled.");
                }
            }
            catch (IgniteCheckedException e) {
                return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.FAIL, (Exception)((Object)new IgniteException("Forced mode of rolling upgrade cannot be enabled. " + e.getMessage(), (Throwable)e)), (RollingUpgradeStatus)this.getStatus());
            }
            return new RollingUpgradeModeChangeResult(RollingUpgradeModeChangeResult.Result.SUCCESS, (RollingUpgradeStatus)this.rollingUpgradeStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGainRollingUpgradeStatus getStatus() {
        Object object = this.mux;
        synchronized (object) {
            if (this.rollingUpgradeStatus == null) {
                this.rollingUpgradeStatus = new GridGainRollingUpgradeStatus(false, false, this.ctx.discovery().localNode().version(), null, new HashSet<IgniteFeatures>(Arrays.asList(IgniteFeatures.values())), new HashSet<GridGainFeatures>(Arrays.asList(GridGainFeatures.values())));
            }
            return this.rollingUpgradeStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteNodeValidationResult rollingUpgradeProcessValidation(ClusterNode joiningNode) throws NodeValidationException {
        Object object = this.mux;
        synchronized (object) {
            boolean acceptableVer;
            GridGainRollingUpgradeStatus status = this.getStatus();
            IgniteProductVersion crdNodeVer = this.ctx.discovery().localNode().version();
            IgniteProductVersion joiningNodeVer = joiningNode.version();
            boolean sameVer = !status.enabled() && crdNodeVer.compareToIgnoreTimestamp(joiningNodeVer) == 0;
            boolean bl = acceptableVer = status.enabled() && (joiningNodeVer.compareToIgnoreTimestamp(status.initialVersion()) == 0 || status.targetVersion() != null && joiningNodeVer.compareToIgnoreTimestamp(status.targetVersion()) == 0);
            if (status.forcedModeEnabled() || sameVer || acceptableVer) {
                return null;
            }
            if (!status.enabled()) {
                throw new NodeValidationException(String.format(ROLLING_UPGRADE_REJECT_MSG, crdNodeVer, joiningNodeVer), String.format(ROLLING_UPGRADE_REJECT_MSG, joiningNodeVer, crdNodeVer));
            }
            if (joiningNodeVer.compareToIgnoreTimestamp(status.initialVersion()) != 0 && status.targetVersion() != null && joiningNodeVer.compareToIgnoreTimestamp(status.targetVersion()) != 0) {
                return new IgniteNodeValidationResult(joiningNode.id(), "Node was rejected. The cluster has already two versions for rolling upgrade [initVer=" + status.initialVersion() + ", targetVer=" + status.targetVersion() + ", nodeVer=" + joiningNodeVer + ']', "The cluster has already two versions for rolling upgrade [initVer=" + status.initialVersion() + ", targetVer=" + status.targetVersion() + ", nodeVer=" + joiningNodeVer + ']');
            }
            if (status.targetVersion() == null && joiningNodeVer.compareToIgnoreTimestamp(status.initialVersion()) > 0) {
                GridGainRollingUpgradeStatus newState;
                this.rollingUpgradeStatus = newState = new GridGainRollingUpgradeStatus(status.enabled(), status.forcedModeEnabled(), status.initialVersion(), joiningNodeVer, status.supportedFeatures(), status.supportedGridGainFeatures());
                try {
                    this.distributedRollingUpgradeStatus.propagateAsync((Serializable)((Object)newState));
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Target version was set. [initVer=" + newState.initialVersion() + ", targetVer=" + newState.targetVersion() + ']');
                    }
                }
                catch (IgniteCheckedException e) {
                    String msg = "Distributed metastore can't propagate value.";
                    this.log.error(msg, (Throwable)e);
                    return new IgniteNodeValidationResult(joiningNode.id(), msg, msg);
                }
                return null;
            }
            return new IgniteNodeValidationResult(joiningNode.id(), "Node was rejected. The cluster mustn't contain node older than initial [initVer=" + status.initialVersion() + ", nodeVer=" + joiningNodeVer + ']', "The cluster mustn't contain node older than initial [initVer=" + status.initialVersion() + ", nodeVer=" + joiningNodeVer + ']');
        }
    }

    private void checkRemoteNode(ClusterNode remote) throws NodeValidationException {
        ClusterNode loc = this.ctx.discovery().localNode();
        try {
            this.versionsCompatibilityCheck(loc, remote);
            this.rollingUpdatesCompatibilityCheck(loc, remote, null);
        }
        catch (NodeValidationException e) {
            this.warnAndDebug(e.getMessage());
            throw e;
        }
    }

    private void versionsCompatibilityCheck(ClusterNode loc, ClusterNode remote) throws NodeValidationException {
        String rmtIgniteVer;
        String locBuildVer = (String)loc.attribute("plugins.gg.build.ver");
        String rmtBuildVer = (String)remote.attribute("plugins.gg.build.ver");
        if (rmtBuildVer == null && (rmtIgniteVer = (String)remote.attribute("org.apache.ignite.build.ver")) != null) {
            String ptrn = "GridGain node cannot be in one cluster with Ignite node [locNodeAddrs=%s, rmtNodeAddrs=%s]";
            String locNodeAddrs = U.addressesAsString((ClusterNode)loc);
            String rmtNodeAddrs = U.addressesAsString((ClusterNode)remote);
            throw new NodeValidationException(String.format(ptrn, locNodeAddrs, rmtNodeAddrs), String.format(ptrn, rmtNodeAddrs, locNodeAddrs));
        }
        if (!F.eq((Object)rmtBuildVer, (Object)locBuildVer)) {
            boolean incompatible;
            Collection locCompatibleVers = (Collection)loc.attribute("plugins.gg.compatible.vers");
            Collection rmtCompatibleVers = (Collection)remote.attribute("plugins.gg.compatible.vers");
            Collection locIncompatibleVers = (Collection)loc.attribute("plugins.gg.incompatible.vers");
            Collection rmtIncompatibleVers = (Collection)remote.attribute("plugins.gg.incompatible.vers");
            boolean compatible = GridEntDiscoveryNodeValidationProcessor.matchesAny(locBuildVer, rmtCompatibleVers) || GridEntDiscoveryNodeValidationProcessor.matchesAny(rmtBuildVer, locCompatibleVers);
            boolean bl = incompatible = GridEntDiscoveryNodeValidationProcessor.matchesAny(locBuildVer, rmtIncompatibleVers) || GridEntDiscoveryNodeValidationProcessor.matchesAny(rmtBuildVer, locIncompatibleVers);
            if (compatible && !incompatible) {
                String warnMsg = "Local node's build version differs from remote node's, but they are compatible (will try to continue join process). Rolling updates should be set to TRUE on both nodes in this case [locBuildVer=" + locBuildVer + ", rmtBuildVer=" + rmtBuildVer + ", locNodeAddrs=" + U.addressesAsString((ClusterNode)loc) + ", rmtNodeAddrs=" + U.addressesAsString((ClusterNode)remote) + ", locNodeId=" + loc.id() + ", rmtNodeId=" + remote.id() + ']';
                this.warnAndDebug(warnMsg);
                this.rollingUpdatesCompatibilityCheck(loc, remote, true);
            } else {
                String ptrn = "Local node's and remote node's build versions are not compatible [locBuildVer=%s, rmtBuildVer=%s, locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s]";
                Object[] locParams = new Object[]{locBuildVer, U.addressesAsString((ClusterNode)loc), loc.id()};
                Object[] rmtParams = new Object[]{rmtBuildVer, U.addressesAsString((ClusterNode)remote), remote.id()};
                throw new NodeValidationException(String.format(ptrn, this.interleave(locParams, rmtParams)), String.format(ptrn, this.interleave(rmtParams, locParams)));
            }
        }
    }

    private void rollingUpdatesCompatibilityCheck(ClusterNode loc, ClusterNode remote, @Nullable Boolean expVal) throws NodeValidationException {
        Boolean isRmtRollUpd = (Boolean)remote.attribute("plugins.ggrolling.updates");
        if (isRmtRollUpd == null || isRmtRollUpd != this.isRolUpd) {
            String ptrn = "Rolling updates are not properly configured [locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s, locNodeIgniteVersion=%s, rmtNodeIgniteVersion=%s, locRollingUpdatesEnabled=%b, rmtRollingUpdatesEnabled=%b]";
            Object[] locParams = new Object[]{U.addressesAsString((ClusterNode)loc), loc.id(), loc.version(), this.isRolUpd};
            Object[] rmtParams = new Object[]{U.addressesAsString((ClusterNode)remote), remote.id(), remote.version(), isRmtRollUpd};
            throw new NodeValidationException(String.format(ptrn, this.interleave(locParams, rmtParams)), String.format(ptrn, this.interleave(rmtParams, locParams)));
        }
        if (expVal != null && this.isRolUpd != expVal) {
            String ptrn = "Rolling updates property should be set to " + expVal + "[locNodeAddrs=%s, rmtNodeAddrs=%s, locNodeId=%s, rmtNodeId=%s, locNodeIgniteVersion=%s, rmtNodeIgniteVersion=%s, locRollingUpdatesEnabled=%b, rmtRollingUpdatesEnabled=%b, rollingUpdatesExpectedValue=" + expVal + ']';
            Object[] locParams = new Object[]{U.addressesAsString((ClusterNode)loc), loc.id(), loc.version(), this.isRolUpd};
            Object[] rmtParams = new Object[]{U.addressesAsString((ClusterNode)remote), remote.id(), remote.version(), isRmtRollUpd};
            throw new NodeValidationException(String.format(ptrn, this.interleave(locParams, rmtParams)), String.format(ptrn, this.interleave(rmtParams, locParams)));
        }
    }

    private Object[] interleave(Object[] a1, Object[] a2) {
        assert (a1.length == a2.length);
        Object[] res = new Object[a1.length + a2.length];
        for (int i = 0; i < a1.length; ++i) {
            res[i * 2] = a1[i];
            res[i * 2 + 1] = a2[i];
        }
        return res;
    }

    private void warnAndDebug(String msg) {
        LT.warn((IgniteLogger)this.log, (String)msg);
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg);
        }
    }

    private void securitySupportCheck(ClusterNode joiningNode) throws NodeValidationException {
        if (IgniteFeatures.allNodesSupports((GridKernalContext)this.ctx, (Iterable)this.ctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.IGNITE_SECURITY_PROCESSOR) && !IgniteFeatures.nodeSupports((GridKernalContext)this.ctx, (ClusterNode)joiningNode, (IgniteFeatures)IgniteFeatures.IGNITE_SECURITY_PROCESSOR)) {
            String msg = "The cluster with security messages can't connect node without support it.";
            throw new NodeValidationException(msg, msg);
        }
    }

    private void enableRollingUpgrade() throws IgniteCheckedException {
        GridGainRollingUpgradeStatus status = this.getStatus();
        if (!status.enabled()) {
            IgniteProductVersion initVer = this.ctx.discovery().localNode().version();
            GridGainRollingUpgradeStatus newState = new GridGainRollingUpgradeStatus(true, false, initVer, null, new HashSet<IgniteFeatures>(Arrays.asList(IgniteFeatures.values())), new HashSet<GridGainFeatures>(Arrays.asList(GridGainFeatures.values())));
            this.distributedRollingUpgradeStatus.propagateAsync((Serializable)((Object)newState));
            this.rollingUpgradeStatus = newState;
            if (this.log.isInfoEnabled()) {
                this.log.info("Rolling upgrade successfully enabled [status=" + (Object)((Object)newState) + ']');
            }
        }
    }

    private void disableRollingUpgrade() throws IgniteCheckedException {
        GridGainRollingUpgradeStatus status = this.getStatus();
        if (status.enabled()) {
            Collection nodes = this.ctx.discovery().allNodes();
            this.validateNodeVersions(nodes);
            GridGainRollingUpgradeStatus newState = new GridGainRollingUpgradeStatus(false, false, this.ctx.discovery().localNode().version(), null, new HashSet<IgniteFeatures>(Arrays.asList(IgniteFeatures.values())), new HashSet<GridGainFeatures>(Arrays.asList(GridGainFeatures.values())));
            this.distributedRollingUpgradeStatus.propagateAsync((Serializable)((Object)newState));
            this.rollingUpgradeStatus = newState;
            if (this.log.isInfoEnabled()) {
                this.log.info("Rolling upgrade successfully disabled.");
            }
        }
    }

    private void validateNodeVersions(Collection<ClusterNode> nodes) throws IgniteCheckedException {
        Map<IgniteProductVersion, String> nodeVersions = nodes.stream().collect(Collectors.groupingBy(ClusterNode::version, Collectors.mapping(n -> n.consistentId().toString(), Collectors.joining(", ", "Nodes: [", "]"))));
        if (nodeVersions.size() > 1) {
            throw new IgniteCheckedException("Rolling upgrade cannot be disabled because there is more than one node with different product version. " + nodeVersions);
        }
    }

    protected static boolean matchesAny(String ver, Collection<String> templates) {
        if (F.isEmpty(templates)) {
            return false;
        }
        for (String template : templates) {
            if (!GridEntDiscoveryNodeValidationProcessor.matches(ver, template)) continue;
            return true;
        }
        return false;
    }

    protected static boolean matches(String ver, String template) {
        String[] templateTokens;
        int maxIdx;
        String[] verTokens = ver.split("\\.");
        if (verTokens.length < (maxIdx = Math.min((templateTokens = template.split("\\.")).length, 3))) {
            return false;
        }
        for (int i = 0; i < maxIdx; ++i) {
            String verTok = verTokens[i];
            String templateTok = templateTokens[i];
            if ("*".equals(templateTok) || F.eq((Object)verTok, (Object)templateTok)) continue;
            return false;
        }
        return true;
    }

    private boolean distributedRollingUpgradeAvailable() {
        return IgniteFeatures.allNodesSupports((GridKernalContext)this.ctx, (Iterable)this.ctx.discovery().aliveServerNodes(), (IgniteFeatures)IgniteFeatures.DISTRIBUTED_ROLLING_UPGRADE_MODE);
    }

    private void registerRollingUpgradeMXBean() {
        if (U.IGNITE_MBEANS_DISABLED || this.rollingUpgradeMBeanName != null) {
            return;
        }
        RollingUpgradeMXBeanImpl ruMXBean = new RollingUpgradeMXBeanImpl(this.ctx);
        try {
            IgniteConfiguration cfg = this.ctx.config();
            this.rollingUpgradeMBeanName = U.registerMBean((MBeanServer)cfg.getMBeanServer(), (String)cfg.getIgniteInstanceName(), (String)ROLLING_UPGRADE_MBEAN_NAME, (String)ruMXBean.getClass().getSimpleName(), (Object)ruMXBean, RollingUpgradeMXBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered RollingUpgrade MBean: " + this.rollingUpgradeMBeanName);
            }
        }
        catch (JMException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to register RollingUpgrade MBean", (Throwable)e);
        }
    }

    private void unregisterRollingUpgradeMXBean() {
        ObjectName mBeanName = this.rollingUpgradeMBeanName;
        if (mBeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.ctx.config().getMBeanServer().unregisterMBean(mBeanName);
            this.rollingUpgradeMBeanName = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered RollingUpgrade MBean: " + mBeanName);
            }
        }
        catch (JMException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to unregister RollingUpgrade MBean: " + mBeanName), (Throwable)e);
        }
    }
}

