/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.nodevalidation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.ru.RollingUpgradeProcessor;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.processors.ru.RollingUpgradeUtil;
import org.apache.ignite.lang.IgniteProductVersion;
import org.gridgain.grid.ru.GridGainRollingUpgradeStatus;
import org.gridgain.grid.ru.RollingUpgradeMXBean;

public class RollingUpgradeMXBeanImpl
implements RollingUpgradeMXBean {
    public static final String NOT_AVAILABLE_VAL = "N/A";
    private final GridKernalContext ctx;
    private final RollingUpgradeProcessor rollingUpgradeProcessor;

    public RollingUpgradeMXBeanImpl(GridKernalContext ctx) {
        this.ctx = ctx;
        this.rollingUpgradeProcessor = ctx.rollingUpgrade();
    }

    @Override
    public boolean isEnabled() {
        return this.rollingUpgradeProcessor.getStatus().enabled();
    }

    @Override
    public String getInitialVersion() {
        return Optional.ofNullable(this.rollingUpgradeProcessor.getStatus().initialVersion()).map(IgniteProductVersion::toString).orElse(NOT_AVAILABLE_VAL);
    }

    @Override
    public List<String> getInitialNodes() {
        return RollingUpgradeUtil.initialNodes((GridKernalContext)this.ctx, (RollingUpgradeStatus)this.rollingUpgradeProcessor.getStatus());
    }

    @Override
    public String getTargetVersion() {
        return Optional.ofNullable(this.rollingUpgradeProcessor.getStatus().targetVersion()).map(IgniteProductVersion::toString).orElse(NOT_AVAILABLE_VAL);
    }

    @Override
    public List<String> getUpdatedNodes() {
        return RollingUpgradeUtil.updatedNodes((GridKernalContext)this.ctx, (RollingUpgradeStatus)this.rollingUpgradeProcessor.getStatus());
    }

    @Override
    public List<String> getSupportedIgniteFeatures() {
        return this.rollingUpgradeProcessor.getStatus().supportedFeatures().stream().map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public List<String> getSupportedGridGainFeatures() {
        if (this.rollingUpgradeProcessor.getStatus() instanceof GridGainRollingUpgradeStatus) {
            GridGainRollingUpgradeStatus status = (GridGainRollingUpgradeStatus)this.rollingUpgradeProcessor.getStatus();
            return status.supportedGridGainFeatures().stream().map(Enum::name).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void changeMode(boolean enable) {
        this.rollingUpgradeProcessor.setMode(enable);
    }
}

