/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.security;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.gridgain.grid.internal.processors.security.AllowAllPermissionSet;
import org.gridgain.grid.internal.processors.security.SecuritySubjectAdapter;
import org.gridgain.grid.security.Authenticator;

public class GridAuthenticatorHandler {
    private Authenticator authenticator;

    public GridAuthenticatorHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public SecuritySubject authenticate(AuthenticationContext authCtx) throws IgniteCheckedException {
        if (this.authenticator == null) {
            SecuritySubjectAdapter s = new SecuritySubjectAdapter(authCtx.subjectType(), authCtx.subjectId());
            s.permissions(new AllowAllPermissionSet());
            s.address(authCtx.address());
            if (authCtx.credentials() != null) {
                s.login(authCtx.credentials().getLogin());
            }
            s.certificates(authCtx.certificates());
            return s;
        }
        if (this.authenticator.supported(authCtx.subjectType())) {
            try {
                return this.authenticator.authenticate(authCtx);
            }
            catch (IgniteException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
        throw new IgniteCheckedException("Failed to find authenticator.");
    }
}

