/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.segmentation;

import java.util.LinkedList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.segmentation.GridSegmentationProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.plugin.segmentation.SegmentationResolver;

public class GridEntSegmentationProcessor
extends GridProcessorAdapter
implements GridSegmentationProcessor {
    public GridEntSegmentationProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public boolean isValidSegment() {
        boolean allSegResolversPassReq;
        SegmentationResolver[] resolvers = this.ctx.config().getSegmentationResolvers();
        if (resolvers == null || resolvers.length == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Segmentation check is disabled (configured array of resolvers is empty).");
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting network segment check.");
        }
        long start = U.currentTimeMillis();
        boolean segValid = allSegResolversPassReq = this.ctx.config().isAllSegmentationResolversPassRequired();
        LinkedList<IgniteBiTuple> errs = new LinkedList<IgniteBiTuple>();
        for (SegmentationResolver resolver : resolvers) {
            boolean valid = false;
            IgniteCheckedException err = null;
            for (int i = 0; i < this.ctx.config().getSegmentationResolveAttempts() && !valid; ++i) {
                try {
                    valid = resolver.isValidSegment();
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Checked segmentation resolver [resolver=" + resolver + ", valid=" + valid + ']');
                    continue;
                }
                catch (IgniteCheckedException e) {
                    if (err == null) {
                        err = e;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to check segmentation resolver [resolver=" + resolver + ", err=" + e.getMessage() + ']');
                }
            }
            if (!valid && err != null) {
                errs.add(F.t((Object)resolver, err));
            }
            if (valid && !allSegResolversPassReq) {
                segValid = true;
                break;
            }
            if (valid || !allSegResolversPassReq) continue;
            segValid = false;
            break;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Network segment check finished in " + (U.currentTimeMillis() - start) + " ms.");
        }
        if (segValid) {
            return true;
        }
        if (!errs.isEmpty()) {
            for (IgniteBiTuple t : errs) {
                LT.error((IgniteLogger)this.log, (Throwable)((Throwable)t.get2()), (String)("Failed to check segmentation resolver: " + t.get1()));
            }
        }
        return false;
    }
}

