/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverHubInMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverHubOutMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubInMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubOutMetrics;

public class VisorDr
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private byte id;
    private Map<String, VisorDrSenderHubInMetrics> sndHubInMetrics;
    private VisorDrSenderHubInMetrics sndHubAggInMetrics;
    private Map<Byte, VisorDrSenderHubOutMetrics> sndHubOutMetrics;
    private VisorDrSenderHubOutMetrics sndHubAggOutMetrics;
    private Map<Byte, VisorDrReceiverHubInMetrics> rcvHubInMetrics;
    private VisorDrReceiverHubInMetrics rcvHubAggInMetrics;
    private VisorDrReceiverHubOutMetrics rcvHubOutMetrics;

    public VisorDr() {
    }

    public VisorDr(IgniteEx ignite, GridGain plugin) {
        assert (plugin != null);
        this.id = plugin.configuration().getDataCenterId();
        this.sndHubInMetrics = VisorDrSenderHubInMetrics.map(ignite, plugin);
        this.sndHubAggInMetrics = VisorDrSenderHubInMetrics.aggregated(plugin);
        this.sndHubOutMetrics = VisorDrSenderHubOutMetrics.map(plugin);
        this.sndHubAggOutMetrics = VisorDrSenderHubOutMetrics.aggregated(plugin);
        this.rcvHubInMetrics = VisorDrReceiverHubInMetrics.map(plugin);
        this.rcvHubAggInMetrics = VisorDrReceiverHubInMetrics.aggregated(plugin);
        this.rcvHubOutMetrics = VisorDrReceiverHubOutMetrics.aggregated(plugin);
    }

    public byte getId() {
        return this.id;
    }

    public Map<String, VisorDrSenderHubInMetrics> getSenderHubInMetrics() {
        return this.sndHubInMetrics;
    }

    public VisorDrSenderHubInMetrics getSenderHubAggregatedInMetrics() {
        return this.sndHubAggInMetrics;
    }

    public Map<Byte, VisorDrSenderHubOutMetrics> getSenderHubOutMetrics() {
        return this.sndHubOutMetrics;
    }

    public VisorDrSenderHubOutMetrics getSenderHubAggregated() {
        return this.sndHubAggOutMetrics;
    }

    public Map<Byte, VisorDrReceiverHubInMetrics> getReceiverHubInMetrics() {
        return this.rcvHubInMetrics;
    }

    public VisorDrReceiverHubInMetrics getReceiverHubAggregatedInMetrics() {
        return this.rcvHubAggInMetrics;
    }

    public VisorDrReceiverHubOutMetrics getReceiverHubOutMetrics() {
        return this.rcvHubOutMetrics;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeByte(this.id);
        U.writeMap((ObjectOutput)out, this.sndHubInMetrics);
        out.writeObject((Object)this.sndHubAggInMetrics);
        U.writeMap((ObjectOutput)out, this.sndHubOutMetrics);
        out.writeObject((Object)this.sndHubAggOutMetrics);
        U.writeMap((ObjectOutput)out, this.rcvHubInMetrics);
        out.writeObject((Object)this.rcvHubAggInMetrics);
        out.writeObject((Object)this.rcvHubOutMetrics);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readByte();
        this.sndHubInMetrics = U.readMap((ObjectInput)in);
        this.sndHubAggInMetrics = (VisorDrSenderHubInMetrics)((Object)in.readObject());
        this.sndHubOutMetrics = U.readMap((ObjectInput)in);
        this.sndHubAggOutMetrics = (VisorDrSenderHubOutMetrics)((Object)in.readObject());
        this.rcvHubInMetrics = U.readMap((ObjectInput)in);
        this.rcvHubAggInMetrics = (VisorDrReceiverHubInMetrics)((Object)in.readObject());
        this.rcvHubOutMetrics = (VisorDrReceiverHubOutMetrics)((Object)in.readObject());
    }

    public String toString() {
        return S.toString(VisorDr.class, (Object)((Object)this));
    }
}

