/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheStatus;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverCacheMetrics;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderCacheMetrics;

public class VisorDrCacheMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private VisorDrSenderCacheMetrics drSndMetrics;
    private VisorDrReceiverCacheMetrics drRcvMetrics;

    public VisorDrCacheMetrics() {
    }

    public VisorDrCacheMetrics(GridDr dr, GridGainCacheConfiguration ggCcfg, String cacheName) {
        assert (ggCcfg != null);
        this.name = cacheName;
        if (ggCcfg.getDrSenderConfiguration() != null) {
            this.drSndMetrics = new VisorDrSenderCacheMetrics(dr, cacheName);
        }
        this.drRcvMetrics = new VisorDrReceiverCacheMetrics(dr, cacheName);
    }

    public boolean isDrSendMetricsPaused() {
        VisorDrCacheStatus status;
        if (this.drSndMetrics != null && (status = this.drSndMetrics.getStatus()) != null) {
            return status.isPaused();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public VisorDrSenderCacheMetrics getDrSendMetrics() {
        return this.drSndMetrics;
    }

    public VisorDrReceiverCacheMetrics getDrReceiveMetrics() {
        return this.drRcvMetrics;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCutString((DataOutput)out, (String)this.name);
        out.writeObject((Object)this.drSndMetrics);
        out.writeObject((Object)this.drRcvMetrics);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString((DataInput)in);
        this.drSndMetrics = (VisorDrSenderCacheMetrics)((Object)in.readObject());
        this.drRcvMetrics = (VisorDrReceiverCacheMetrics)((Object)in.readObject());
    }

    public String toString() {
        return S.toString(VisorDrCacheMetrics.class, (Object)((Object)this));
    }
}

