/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.jetbrains.annotations.Nullable;

public class VisorDrReceiverHubConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String locInboundHost;
    private int locInboundPort;
    private int selectorCnt;
    private int workerThreads;
    private int msgQueueLimit;
    private boolean tcpNodelay;
    private boolean directBuf;
    private long idleTimeout;
    private long writeTimeout;
    private long flushFreq;
    private int perNodeBufSize;
    private int perNodeParallelLoadOperations;

    public VisorDrReceiverHubConfiguration() {
    }

    public VisorDrReceiverHubConfiguration(DrReceiverConfiguration rcvHubCfg) {
        assert (rcvHubCfg != null);
        this.locInboundHost = rcvHubCfg.getLocalInboundHost();
        this.locInboundPort = rcvHubCfg.getLocalInboundPort();
        this.selectorCnt = rcvHubCfg.getSelectorCount();
        this.workerThreads = rcvHubCfg.getWorkerThreads();
        this.msgQueueLimit = rcvHubCfg.getMessageQueueLimit();
        this.tcpNodelay = rcvHubCfg.isTcpNodelay();
        this.directBuf = rcvHubCfg.isDirectBuffer();
        this.idleTimeout = rcvHubCfg.getIdleTimeout();
        this.writeTimeout = rcvHubCfg.getWriteTimeout();
        this.flushFreq = rcvHubCfg.getFlushFrequency();
        this.perNodeBufSize = rcvHubCfg.getPerNodeBufferSize();
        this.perNodeParallelLoadOperations = rcvHubCfg.getPerNodeParallelLoadOperations();
    }

    @Nullable
    public String getLocalInboundHost() {
        return this.locInboundHost;
    }

    public int getLocalInboundPort() {
        return this.locInboundPort;
    }

    public int getSelectorCount() {
        return this.selectorCnt;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public int getMessageQueueLimit() {
        return this.msgQueueLimit;
    }

    public boolean isTcpNodelay() {
        return this.tcpNodelay;
    }

    public boolean isDirectBuffer() {
        return this.directBuf;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public long getFlushFrequency() {
        return this.flushFreq;
    }

    public int getPerNodeBufferSize() {
        return this.perNodeBufSize;
    }

    public int getPerNodeParallelLoadOperations() {
        return this.perNodeParallelLoadOperations;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCutString((DataOutput)out, (String)this.locInboundHost);
        out.writeInt(this.locInboundPort);
        out.writeInt(this.selectorCnt);
        out.writeInt(this.workerThreads);
        out.writeInt(this.msgQueueLimit);
        out.writeBoolean(this.tcpNodelay);
        out.writeBoolean(this.directBuf);
        out.writeLong(this.idleTimeout);
        out.writeLong(this.writeTimeout);
        out.writeLong(this.flushFreq);
        out.writeInt(this.perNodeBufSize);
        out.writeInt(this.perNodeParallelLoadOperations);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.locInboundHost = U.readString((DataInput)in);
        this.locInboundPort = in.readInt();
        this.selectorCnt = in.readInt();
        this.workerThreads = in.readInt();
        this.msgQueueLimit = in.readInt();
        this.tcpNodelay = in.readBoolean();
        this.directBuf = in.readBoolean();
        this.idleTimeout = in.readLong();
        this.writeTimeout = in.readLong();
        this.flushFreq = in.readLong();
        this.perNodeBufSize = in.readInt();
        this.perNodeParallelLoadOperations = in.readInt();
    }

    public String toString() {
        return S.toString(VisorDrReceiverHubConfiguration.class, (Object)((Object)this));
    }
}

