/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.cache.dr.CacheDrStateTransfer;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheStateTransfer;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheStatus;
import org.jetbrains.annotations.Nullable;

public class VisorDrSenderCacheMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int batchesSent;
    private long entriesSent;
    private long entriesFiltered;
    private int batchesAcked;
    private long entriesAcked;
    private int batchesFailed;
    private long backupQueueSize;
    private VisorDrCacheStatus status;
    private List<VisorDrCacheStateTransfer> stateTransfers;

    public VisorDrSenderCacheMetrics() {
    }

    public VisorDrSenderCacheMetrics(GridDr dr, String cacheName) {
        assert (dr != null);
        CacheDrSenderMetrics m = dr.senderCacheMetrics(cacheName);
        this.batchesSent = m.batchesSent();
        this.entriesSent = m.entriesSent();
        this.batchesAcked = m.batchesAcked();
        this.entriesAcked = m.entriesAcked();
        this.batchesFailed = m.batchesFailed();
        this.entriesFiltered = m.entriesFiltered();
        this.backupQueueSize = m.backupQueueSize();
        this.status = m.status() != null ? new VisorDrCacheStatus(m.status()) : null;
        this.stateTransfers = new ArrayList<VisorDrCacheStateTransfer>();
        for (CacheDrStateTransfer transfer : dr.listStateTransfers(cacheName)) {
            this.stateTransfers.add(new VisorDrCacheStateTransfer(transfer));
        }
    }

    public int getBatchesSent() {
        return this.batchesSent;
    }

    public long getEntriesSent() {
        return this.entriesSent;
    }

    public long getEntriesFiltered() {
        return this.entriesFiltered;
    }

    public int getBatchesAcked() {
        return this.batchesAcked;
    }

    public long getEntriesAcked() {
        return this.entriesAcked;
    }

    public int getBatchesFailed() {
        return this.batchesFailed;
    }

    public long getBackupQueueSize() {
        return this.backupQueueSize;
    }

    @Nullable
    public VisorDrCacheStatus getStatus() {
        return this.status;
    }

    public List<VisorDrCacheStateTransfer> getStateTransfers() {
        return this.stateTransfers;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.batchesSent);
        out.writeLong(this.entriesSent);
        out.writeLong(this.entriesFiltered);
        out.writeInt(this.batchesAcked);
        out.writeLong(this.entriesAcked);
        out.writeInt(this.batchesFailed);
        out.writeLong(this.backupQueueSize);
        out.writeObject((Object)this.status);
        U.writeCollection((ObjectOutput)out, this.stateTransfers);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchesSent = in.readInt();
        this.entriesSent = in.readLong();
        this.entriesFiltered = in.readLong();
        this.batchesAcked = in.readInt();
        this.entriesAcked = in.readLong();
        this.batchesFailed = in.readInt();
        this.backupQueueSize = in.readLong();
        this.status = (VisorDrCacheStatus)((Object)in.readObject());
        this.stateTransfers = U.readList((ObjectInput)in);
    }

    public String toString() {
        return S.toString(VisorDrSenderCacheMetrics.class, (Object)((Object)this));
    }
}

