/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderLoadBalancingMode;
import org.gridgain.grid.internal.processors.dr.DrUtils;

public class VisorDrSenderConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int batchSndSize;
    private long batchSndFreq;
    private int maxBatches;
    private DrSenderLoadBalancingMode sndHubLoadBalancingMode;
    private long stateTransferThrottle;
    private int stateTransferThreadsCnt;
    private String sndGrp;

    public VisorDrSenderConfiguration() {
    }

    public VisorDrSenderConfiguration(CacheDrSenderConfiguration sndCfg) {
        this.batchSndSize = sndCfg.getBatchSendSize();
        this.batchSndFreq = sndCfg.getBatchSendFrequency();
        this.maxBatches = sndCfg.getMaxBatches();
        this.sndHubLoadBalancingMode = sndCfg.getLoadBalancingMode();
        this.stateTransferThrottle = sndCfg.getStateTransferThrottle();
        this.stateTransferThreadsCnt = sndCfg.getStateTransferThreadsCount();
        this.sndGrp = DrUtils.effectiveSenderGroup(sndCfg);
    }

    public int getBatchSendSize() {
        return this.batchSndSize;
    }

    public long getBatchSendFrequency() {
        return this.batchSndFreq;
    }

    public int getMaxBatches() {
        return this.maxBatches;
    }

    public DrSenderLoadBalancingMode getSenderHubLoadBalancingMode() {
        return this.sndHubLoadBalancingMode;
    }

    public long getStateTransferThrottle() {
        return this.stateTransferThrottle;
    }

    public int getStateTransferThreadsCount() {
        return this.stateTransferThreadsCnt;
    }

    public String getSenderGroup() {
        return this.sndGrp;
    }

    public byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.batchSndSize);
        out.writeLong(this.batchSndFreq);
        out.writeInt(this.maxBatches);
        U.writeEnum((DataOutput)out, (Enum)this.sndHubLoadBalancingMode);
        out.writeLong(this.stateTransferThrottle);
        out.writeInt(this.stateTransferThreadsCnt);
        U.writeCutString((DataOutput)out, (String)this.sndGrp);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchSndSize = in.readInt();
        this.batchSndFreq = in.readLong();
        this.maxBatches = in.readInt();
        this.sndHubLoadBalancingMode = DrSenderLoadBalancingMode.fromOrdinal(in.readByte());
        this.stateTransferThrottle = in.readLong();
        this.stateTransferThreadsCnt = in.readInt();
        if (protoVer >= 2) {
            this.sndGrp = U.readString((DataInput)in);
        }
    }

    public String toString() {
        return S.toString(VisorDrSenderConfiguration.class, (Object)((Object)this));
    }
}

