/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrNodeTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrNodeTaskResult;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.dr.DrReceiverInMetrics;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.dr.DrSender;
import org.gridgain.grid.dr.DrSenderConnection;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderOutMetrics;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorDrNodeTask
extends VisorOneNodeTask<VisorDrNodeTaskArgs, VisorDrNodeTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorDrNodeTaskArgs, VisorDrNodeTaskResult> job(VisorDrNodeTaskArgs arg) {
        return new VisorDrNodeJob(arg, this.debug);
    }

    private static class VisorDrNodeJob
    extends VisorJob<VisorDrNodeTaskArgs, VisorDrNodeTaskResult> {
        private static final long serialVersionUID = 0L;

        public VisorDrNodeJob(VisorDrNodeTaskArgs arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorDrNodeTaskResult run(@Nullable VisorDrNodeTaskArgs arg) throws IgniteException {
            Objects.requireNonNull(arg, "arg");
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            ClusterNode locNode = this.ignite.localNode();
            GridGainConfiguration pluginCfg = plugin.configuration();
            boolean useCacheNames = pluginCfg.isDrUseCacheNames();
            DrSenderConfiguration senderHubCfg = pluginCfg.getDrSenderConfiguration();
            DrReceiverConfiguration receiverHubCfg = pluginCfg.getDrReceiverConfiguration();
            GridDr dr = plugin.dr();
            VisorDrNodeTaskResult res = new VisorDrNodeTaskResult();
            DiscoveryDataClusterState clusterState = this.ignite.context().state().clusterState();
            res.setDataCenterId(pluginCfg.getDataCenterId());
            res.setDataNode(clusterState.hasBaselineTopology() && CU.baselineNode((ClusterNode)locNode, (DiscoveryDataClusterState)clusterState));
            res.setAddresses(locNode.addresses().toString());
            res.setMode(locNode.isClient() ? "Client" : "Server");
            if (senderHubCfg != null) {
                DrSenderConnectionConfiguration[] senderCfg = senderHubCfg.getConnectionConfiguration();
                ArrayList<T2> dataCenters = new ArrayList<T2>();
                for (DrSenderConnectionConfiguration configuration : senderCfg) {
                    dataCenters.add(IgniteUtils.tuple((Object)configuration.getDataCenterId(), Arrays.asList(configuration.getReceiverAddresses())));
                }
                res.setSenderDataCenters(dataCenters);
            }
            if (receiverHubCfg != null) {
                String locInboundHost = receiverHubCfg.getLocalInboundHost();
                int locInboundPort = receiverHubCfg.getLocalInboundPort();
                res.setReceiverAddress(locInboundHost + ":" + locInboundPort);
            }
            if (arg.clearStore()) {
                if (dr.isLocalSender()) {
                    DrSender locSnd = dr.localSender();
                    if (!locSnd.isGlobalStore()) {
                        locSnd.connections().forEach(DrSenderConnection::clearStore);
                    } else {
                        locSnd.clearGlobalStore();
                    }
                    res.addResponseMessage("Clear store command completed successfully.");
                } else {
                    res.addResponseMessage("Clear store command failed, node is not a local sender.");
                }
            }
            if (arg.config()) {
                ArrayList<T2> commonCfg = new ArrayList<T2>();
                commonCfg.add(IgniteUtils.tuple((Object)"StreamerThreadPoolSize", (Object)pluginCfg.getDrStreamerThreadPoolSize()));
                commonCfg.add(IgniteUtils.tuple((Object)"ThreadPoolSize", (Object)pluginCfg.getDrThreadPoolSize()));
                res.setCommonConfig(commonCfg);
                ArrayList<T2> sndCfg = new ArrayList<T2>();
                if (senderHubCfg != null) {
                    if (useCacheNames) {
                        sndCfg.add(IgniteUtils.tuple((Object)"CacheNames", Arrays.asList(senderHubCfg.getCacheNames())));
                    } else {
                        sndCfg.add(IgniteUtils.tuple((Object)"SenderGroups", Arrays.asList(senderHubCfg.getSenderGroups())));
                    }
                    sndCfg.add(IgniteUtils.tuple((Object)"MaxErrors", (Object)senderHubCfg.getMaxErrors()));
                    sndCfg.add(IgniteUtils.tuple((Object)"MaxFailedConnectAttempts", (Object)senderHubCfg.getMaxFailedConnectAttempts()));
                    sndCfg.add(IgniteUtils.tuple((Object)"MaxQueueSize", (Object)senderHubCfg.getMaxQueueSize()));
                    sndCfg.add(IgniteUtils.tuple((Object)"SocketSendBufferSize", (Object)senderHubCfg.getSocketSendBufferSize()));
                    sndCfg.add(IgniteUtils.tuple((Object)"SocketReceiveBufferSize", (Object)senderHubCfg.getSocketReceiveBufferSize()));
                    sndCfg.add(IgniteUtils.tuple((Object)"HealthCheckFrequency", (Object)senderHubCfg.getHealthCheckFrequency()));
                    sndCfg.add(IgniteUtils.tuple((Object)"ReadTimeout", (Object)senderHubCfg.getReadTimeout()));
                    sndCfg.add(IgniteUtils.tuple((Object)"ReconnectOnFailureTimeout", (Object)senderHubCfg.getReconnectOnFailureTimeout()));
                    sndCfg.add(IgniteUtils.tuple((Object)"SystemRequestTimeout", (Object)senderHubCfg.getSystemRequestTimeout()));
                    if (senderHubCfg.getStore() != null) {
                        DrSenderConnectionConfiguration[] sndStore = senderHubCfg.getStore();
                        sndCfg.add(IgniteUtils.tuple((Object)"StoreSizeBytes", (Object)sndStore.sizeBytes()));
                    }
                    for (DrSenderConnectionConfiguration conCfg : senderHubCfg.getConnectionConfiguration()) {
                        DrSenderStore sndStore = conCfg.getStore();
                        if (sndStore == null) continue;
                        byte dataCenterId = conCfg.getDataCenterId();
                        sndCfg.add(IgniteUtils.tuple((Object)("DataCenter" + dataCenterId + "-StoreSizeBytes"), (Object)sndStore.sizeBytes()));
                    }
                    sndCfg.add(IgniteUtils.tuple((Object)"UseIgniteSslContextFactory", (Object)senderHubCfg.isUseIgniteSslContextFactory()));
                }
                res.setSenderConfig(sndCfg);
                ArrayList<T2> rcvCfg = new ArrayList<T2>();
                if (receiverHubCfg != null) {
                    rcvCfg.add(IgniteUtils.tuple((Object)"SelectorCount", (Object)receiverHubCfg.getSelectorCount()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"MessageQueueLimit", (Object)receiverHubCfg.getMessageQueueLimit()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"WorkerThreads", (Object)receiverHubCfg.getWorkerThreads()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"PerNodeBufferSize", (Object)receiverHubCfg.getPerNodeBufferSize()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"PerNodeParallelLoadOperations", (Object)receiverHubCfg.getPerNodeParallelLoadOperations()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"SocketReceiveBufferSize", (Object)receiverHubCfg.getSocketReceiveBufferSize()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"SocketSendBufferSize", (Object)receiverHubCfg.getSocketSendBufferSize()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"WriteTimeout", (Object)receiverHubCfg.getWriteTimeout()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"IdleTimeout", (Object)receiverHubCfg.getIdleTimeout()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"FlushFrequency", (Object)receiverHubCfg.getFlushFrequency()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"DirectBuffer", (Object)receiverHubCfg.isDirectBuffer()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"TcpNodelay", (Object)receiverHubCfg.isTcpNodelay()));
                    rcvCfg.add(IgniteUtils.tuple((Object)"UseIgniteSslContextFactory", (Object)receiverHubCfg.isUseIgniteSslContextFactory()));
                }
                res.setReceiverConfig(rcvCfg);
            }
            if (arg.metrics()) {
                ArrayList<T2> senderMetrics = new ArrayList<T2>();
                if (dr.isLocalSender()) {
                    DrSenderInMetrics inMetrics = dr.senderAggregatedInMetrics();
                    DrSenderOutMetrics outMetrics = dr.senderAggregatedOutMetrics();
                    senderMetrics.add(IgniteUtils.tuple((Object)"StoreSize", (Object)outMetrics.storeSize()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"BatchesSent", (Object)outMetrics.batchesSent()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"BatchesReceived", (Object)inMetrics.batchesReceived()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"BatchesAcked", (Object)outMetrics.batchesAcked()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"AverageBatchAckTime", (Object)outMetrics.averageBatchAckTime()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"BytesSent", (Object)outMetrics.bytesSent()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"BytesReceived", (Object)inMetrics.bytesReceived()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"BytesAcked", (Object)outMetrics.bytesAcked()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"EntriesSent", (Object)outMetrics.entriesSent()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"EntriesReceived", (Object)inMetrics.entriesReceived()));
                    senderMetrics.add(IgniteUtils.tuple((Object)"EntriesAcked", (Object)outMetrics.entriesAcked()));
                    if (senderHubCfg.getStore() != null) {
                        DrSenderStore sndStore = senderHubCfg.getStore();
                        senderMetrics.add(IgniteUtils.tuple((Object)"StoreIsOverflow", (Object)sndStore.isOverflow()));
                    }
                    for (DrSenderConnectionConfiguration conCfg : senderHubCfg.getConnectionConfiguration()) {
                        DrSenderStore sndStore = conCfg.getStore();
                        if (sndStore == null) continue;
                        byte dataCenterId = conCfg.getDataCenterId();
                        senderMetrics.add(IgniteUtils.tuple((Object)("DataCenter" + dataCenterId + "-StoreIsOverflow"), (Object)sndStore.isOverflow()));
                    }
                }
                res.setSenderMetrics(senderMetrics);
                ArrayList<T2> receiverMetrics = new ArrayList<T2>();
                try {
                    DrReceiverInMetrics inMetrics = dr.receiverAggregatedInMetrics();
                    DrReceiverOutMetrics outMetrics = dr.receiverAggregatedOutMetrics();
                    receiverMetrics.add(IgniteUtils.tuple((Object)"MessageQueueSizeBytes", (Object)inMetrics.messageQueueSizeBytes()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"BatchesSent", (Object)outMetrics.batchesSent()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"BatchesReceived", (Object)inMetrics.batchesReceived()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"BatchesAcked", (Object)outMetrics.batchesAcked()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"AverageBatchAckTime", (Object)outMetrics.averageBatchAckTime()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"BytesSent", (Object)outMetrics.bytesSent()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"BytesReceived", (Object)inMetrics.bytesReceived()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"BytesAcked", (Object)outMetrics.bytesAcked()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"EntriesSent", (Object)outMetrics.entriesSent()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"EntriesReceived", (Object)inMetrics.entriesReceived()));
                    receiverMetrics.add(IgniteUtils.tuple((Object)"EntriesAcked", (Object)outMetrics.entriesAcked()));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                res.setReceiverMetrics(receiverMetrics);
            }
            return res;
        }
    }
}

