/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.event;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.util.VisorEventMapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteClosure;
import org.gridgain.grid.internal.visor.event.VisorEventsCollectorJobResult;
import org.gridgain.grid.internal.visor.event.VisorEventsCollectorTaskArg;
import org.gridgain.grid.internal.visor.event.VisorEventsCollectorTaskResult;
import org.gridgain.grid.internal.visor.util.VisorTaskUtilsEnt;

@GridInternal
public class VisorEventsCollectorTask
extends VisorMultiNodeTask<VisorEventsCollectorTaskArg, VisorEventsCollectorTaskResult, VisorEventsCollectorJobResult> {
    private static final long serialVersionUID = 0L;

    protected VisorEventsCollectorJob job(VisorEventsCollectorTaskArg arg) {
        return new VisorEventsCollectorJob(arg, this.debug);
    }

    protected VisorEventsCollectorTaskResult reduce0(List<ComputeJobResult> results) {
        HashMap<UUID, List<VisorGridEvent>> evts = new HashMap<UUID, List<VisorGridEvent>>();
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                throw res.getException();
            }
            VisorEventsCollectorJobResult jobRes = (VisorEventsCollectorJobResult)((Object)res.getData());
            evts.put(res.getNode().id(), jobRes.getEvents());
        }
        return new VisorEventsCollectorTaskResult(evts);
    }

    protected static class VisorEventsCollectorJob
    extends VisorJob<VisorEventsCollectorTaskArg, VisorEventsCollectorJobResult> {
        private static final long serialVersionUID = 0L;

        protected VisorEventsCollectorJob(VisorEventsCollectorTaskArg arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorEventMapper eventMapper() {
            return VisorTaskUtils.EVT_MAPPER;
        }

        protected VisorEventsCollectorJobResult run(VisorEventsCollectorTaskArg arg) {
            if (F.isEmpty(arg.getEvents())) {
                throw new IllegalArgumentException("Event types not specified");
            }
            int[] evts = arg.getEvents().stream().mapToInt(Integer::intValue).toArray();
            if (arg.isEnable() && !this.ignite.allEventsUserRecordable(evts)) {
                this.ignite.events().enableLocal(evts);
            }
            return new VisorEventsCollectorJobResult(VisorTaskUtils.collectEvents((Ignite)this.ignite, (String)arg.getEventsOrderKey(), (String)arg.getEventsThrottleCounterKey(), (int[])evts, (IgniteClosure)VisorTaskUtilsEnt.EVT_MAPPER_ENT));
        }

        public String toString() {
            return S.toString(VisorEventsCollectorJob.class, (Object)((Object)this));
        }
    }
}

