/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.node;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.apache.ignite.internal.visor.node.VisorGridConfiguration;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.visor.database.VisorSnapshotConfiguration;
import org.gridgain.grid.internal.visor.dr.VisorDrReceiverHubConfiguration;
import org.gridgain.grid.internal.visor.dr.VisorDrSenderHubConfiguration;
import org.gridgain.grid.internal.visor.util.VisorTaskUtilsEnt;
import org.jetbrains.annotations.Nullable;

public class VisorGridGainNodeConfiguration
extends VisorGridConfiguration {
    private static final long serialVersionUID = 0L;
    private byte dataCenterId;
    private VisorSnapshotConfiguration snapCfg;
    private VisorDrSenderHubConfiguration drSndHub;
    private VisorDrReceiverHubConfiguration drReceiverHub;
    private String licenseUrl;
    private String securityCred;
    private String authenticator;
    private boolean rollingUpdatesEnabled;
    private int drPoolSize;
    private int drStreamerPoolSize;
    private boolean drUseCacheNames;

    public VisorGridGainNodeConfiguration() {
    }

    public VisorGridGainNodeConfiguration(IgniteEx ignite) {
        super(ignite);
        IgniteConfiguration igniteCfg = ignite.configuration();
        GridGainConfiguration ggCfg = null;
        if (igniteCfg.getPluginConfigurations() != null) {
            for (PluginConfiguration pluginCfg : igniteCfg.getPluginConfigurations()) {
                if (!(pluginCfg instanceof GridGainConfiguration)) continue;
                if (ggCfg == null) {
                    ggCfg = (GridGainConfiguration)pluginCfg;
                    continue;
                }
                throw new IgniteException("More than one instance of " + GridGainConfiguration.class.getSimpleName() + " is provided. Check your Ignite plugins configuration.");
            }
        }
        if (ggCfg == null) {
            ggCfg = new GridGainConfiguration();
        }
        this.dataCenterId = ggCfg.getDataCenterId();
        if (ggCfg.getSnapshotConfiguration() != null) {
            this.snapCfg = new VisorSnapshotConfiguration(ggCfg.getSnapshotConfiguration());
        }
        if (ggCfg.getDrSenderConfiguration() != null) {
            this.drSndHub = new VisorDrSenderHubConfiguration(ggCfg.getDrSenderConfiguration());
        }
        if (ggCfg.getDrReceiverConfiguration() != null) {
            this.drReceiverHub = new VisorDrReceiverHubConfiguration(ggCfg.getDrReceiverConfiguration());
        }
        this.licenseUrl = ggCfg.getLicenseUrl();
        this.securityCred = VisorTaskUtilsEnt.compactClassEnt(ggCfg.getSecurityCredentialsProvider());
        this.authenticator = VisorTaskUtilsEnt.compactClassEnt(ggCfg.getAuthenticator());
        this.rollingUpdatesEnabled = ggCfg.isRollingUpdatesEnabled();
        this.drPoolSize = ggCfg.getDrThreadPoolSize();
        this.drStreamerPoolSize = ggCfg.getDrStreamerThreadPoolSize();
        this.drUseCacheNames = ggCfg.isDrUseCacheNames();
    }

    public byte getDataCenterId() {
        return this.dataCenterId;
    }

    @Nullable
    public VisorSnapshotConfiguration getSnapshotConfiguration() {
        return this.snapCfg;
    }

    @Nullable
    public VisorDrSenderHubConfiguration getDrSenderHub() {
        return this.drSndHub;
    }

    @Nullable
    public VisorDrReceiverHubConfiguration getDrReceiverHub() {
        return this.drReceiverHub;
    }

    @Nullable
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @Nullable
    public String getSecurityCredentialsProvider() {
        return this.securityCred;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public boolean isRollingUpdatesEnabled() {
        return this.rollingUpdatesEnabled;
    }

    public int getDrThreadPoolSize() {
        return this.drPoolSize;
    }

    public int getDrStreamerThreadPoolSize() {
        return this.drStreamerPoolSize;
    }

    public boolean isDrUseCacheNames() {
        return this.drUseCacheNames;
    }

    public byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            dtout.writeByte((int)super.getProtocolVersion());
            super.writeExternalData((ObjectOutput)dtout);
        }
        out.writeByte(this.dataCenterId);
        out.writeObject((Object)this.drSndHub);
        out.writeObject((Object)this.drReceiverHub);
        U.writeString((DataOutput)out, (String)this.licenseUrl);
        U.writeString((DataOutput)out, (String)this.securityCred);
        U.writeString((DataOutput)out, (String)this.authenticator);
        out.writeBoolean(this.rollingUpdatesEnabled);
        out.writeInt(this.drPoolSize);
        out.writeInt(this.drStreamerPoolSize);
        out.writeObject((Object)this.snapCfg);
        out.writeBoolean(this.drUseCacheNames);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            super.readExternalData(dtin.readByte(), (ObjectInput)dtin);
        }
        this.dataCenterId = in.readByte();
        this.drSndHub = (VisorDrSenderHubConfiguration)((Object)in.readObject());
        this.drReceiverHub = (VisorDrReceiverHubConfiguration)((Object)in.readObject());
        this.licenseUrl = U.readString((DataInput)in);
        this.securityCred = U.readString((DataInput)in);
        this.authenticator = U.readString((DataInput)in);
        this.rollingUpdatesEnabled = in.readBoolean();
        this.drPoolSize = in.readInt();
        this.drStreamerPoolSize = in.readInt();
        this.snapCfg = (VisorSnapshotConfiguration)((Object)in.readObject());
        if (protoVer >= 2) {
            this.drUseCacheNames = in.readBoolean();
        }
    }

    public String toString() {
        return S.toString(VisorGridGainNodeConfiguration.class, (Object)((Object)this));
    }
}

