/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.gridgain.grid.internal.visor.security.VisorSecurityPermissionSet;

public class VisorSecuritySubject
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private UUID id;
    private SecuritySubjectType sbjType;
    private InetSocketAddress addr;
    private VisorSecurityPermissionSet perms;
    private String login;

    public VisorSecuritySubject() {
    }

    public VisorSecuritySubject(SecuritySubject sbj) {
        this.id = sbj.id();
        this.sbjType = sbj.type();
        this.addr = sbj.address();
        this.perms = new VisorSecurityPermissionSet(sbj.permissions());
        this.login = String.valueOf(sbj.login());
    }

    public UUID getId() {
        return this.id;
    }

    public SecuritySubjectType getType() {
        return this.sbjType;
    }

    public InetSocketAddress getAddress() {
        return this.addr;
    }

    public VisorSecurityPermissionSet getPermissions() {
        return this.perms;
    }

    public String getLogin() {
        return this.login;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid((DataOutput)out, (UUID)this.id);
        U.writeEnum((DataOutput)out, (Enum)this.sbjType);
        out.writeObject(this.addr);
        out.writeObject((Object)this.perms);
        U.writeCutString((DataOutput)out, (String)this.login);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readUuid((DataInput)in);
        this.sbjType = SecuritySubjectType.fromOrdinal((byte)in.readByte());
        this.addr = (InetSocketAddress)in.readObject();
        this.perms = (VisorSecurityPermissionSet)((Object)in.readObject());
        this.login = U.readString((DataInput)in);
    }

    public String toString() {
        return S.toString(VisorSecuritySubject.class, (Object)((Object)this));
    }
}

