/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.passcode;

import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.gridgain.grid.internal.GridPluginUtils;
import org.gridgain.grid.internal.processors.security.SecuritySubjectAdapter;
import org.gridgain.grid.security.AuthenticationValidator;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.jaas.JaasAuthenticatorMBean;
import org.gridgain.grid.security.passcode.AuthenticationAclProvider;
import org.gridgain.grid.security.passcode.PasscodeAuthenticatorMBean;

public class PasscodeAuthenticator
implements Authenticator,
AuthenticationValidator,
PasscodeAuthenticatorMBean,
LifecycleAware {
    private ObjectName mBean;
    private Map<SecurityCredentials, SecurityPermissionSet> permissions;
    private AuthenticationAclProvider aclProvider;
    @IgniteInstanceResource
    @GridToStringExclude
    private Ignite ignite;
    @LoggerResource
    private IgniteLogger log;

    public void setAclProvider(AuthenticationAclProvider aclProvider) {
        this.aclProvider = aclProvider;
    }

    @Override
    public String getPasscodesFormatted() {
        StringBuilder builder = new StringBuilder("Passcodes: [");
        String separator = "";
        for (Map.Entry<SecurityCredentials, SecurityPermissionSet> entry : this.permissions.entrySet()) {
            builder.append(separator).append(entry.getKey()).append("='").append(entry.getValue()).append("'");
            separator = ", ";
        }
        return builder.append("]").toString();
    }

    @Override
    public Object validationToken() {
        HashMap<SecurityCredentials, SecurityPermissionSet> res = new HashMap<SecurityCredentials, SecurityPermissionSet>();
        for (Map.Entry<SecurityCredentials, SecurityPermissionSet> e : this.permissions.entrySet()) {
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    @Override
    public boolean supported(SecuritySubjectType subjType) {
        assert (subjType != null);
        return true;
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return true;
    }

    public void start() {
        GridPluginUtils.assertParameter(this.aclProvider != null, "aclProvider != null");
        this.permissions = this.aclProvider.acl();
        if (this.permissions == null) {
            throw new IgniteException("Failed to start passcode authentication (ACL is empty).");
        }
        this.registerMBean();
    }

    public void stop() {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authenticator stopped ok.");
        }
    }

    private void registerMBean() {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            IgniteConfiguration ctx = this.ignite.configuration();
            this.mBean = U.registerMBean((MBeanServer)ctx.getMBeanServer(), (String)ctx.getIgniteInstanceName(), (String)"authenticator", (String)U.getSimpleName(this.getClass()), (Object)this, PasscodeAuthenticatorMBean.class);
        }
        catch (JMException e) {
            throw new IgniteException("Failed to register authenticator MBean: " + JaasAuthenticatorMBean.class, (Throwable)e);
        }
    }

    private void unregisterMBean() {
        if (this.mBean == null) {
            return;
        }
        try {
            IgniteConfiguration ctx = this.ignite.configuration();
            ctx.getMBeanServer().unregisterMBean(this.mBean);
        }
        catch (JMException e) {
            throw new IgniteException("Failed to register authenticator MBean: " + JaasAuthenticatorMBean.class, (Throwable)e);
        }
    }

    @Override
    public SecuritySubject authenticate(AuthenticationContext authCtx) throws IgniteCheckedException {
        assert (authCtx != null);
        SecurityCredentials cred = authCtx.credentials();
        if (cred == null) {
            return null;
        }
        SecurityPermissionSet p = this.permissions.get(cred);
        if (p != null) {
            SecuritySubjectAdapter subj = new SecuritySubjectAdapter(authCtx.subjectType(), authCtx.subjectId());
            subj.permissions(p);
            subj.address(authCtx.address());
            if (authCtx.credentials() != null) {
                subj.login(authCtx.credentials().getLogin());
            }
            subj.certificates(authCtx.certificates());
            return subj;
        }
        return null;
    }

    public String toString() {
        return S.toString(PasscodeAuthenticator.class, (Object)this);
    }
}

