/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientDataAffinity;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.impl.GridClientAndPredicate;
import org.apache.ignite.internal.client.impl.GridClientFutureAdapter;
import org.apache.ignite.internal.client.impl.GridClientImpl;
import org.apache.ignite.internal.client.impl.GridClientNodeImpl;
import org.apache.ignite.internal.client.impl.connection.GridClientConnection;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.impl.connection.GridConnectionIdleClosedException;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

abstract class GridClientAbstractProjection<T extends GridClientAbstractProjection> {
    private static final Logger log = Logger.getLogger(GridClientAbstractProjection.class.getName());
    protected Collection<GridClientNode> nodes;
    protected GridClientPredicate<? super GridClientNode> filter;
    protected GridClientLoadBalancer balancer;
    private static final int RETRY_CNT = 3;
    private static final int RETRY_DELAY = 1000;
    protected GridClientImpl client;

    protected GridClientAbstractProjection(GridClientImpl client, Collection<GridClientNode> nodes, GridClientPredicate<? super GridClientNode> filter, GridClientLoadBalancer balancer) {
        assert (client != null);
        this.client = client;
        this.nodes = nodes;
        this.filter = filter;
        this.balancer = balancer;
    }

    protected <R> GridClientFuture<R> withReconnectHandling(ClientProjectionClosure<R> c) {
        return this.withReconnectHandling(c, null);
    }

    protected <R> GridClientFuture<R> withReconnectHandling(ClientProjectionClosure<R> c, @Nullable GridClientPredicate<GridClientNode> excludeNodeFilter) {
        try {
            GridClientNode node = null;
            boolean changeNode = false;
            GridClientException cause = null;
            for (int i = 0; i < 3; ++i) {
                if (node == null || changeNode) {
                    try {
                        node = this.balancedNode(this.excludeFilter(node, excludeNodeFilter));
                    }
                    catch (GridClientException e) {
                        if (node == null) {
                            throw e;
                        }
                        throw new GridServerUnreachableException("All nodes in projection failed when retrying to perform request. Attempts made: " + i, cause);
                    }
                }
                GridClientConnection conn = null;
                try {
                    conn = this.client.connectionManager().connection(node);
                    return c.apply(conn, node.nodeId());
                }
                catch (GridConnectionIdleClosedException e) {
                    this.client.connectionManager().terminateConnection(conn, node, e);
                    changeNode = false;
                    cause = e;
                }
                catch (GridClientConnectionResetException e) {
                    this.client.connectionManager().terminateConnection(conn, node, e);
                    changeNode = true;
                    cause = e;
                }
                catch (GridServerUnreachableException e) {
                    changeNode = true;
                    cause = e;
                }
                U.sleep(1000L);
            }
            assert (cause != null);
            throw new GridServerUnreachableException("Failed to communicate with grid nodes (maximum count of retries reached).", cause);
        }
        catch (GridClientException e) {
            return new GridClientFutureAdapter(e);
        }
        catch (InterruptedException | IgniteInterruptedCheckedException e) {
            Thread.currentThread().interrupt();
            return new GridClientFutureAdapter(new GridClientException("Interrupted when (re)trying to perform request.", e));
        }
    }

    protected <R> GridClientFuture<R> withReconnectHandling(ClientProjectionClosure<R> c, String cacheName, @Nullable Object affKey) {
        GridClientDataAffinity affinity = this.client.affinity(cacheName);
        if (this.nodes != null || affinity == null || affKey == null) {
            return this.withReconnectHandling(c);
        }
        try {
            Collection<GridClientNode> prjNodes = this.projectionNodes();
            if (prjNodes.isEmpty()) {
                throw new GridServerUnreachableException("Failed to get affinity node (no nodes in topology were accepted by the filter): " + this.filter);
            }
            GridClientNode node = affinity.node(affKey, prjNodes);
            for (int i = 0; i < 3; ++i) {
                GridClientConnection conn = null;
                try {
                    conn = this.client.connectionManager().connection(node);
                    return c.apply(conn, node.nodeId());
                }
                catch (GridConnectionIdleClosedException e) {
                    this.client.connectionManager().terminateConnection(conn, node, e);
                }
                catch (GridClientConnectionResetException e) {
                    this.client.connectionManager().terminateConnection(conn, node, e);
                    if (!this.checkNodeAlive(node.nodeId())) {
                        throw new GridServerUnreachableException("Failed to communicate with mapped grid node for given affinity key (node left the grid) [nodeId=" + node.nodeId() + ", affKey=" + affKey + ']', e);
                    }
                }
                catch (Error | RuntimeException e) {
                    if (conn != null) {
                        this.client.connectionManager().terminateConnection(conn, node, e);
                    }
                    throw e;
                }
                U.sleep(1000L);
            }
            throw new GridServerUnreachableException("Failed to communicate with mapped grid node for given affinity key (did node leave the grid?) [nodeId=" + node.nodeId() + ", affKey=" + affKey + ']');
        }
        catch (GridClientException e) {
            return new GridClientFutureAdapter(e);
        }
        catch (InterruptedException | IgniteInterruptedCheckedException e) {
            Thread.currentThread().interrupt();
            return new GridClientFutureAdapter(new GridClientException("Interrupted when (re)trying to perform request.", e));
        }
    }

    protected boolean checkNodeAlive(UUID nodeId) throws GridClientException, InterruptedException {
        for (GridClientNodeImpl node : this.client.topology().nodes()) {
            try {
                if (node.nodeId().equals(nodeId)) continue;
                GridClientConnection conn = this.client.connectionManager().connection(node);
                try {
                    GridClientNode target = conn.node(nodeId, false, false, node.nodeId()).get();
                    if (target == null) {
                        this.client.topology().nodeFailed(nodeId);
                    }
                    return target != null;
                }
                catch (GridClientConnectionResetException e) {
                    this.client.connectionManager().terminateConnection(conn, node, e);
                }
                catch (GridClientClosedException e) {
                    throw e;
                }
                catch (GridClientException e) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "Node request failed, try next node.", e);
                }
            }
            catch (GridServerUnreachableException e) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Node request failed, try next node.", e);
            }
        }
        return false;
    }

    public Collection<? extends GridClientNode> projectionNodes() throws GridClientException {
        return this.projectionNodes(null);
    }

    protected Collection<? extends GridClientNode> projectionNodes(@Nullable GridClientPredicate<GridClientNode> pred) throws GridClientException {
        Collection<GridClientNode> prjNodes;
        if (this.nodes == null) {
            prjNodes = this.client.topology().nodes();
            if (this.filter != null || pred != null) {
                prjNodes = GridClientUtils.applyFilter(prjNodes, this.filter, pred);
            }
        } else {
            prjNodes = this.nodes;
        }
        return prjNodes;
    }

    private GridClientNode balancedNode(GridClientPredicate<GridClientNode> excludeFilter) throws GridClientException {
        Collection<GridClientNode> prjNodes = this.projectionNodes(excludeFilter);
        if (prjNodes.isEmpty()) {
            throw new GridServerUnreachableException("Failed to get balanced node (no nodes in topology were accepted by the filters): " + Arrays.asList(this.filter, excludeFilter));
        }
        if (prjNodes.size() == 1) {
            GridClientNode ret = GridClientUtils.first(prjNodes);
            assert (ret != null);
            return ret;
        }
        return this.balancer.balancedNode(prjNodes);
    }

    private GridClientPredicate<GridClientNode> excludeFilter(final @Nullable GridClientNode excludeNode, final @Nullable GridClientPredicate<GridClientNode> excludeNodesPred) {
        return new GridClientPredicate<GridClientNode>(){

            @Override
            public boolean apply(GridClientNode n) {
                if (excludeNode != null && excludeNode.equals(n)) {
                    return false;
                }
                if (excludeNodesPred != null && excludeNodesPred.apply(n)) {
                    return false;
                }
                return GridClientUtils.restAvailable(n, GridClientAbstractProjection.this.client.cfg.getProtocol());
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("Filter nodes with available REST");
                if (excludeNode != null) {
                    sb.append(" and exclude (probably due to connection failure) node: ").append(excludeNode.nodeId());
                }
                if (excludeNodesPred != null) {
                    sb.append(" and exclude nodes by filter: ").append(excludeNodesPred);
                }
                return sb.append(".").toString();
            }
        };
    }

    protected T createProjection(@Nullable Collection<GridClientNode> nodes, @Nullable GridClientPredicate<? super GridClientNode> filter, @Nullable GridClientLoadBalancer balancer, ProjectionFactory<T> factory) throws GridClientException {
        if (nodes != null && nodes.isEmpty()) {
            throw new GridClientException("Failed to create projection: given nodes collection is empty.");
        }
        if (filter != null && this.filter != null) {
            filter = new GridClientAndPredicate<GridClientNode>(this.filter, filter);
        } else if (filter == null) {
            filter = this.filter;
        }
        Collection<GridClientNode> subset = this.intersection(this.nodes, nodes);
        if (subset != null && subset.isEmpty()) {
            throw new GridClientException("Failed to create projection (given node set does not overlap with existing node set) [prjNodes=" + this.nodes + ", nodes=" + nodes);
        }
        if (filter != null && subset != null && (subset = GridClientUtils.applyFilter(subset, filter)) != null && subset.isEmpty()) {
            throw new GridClientException("Failed to create projection (none of the nodes in projection node set passed the filter) [prjNodes=" + subset + ", filter=" + filter + ']');
        }
        if (balancer == null) {
            balancer = this.balancer;
        }
        return factory.create(nodes, filter, balancer);
    }

    @Nullable
    private Collection<GridClientNode> intersection(@Nullable Collection<? extends GridClientNode> first, @Nullable Collection<? extends GridClientNode> second) {
        if (first == null && second == null) {
            return null;
        }
        if (first != null && second != null) {
            LinkedList<GridClientNode> res = new LinkedList<GridClientNode>(first);
            res.retainAll(second);
            return res;
        }
        return new ArrayList<GridClientNode>(first != null ? first : second);
    }

    protected static interface ClientProjectionClosure<R> {
        public GridClientFuture<R> apply(GridClientConnection var1, UUID var2) throws GridClientConnectionResetException, GridClientClosedException;
    }

    protected static interface ProjectionFactory<X extends GridClientAbstractProjection> {
        public X create(@Nullable Collection<GridClientNode> var1, @Nullable GridClientPredicate<? super GridClientNode> var2, GridClientLoadBalancer var3);
    }
}

