/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.impl.GridClientAbstractProjection;
import org.apache.ignite.internal.client.impl.GridClientImpl;
import org.apache.ignite.internal.client.impl.connection.GridClientConnection;
import org.apache.ignite.internal.client.impl.id_and_tag.IdAndTagViewTask;
import org.apache.ignite.internal.client.impl.id_and_tag.IdAndTagViewTaskResult;
import org.apache.ignite.internal.visor.VisorTaskArgument;

public class GridClientClusterStateImpl
extends GridClientAbstractProjection<GridClientClusterStateImpl>
implements GridClientClusterState {
    private static final GridClientAbstractProjection.ClientProjectionClosure<IdAndTagViewTaskResult> ID_AND_TAG_VIEW_CL = (conn, nodeId) -> conn.execute(IdAndTagViewTask.class.getName(), new VisorTaskArgument<Object>(nodeId, null, false), nodeId, false);
    private static final GridClientPredicate<GridClientNode> nonSupportedNodes = new GridClientPredicate<GridClientNode>(){

        @Override
        public boolean apply(GridClientNode n) {
            return !n.supports(IgniteFeatures.CLUSTER_READ_ONLY_MODE);
        }

        public String toString() {
            return "Filter nodes without support " + (Object)((Object)IgniteFeatures.CLUSTER_READ_ONLY_MODE) + " feature.";
        }
    };

    public GridClientClusterStateImpl(GridClientImpl client, Collection<GridClientNode> nodes, GridClientPredicate<? super GridClientNode> filter, GridClientLoadBalancer balancer) {
        super(client, nodes, filter, balancer);
    }

    @Override
    public void active(boolean active) throws GridClientException {
        this.withReconnectHandling((conn, nodeId) -> conn.changeState(active, nodeId)).get();
    }

    @Override
    public boolean active() throws GridClientException {
        return (Boolean)this.withReconnectHandling(GridClientConnection::currentState).get();
    }

    @Override
    public ClusterState state() throws GridClientException {
        return (ClusterState)((Object)this.withReconnectHandling(GridClientConnection::state, nonSupportedNodes).get());
    }

    @Override
    public void state(ClusterState newState) throws GridClientException {
        this.withReconnectHandling((con, nodeId) -> con.changeState(newState, nodeId), nonSupportedNodes).get();
    }

    @Override
    public UUID id() throws GridClientException {
        return this.withReconnectHandling(ID_AND_TAG_VIEW_CL).get().id();
    }

    @Override
    public String tag() throws GridClientException {
        return this.withReconnectHandling(ID_AND_TAG_VIEW_CL).get().tag();
    }

    @Override
    public String clusterName() throws GridClientException {
        return (String)this.withReconnectHandling(GridClientConnection::clusterName).get();
    }
}

