/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCacheMode;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientData;
import org.apache.ignite.internal.client.GridClientDataAffinity;
import org.apache.ignite.internal.client.GridClientDataConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPartitionAffinity;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRandomBalancer;
import org.apache.ignite.internal.client.impl.GridClientClusterStateImpl;
import org.apache.ignite.internal.client.impl.GridClientComputeImpl;
import org.apache.ignite.internal.client.impl.GridClientDataImpl;
import org.apache.ignite.internal.client.impl.GridClientNodeImpl;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionManager;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionManagerOsImpl;
import org.apache.ignite.internal.client.impl.connection.GridClientTopology;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.CycleThread;
import org.jetbrains.annotations.Nullable;

public class GridClientImpl
implements GridClient {
    private static final Object NULL_MASK = new Object();
    private static final Logger log = Logger.getLogger(GridClientImpl.class.getName());
    private final UUID id;
    protected final GridClientConfiguration cfg;
    private SSLContext sslCtx;
    private final GridClientComputeImpl compute;
    private final GridClientClusterStateImpl clusterState;
    private ConcurrentMap<Object, GridClientDataImpl> dataMap = new ConcurrentHashMap<Object, GridClientDataImpl>();
    protected GridClientTopology top;
    private final Thread topUpdateThread;
    private AtomicBoolean closed = new AtomicBoolean();
    protected GridClientConnectionManager connMgr;
    private final Collection<InetSocketAddress> routers;
    private final Collection<InetSocketAddress> srvs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridClientImpl(UUID id, GridClientConfiguration cfg0, boolean routerClient) throws GridClientException {
        this.id = id;
        this.cfg = new GridClientConfiguration(cfg0);
        boolean success = false;
        try {
            GridSslContextFactory factory;
            this.top = new GridClientTopology(this.cfg);
            for (GridClientDataConfiguration dataCfg : this.cfg.getDataConfigurations()) {
                GridClientDataAffinity aff = dataCfg.getAffinity();
                if (!(aff instanceof GridClientTopologyListener)) continue;
                this.addTopologyListener((GridClientTopologyListener)((Object)aff));
            }
            if (this.cfg.getBalancer() instanceof GridClientTopologyListener) {
                this.top.addTopologyListener((GridClientTopologyListener)((Object)this.cfg.getBalancer()));
            }
            if ((factory = this.cfg.getSslContextFactory()) != null) {
                try {
                    this.sslCtx = factory.createSslContext();
                }
                catch (SSLException e) {
                    throw new GridClientException("Failed to create client (unable to create SSL context, check ssl context factory configuration): " + e.getMessage(), e);
                }
            }
            if (this.cfg.isAutoFetchMetrics() && !this.cfg.isEnableMetricsCache()) {
                log.warning("Auto-fetch for metrics is enabled without enabling caching for them.");
            }
            if (this.cfg.isAutoFetchAttributes() && !this.cfg.isEnableAttributesCache()) {
                log.warning("Auto-fetch for node attributes is enabled without enabling caching for them.");
            }
            this.srvs = GridClientImpl.parseAddresses(this.cfg.getServers());
            this.routers = GridClientImpl.parseAddresses(this.cfg.getRouters());
            if (this.srvs.isEmpty() && this.routers.isEmpty()) {
                throw new GridClientException("Servers addresses and routers addresses cannot both be empty for client (please fix configuration and restart): " + this);
            }
            if (!this.srvs.isEmpty() && !this.routers.isEmpty()) {
                throw new GridClientException("Servers addresses and routers addresses cannot both be provided for client (please fix configuration and restart): " + this);
            }
            this.connMgr = this.createConnectionManager(id, this.sslCtx, this.cfg, this.routers, this.top, null, routerClient);
            try {
                this.tryInitTopology();
            }
            catch (GridClientException e) {
                this.top.fail(e);
                log.warning("Failed to initialize topology on client start. Will retry in background.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new GridClientException("Client startup was interrupted.", e);
            }
            this.topUpdateThread = new TopologyUpdaterThread();
            this.topUpdateThread.setDaemon(true);
            this.topUpdateThread.start();
            this.compute = new GridClientComputeImpl(this, null, null, this.cfg.getBalancer());
            this.clusterState = new GridClientClusterStateImpl(this, null, null, this.cfg.getBalancer());
            if (log.isLoggable(Level.INFO)) {
                log.info("Client started [id=" + id + ", protocol=" + (Object)((Object)this.cfg.getProtocol()) + ']');
            }
            success = true;
        }
        finally {
            if (!success) {
                this.stop(false);
            }
        }
    }

    @Override
    public UUID id() {
        return this.id;
    }

    public void stop(boolean waitCompletion) {
        if (this.closed.compareAndSet(false, true)) {
            if (this.topUpdateThread != null) {
                this.topUpdateThread.interrupt();
            }
            if (this.top != null) {
                this.top.shutdown();
            }
            if (this.connMgr != null) {
                this.connMgr.stop(waitCompletion);
            }
            for (GridClientDataConfiguration dataCfg : this.cfg.getDataConfigurations()) {
                GridClientDataAffinity aff = dataCfg.getAffinity();
                if (!(aff instanceof GridClientTopologyListener)) continue;
                this.removeTopologyListener((GridClientTopologyListener)((Object)aff));
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Client stopped [id=" + this.id + ", waitCompletion=" + waitCompletion + ']');
            }
        }
    }

    @Override
    public GridClientData data() throws GridClientException {
        return this.data(null);
    }

    @Override
    public GridClientData data(final @Nullable String cacheName) throws GridClientException {
        this.checkClosed();
        Object key = this.maskNull(cacheName);
        GridClientDataImpl data = (GridClientDataImpl)this.dataMap.get(key);
        if (data == null) {
            GridClientDataConfiguration dataCfg = this.cfg.getDataConfiguration(cacheName);
            if (dataCfg == null && cacheName != null) {
                throw new GridClientException("Data configuration for given cache name was not provided: " + cacheName);
            }
            GridClientPredicate<GridClientNode> cacheNodes = new GridClientPredicate<GridClientNode>(){

                @Override
                public boolean apply(GridClientNode e) {
                    return e.caches().containsKey(cacheName);
                }

                public String toString() {
                    return "GridClientHasCacheFilter [cacheName=" + cacheName + "]";
                }
            };
            GridClientLoadBalancer balancer = dataCfg != null ? dataCfg.getPinnedBalancer() : new GridClientRandomBalancer();
            data = new GridClientDataImpl(cacheName, this, null, (GridClientPredicate<? super GridClientNode>)cacheNodes, balancer, null, this.cfg.isEnableMetricsCache());
            GridClientDataImpl old = this.dataMap.putIfAbsent(key, data);
            if (old != null) {
                data = old;
            }
        }
        return data;
    }

    @Override
    public GridClientCompute compute() {
        return this.compute;
    }

    @Override
    public GridClientClusterState state() {
        return this.clusterState;
    }

    @Override
    public void addTopologyListener(GridClientTopologyListener lsnr) {
        this.top.addTopologyListener(lsnr);
    }

    @Override
    public void removeTopologyListener(GridClientTopologyListener lsnr) {
        this.top.removeTopologyListener(lsnr);
    }

    @Override
    public Collection<GridClientTopologyListener> topologyListeners() {
        return this.top.topologyListeners();
    }

    @Override
    public boolean connected() {
        return !this.top.failed();
    }

    @Override
    public void close() {
        GridClientFactory.stop(this.id);
    }

    public GridClientTopology topology() {
        return this.top;
    }

    @Override
    public GridClientException checkLastError() {
        return this.top.lastError();
    }

    public GridClientConnectionManager connectionManager() {
        return this.connMgr;
    }

    GridClientDataAffinity affinity(String cacheName) {
        GridClientDataConfiguration dataCfg = this.cfg.getDataConfiguration(cacheName);
        return dataCfg == null ? null : dataCfg.getAffinity();
    }

    private void checkClosed() throws GridClientClosedException {
        if (this.closed.get()) {
            throw new GridClientClosedException("Client was closed (no public methods of client can be used anymore).");
        }
    }

    private Object maskNull(String cacheName) {
        return cacheName == null ? NULL_MASK : cacheName;
    }

    private static Collection<InetSocketAddress> parseAddresses(Collection<String> cfgAddrs) throws GridClientException {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>(cfgAddrs.size());
        for (String srvStr : cfgAddrs) {
            try {
                String[] split = srvStr.split(":");
                InetSocketAddress addr = new InetSocketAddress(split[0], Integer.parseInt(split[1]));
                addrs.add(addr);
            }
            catch (RuntimeException e) {
                throw new GridClientException("Failed to create client (invalid server address specified): " + srvStr, e);
            }
        }
        return Collections.unmodifiableCollection(addrs);
    }

    public GridClientConnectionManager newConnectionManager(@Nullable Byte marshId, boolean routerClient) throws GridClientException {
        return this.createConnectionManager(this.id, this.sslCtx, this.cfg, this.routers, this.top, marshId, routerClient);
    }

    private GridClientConnectionManager createConnectionManager(UUID clientId, SSLContext sslCtx, GridClientConfiguration cfg, Collection<InetSocketAddress> routers, GridClientTopology top, @Nullable Byte marshId, boolean routerClient) throws GridClientException {
        return new GridClientConnectionManagerOsImpl(clientId, sslCtx, cfg, routers, top, marshId, routerClient);
    }

    private void tryInitTopology() throws GridClientException, InterruptedException {
        Collection<InetSocketAddress> connSrvs;
        boolean hasSrvs = this.routers.isEmpty();
        Collection<InetSocketAddress> collection = connSrvs = hasSrvs ? new LinkedHashSet<InetSocketAddress>(this.srvs) : this.routers;
        if (hasSrvs) {
            try {
                for (GridClientNodeImpl node : this.top.nodes()) {
                    boolean sameHost;
                    Collection<InetSocketAddress> collection2 = node.availableAddresses(this.cfg.getProtocol(), true);
                    ArrayList<InetSocketAddress> resolvedEndpoints = new ArrayList<InetSocketAddress>(collection2.size());
                    for (InetSocketAddress endpoint : collection2) {
                        if (endpoint.isUnresolved()) continue;
                        resolvedEndpoints.add(endpoint);
                    }
                    boolean bl = sameHost = node.attributes().isEmpty() || F.containsAny(U.allLocalMACs(), node.attribute("org.apache.ignite.macs").toString().split(", "));
                    if (sameHost) {
                        Collections.sort(resolvedEndpoints, U.inetAddressesComparator(true));
                        connSrvs.addAll(resolvedEndpoints);
                        continue;
                    }
                    for (InetSocketAddress endpoint : resolvedEndpoints) {
                        if (endpoint.getAddress().isLoopbackAddress()) continue;
                        connSrvs.add(endpoint);
                    }
                    if (!connSrvs.isEmpty()) continue;
                    connSrvs.addAll(resolvedEndpoints);
                }
            }
            catch (GridClientDisconnectedException gridClientDisconnectedException) {
                // empty catch block
            }
        }
        this.connMgr.init(connSrvs);
        HashMap<String, GridClientCacheMode> overallCaches = new HashMap<String, GridClientCacheMode>();
        for (GridClientNodeImpl gridClientNodeImpl : this.top.nodes()) {
            overallCaches.putAll(gridClientNodeImpl.caches());
        }
        for (Map.Entry entry : overallCaches.entrySet()) {
            GridClientDataAffinity affinity = this.affinity((String)entry.getKey());
            if (!(affinity instanceof GridClientPartitionAffinity) || entry.getValue() == GridClientCacheMode.PARTITIONED) continue;
            log.warning(GridClientPartitionAffinity.class.getSimpleName() + " is used for a cache configured for non-partitioned mode [cacheName=" + (String)entry.getKey() + ", cacheMode=" + entry.getValue() + ']');
        }
    }

    public String toString() {
        return "GridClientImpl [id=" + this.id + ", closed=" + this.closed + ']';
    }

    static {
        if (!IgniteSystemProperties.getBoolean("IGNITE_GRID_CLIENT_LOG_ENABLED", false)) {
            boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
            try {
                if (isLog4jUsed) {
                    U.addLog4jNoOpLogger();
                }
                U.addJavaNoOpLogger();
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
        }
    }

    private class TopologyUpdaterThread
    extends CycleThread {
        private TopologyUpdaterThread() {
            super(GridClientImpl.this.id + "-topology-update", GridClientImpl.this.cfg.getTopologyRefreshFrequency());
        }

        @Override
        public void iteration() throws InterruptedException {
            block2: {
                try {
                    GridClientImpl.this.tryInitTopology();
                }
                catch (GridClientException e) {
                    GridClientImpl.this.top.fail(e);
                    if (!log.isLoggable(Level.FINE)) break block2;
                    log.fine("Failed to update topology: " + e.getMessage());
                }
            }
        }
    }
}

