/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import org.apache.ignite.client.ClientClusterGroup;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

class ClientClusterGroupImpl
implements ClientClusterGroup {
    private final Collection<UUID> nodeIds;

    ClientClusterGroupImpl(Collection<UUID> ids) {
        this.nodeIds = ids;
    }

    @Override
    public ClientClusterGroup forNodeIds(Collection<UUID> ids) {
        return new ClientClusterGroupImpl(new HashSet<UUID>(ids));
    }

    @Override
    public ClientClusterGroup forNodeId(UUID id, UUID ... ids) {
        HashSet<UUID> nodeIds = U.newHashSet(1 + (ids == null ? 0 : ids.length));
        nodeIds.add(id);
        if (!F.isEmpty(ids)) {
            nodeIds.addAll(Arrays.asList(ids));
        }
        return new ClientClusterGroupImpl(nodeIds);
    }

    public Collection<UUID> nodeIds() {
        return this.nodeIds == null ? null : Collections.unmodifiableCollection(this.nodeIds);
    }
}

