/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.EnumSet;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;

public class ProtocolContext {
    private final ProtocolVersion ver;
    private final EnumSet<ProtocolBitmaskFeature> features;

    public ProtocolContext(ProtocolVersion ver, EnumSet<ProtocolBitmaskFeature> features) {
        this.ver = ver;
        this.features = features != null ? features : EnumSet.noneOf(ProtocolBitmaskFeature.class);
    }

    public boolean isFeatureSupported(ProtocolBitmaskFeature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean isFeatureSupported(ProtocolVersionFeature feature) {
        return ProtocolContext.isFeatureSupported(this.ver, feature);
    }

    public EnumSet<ProtocolBitmaskFeature> features() {
        return this.features;
    }

    public ProtocolVersion version() {
        return this.ver;
    }

    public static boolean isFeatureSupported(ProtocolVersion ver, ProtocolVersionFeature feature) {
        return ver.compareTo(feature.verIntroduced()) >= 0;
    }
}

