/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IoStatisticsHolderQuery
implements IoStatisticsHolder {
    public static final String PHYSICAL_READS = "PHYSICAL_READS";
    public static final String LOGICAL_READS = "LOGICAL_READS";
    private LongAdder logicalReadCtr = new LongAdder();
    private LongAdder physicalReadCtr = new LongAdder();
    private final String qryId;

    public IoStatisticsHolderQuery(String qryId) {
        this.qryId = qryId;
    }

    @Override
    public void trackLogicalRead(long pageAddr) {
        this.logicalReadCtr.increment();
    }

    @Override
    public void trackPhysicalAndLogicalRead(long pageAddr) {
        this.logicalReadCtr.increment();
        this.physicalReadCtr.increment();
    }

    @Override
    public long logicalReads() {
        return this.logicalReadCtr.longValue();
    }

    @Override
    public long physicalReads() {
        return this.physicalReadCtr.longValue();
    }

    @Override
    public Map<String, Long> logicalReadsMap() {
        HashMap<String, Long> res = new HashMap<String, Long>(2);
        res.put(LOGICAL_READS, this.logicalReads());
        return res;
    }

    @Override
    public Map<String, Long> physicalReadsMap() {
        HashMap<String, Long> res = new HashMap<String, Long>(2);
        res.put(PHYSICAL_READS, this.physicalReads());
        return res;
    }

    @Override
    public void resetStatistics() {
        this.logicalReadCtr.reset();
        this.physicalReadCtr.reset();
    }

    public String queryId() {
        return this.qryId;
    }

    public void merge(long logicalReads, long physicalReads) {
        this.logicalReadCtr.add(logicalReads);
        this.physicalReadCtr.add(physicalReads);
    }

    public String toString() {
        return S.toString(IoStatisticsHolderQuery.class, this, "logicalReadCtr", (Object)this.logicalReadCtr, "physicalReadCtr", this.physicalReadCtr, "qryId", this.qryId);
    }
}

