/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class RecycleRecord
extends PageDeltaRecord {
    @GridToStringExclude
    private long newPageId;

    public RecycleRecord(int grpId, long pageId, long newPageId) {
        super(grpId, pageId);
        this.newPageId = newPageId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PageIO.setPageId(pageAddr, this.newPageId);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_PAGE_RECYCLE;
    }

    public long newPageId() {
        return this.newPageId;
    }

    @Override
    public String toString() {
        return S.toString(RecycleRecord.class, this, "newPageId", U.hexLong(this.newPageId), "super", super.toString());
    }
}

