/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class CacheData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final CacheConfiguration cacheCfg;
    private final int cacheId;
    private final int grpId;
    private final CacheType cacheType;
    private final IgniteUuid deploymentId;
    private final QuerySchema schema;
    private final UUID rcvdFrom;
    private final boolean staticCfg;
    private final boolean sql;
    private final boolean template;
    private final long flags;
    private final CacheConfigurationEnrichment cacheCfgEnrichment;

    CacheData(CacheConfiguration cacheCfg, int cacheId, int grpId, CacheType cacheType, IgniteUuid deploymentId, QuerySchema schema, UUID rcvdFrom, boolean staticCfg, boolean sql, boolean template, long flags, CacheConfigurationEnrichment cacheCfgEnrichment) {
        assert (cacheCfg != null);
        assert (rcvdFrom != null) : cacheCfg.getName();
        assert (deploymentId != null) : cacheCfg.getName();
        assert (template || cacheId != 0) : cacheCfg.getName();
        assert (template || grpId != 0) : cacheCfg.getName();
        this.cacheCfg = cacheCfg;
        this.cacheId = cacheId;
        this.grpId = grpId;
        this.cacheType = cacheType;
        this.deploymentId = deploymentId;
        this.schema = schema;
        this.rcvdFrom = rcvdFrom;
        this.staticCfg = staticCfg;
        this.sql = sql;
        this.template = template;
        this.flags = flags;
        this.cacheCfgEnrichment = cacheCfgEnrichment;
    }

    public int groupId() {
        return this.grpId;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public boolean template() {
        return this.template;
    }

    public CacheType cacheType() {
        return this.cacheType;
    }

    public IgniteUuid deploymentId() {
        return this.deploymentId;
    }

    public boolean staticallyConfigured() {
        return this.staticCfg;
    }

    public boolean sql() {
        return this.sql;
    }

    public CacheConfiguration cacheConfiguration() {
        return this.cacheCfg;
    }

    public QuerySchema schema() {
        return this.schema.copy();
    }

    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    public long flags() {
        return this.flags;
    }

    public CacheConfigurationEnrichment cacheConfigurationEnrichment() {
        return this.cacheCfgEnrichment;
    }

    public String toString() {
        return S.toString(CacheData.class, this, "cacheName", this.cacheCfg.getName());
    }
}

