/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.cluster.DetachedClusterNode;
import org.apache.ignite.internal.processors.affinity.LocalAffinityFunction;
import org.apache.ignite.internal.processors.cache.CacheJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.query.QuerySchemaPatch;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.indexing.IndexingSpi;
import org.apache.ignite.spi.indexing.noop.NoopIndexingSpi;
import org.jetbrains.annotations.Nullable;

public class ValidationOnNodeJoinUtils {
    private static final String MERGE_OF_CONFIG_CONFLICTS_MESSAGE = "Conflicts during configuration merge for cache '%s' : \n%s";
    private static final String MERGE_OF_CONFIG_REQUIRED_MESSAGE = "Failed to join node to the active cluster (the config of the cache '%s' has to be merged which is impossible on active grid). Deactivate grid and retry node join or clean the joining node.";
    private static final String ENCRYPT_MISMATCH_MESSAGE = "Failed to join node to the cluster (encryption settings are different for cache '%s' : local=%s, remote=%s.)";
    private static final IgniteProductVersion PRECISION_SCALE_SINCE_VER = IgniteProductVersion.fromString("2.7.0");
    private static final String INVALID_REGION_CONFIGURATION_MESSAGE = "Failed to join node (Incompatible data region configuration [region=%s, locNodeId=%s, isPersistenceEnabled=%s, rmtNodeId=%s, isPersistenceEnabled=%s])";

    @Nullable
    static IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData, Marshaller marsh, GridKernalContext ctx, Function<String, DynamicCacheDescriptor> cacheDescProvider) {
        if (discoData.hasJoiningNodeData() && discoData.joiningNodeData() instanceof CacheJoinNodeDiscoveryData) {
            CacheJoinNodeDiscoveryData nodeData = (CacheJoinNodeDiscoveryData)discoData.joiningNodeData();
            boolean isGridActive = ctx.state().clusterState().active();
            StringBuilder errorMsg = new StringBuilder();
            if (!node.isClient()) {
                ValidationOnNodeJoinUtils.validateRmtRegions(node, ctx).forEach(error -> {
                    if (errorMsg.length() > 0) {
                        errorMsg.append("\n");
                    }
                    errorMsg.append((String)error);
                });
            }
            SecurityContext secCtx = null;
            if (ctx.security().enabled()) {
                try {
                    secCtx = SecurityUtils.nodeSecurityContext(marsh, U.resolveClassLoader(ctx.config()), node);
                }
                catch (SecurityException se) {
                    errorMsg.append(se.getMessage());
                }
            }
            for (CacheJoinNodeDiscoveryData.CacheInfo cacheInfo : nodeData.caches().values()) {
                boolean rmtEnc;
                boolean locEnc;
                DynamicCacheDescriptor locDesc;
                if (secCtx != null && cacheInfo.cacheType() == CacheType.USER) {
                    try (OperationSecurityContext s = ctx.security().withContext(secCtx);){
                        GridCacheProcessor.authorizeCacheCreate(ctx.security(), cacheInfo.cacheData().config());
                    }
                    catch (SecurityException ex) {
                        if (errorMsg.length() > 0) {
                            errorMsg.append("\n");
                        }
                        errorMsg.append(ex.getMessage());
                    }
                }
                if ((locDesc = cacheDescProvider.apply(cacheInfo.cacheData().config().getName())) == null) continue;
                QuerySchemaPatch schemaPatch = locDesc.makeSchemaPatch(cacheInfo.cacheData().queryEntities());
                if (schemaPatch.hasConflicts() || isGridActive && !schemaPatch.isEmpty()) {
                    if (errorMsg.length() > 0) {
                        errorMsg.append("\n");
                    }
                    if (schemaPatch.hasConflicts()) {
                        errorMsg.append(String.format(MERGE_OF_CONFIG_CONFLICTS_MESSAGE, locDesc.cacheName(), schemaPatch.getConflictsMessage()));
                    } else {
                        errorMsg.append(String.format(MERGE_OF_CONFIG_REQUIRED_MESSAGE, locDesc.cacheName()));
                    }
                }
                if ((locEnc = locDesc.cacheConfiguration().isEncryptionEnabled()) == (rmtEnc = cacheInfo.cacheData().config().isEncryptionEnabled())) continue;
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(String.format(ENCRYPT_MISMATCH_MESSAGE, locDesc.cacheName(), rmtEnc, locEnc));
            }
            if (errorMsg.length() > 0) {
                String msg = errorMsg.toString();
                return new IgniteNodeValidationResult(node.id(), msg);
            }
        }
        return null;
    }

    static void validate(IgniteConfiguration c, CacheConfiguration cc, CacheType cacheType, @Nullable CacheStore cfgStore, GridKernalContext ctx, IgniteLogger log, BiFunction<Boolean, String, IgniteCheckedException> assertParam) throws IgniteCheckedException {
        ClusterNode oldestNode;
        boolean nonDfltPrecScaleExists;
        String schema;
        ClusterNode locNode;
        ValidationOnNodeJoinUtils.apply(assertParam, cc.getName() != null && !cc.getName().isEmpty(), "name is null or empty");
        if (cc.getCacheMode() == CacheMode.REPLICATED && cc.getNearConfiguration() != null && ctx.discovery().cacheAffinityNode(ctx.discovery().localNode(), cc.getName())) {
            U.warn(log, "Near cache cannot be used with REPLICATED cache, will be ignored [cacheName=" + U.maskName(cc.getName()) + ']');
            cc.setNearConfiguration(null);
        }
        if (ValidationOnNodeJoinUtils.storesLocallyOnClient(c, cc, ctx)) {
            throw new IgniteCheckedException("DataRegion for client caches must be explicitly configured on client node startup. Use DataStorageConfiguration to configure DataRegion.");
        }
        if (cc.getCacheMode() == CacheMode.LOCAL && !cc.getAffinity().getClass().equals(LocalAffinityFunction.class)) {
            U.warn(log, "AffinityFunction configuration parameter will be ignored for local cache [cacheName=" + U.maskName(cc.getName()) + ']');
        }
        if (cc.getAffinity().partitions() > 65000) {
            throw new IgniteCheckedException("Cannot have more than 65000 partitions [cacheName=" + cc.getName() + ", partitions=" + cc.getAffinity().partitions() + ']');
        }
        if (cc.getRebalanceMode() != CacheRebalanceMode.NONE) {
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getRebalanceBatchSize() > 0, "rebalanceBatchSize > 0");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getRebalanceTimeout() >= 0L, "rebalanceTimeout >= 0");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getRebalanceThrottle() >= 0L, "rebalanceThrottle >= 0");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getRebalanceBatchesPrefetchCount() > 0L, "rebalanceBatchesPrefetchCount > 0");
        }
        if ((cc.getCacheMode() == CacheMode.PARTITIONED || cc.getCacheMode() == CacheMode.REPLICATED) && cc.getAtomicityMode() == CacheAtomicityMode.ATOMIC && cc.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_ASYNC) {
            U.warn(log, "Cache write synchronization mode is set to FULL_ASYNC. All single-key 'put' and 'remove' operations will return 'null', all 'putx' and 'removex' operations will return 'true' [cacheName=" + U.maskName(cc.getName()) + ']');
        }
        DeploymentMode depMode = c.getDeploymentMode();
        if (!(!c.isPeerClassLoadingEnabled() || depMode != DeploymentMode.PRIVATE && depMode != DeploymentMode.ISOLATED || CU.isSystemCache(cc.getName()) || c.getMarshaller() instanceof BinaryMarshaller)) {
            throw new IgniteCheckedException("Cache can be started in PRIVATE or ISOLATED deployment mode only when BinaryMarshaller is used [depMode=" + (Object)((Object)ctx.config().getDeploymentMode()) + ", marshaller=" + c.getMarshaller().getClass().getName() + ']');
        }
        if (cc.getAffinity().partitions() > 65000) {
            throw new IgniteCheckedException("Affinity function must return at most 65000 partitions [actual=" + cc.getAffinity().partitions() + ", affFunction=" + cc.getAffinity() + ", cacheName=" + cc.getName() + ']');
        }
        if (cc.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getCacheMode() != CacheMode.LOCAL, "LOCAL cache mode cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getNearConfiguration() == null, "near cache cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            ValidationOnNodeJoinUtils.apply(assertParam, !cc.isReadThrough(), "readThrough cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            ValidationOnNodeJoinUtils.apply(assertParam, !cc.isWriteThrough(), "writeThrough cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            ValidationOnNodeJoinUtils.apply(assertParam, !cc.isWriteBehindEnabled(), "writeBehindEnabled cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getRebalanceMode() != CacheRebalanceMode.NONE, "Rebalance mode NONE cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            ExpiryPolicy expPlc = null;
            if (cc.getExpiryPolicyFactory() instanceof FactoryBuilder.SingletonFactory) {
                expPlc = (ExpiryPolicy)cc.getExpiryPolicyFactory().create();
            }
            if (!(expPlc instanceof EternalExpiryPolicy)) {
                ValidationOnNodeJoinUtils.apply(assertParam, cc.getExpiryPolicyFactory() == null, "expiry policy cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            }
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getInterceptor() == null, "interceptor cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
            String memPlcName = cc.getDataRegionName();
            DataRegion dataRegion = ctx.cache().context().database().dataRegion(memPlcName);
            if (dataRegion != null && !dataRegion.config().isPersistenceEnabled() && dataRegion.config().getPageEvictionMode() != DataPageEvictionMode.DISABLED) {
                throw new IgniteCheckedException("Data pages evictions cannot be used with TRANSACTIONAL_SNAPSHOT cache atomicity mode for in-memory regions. Please, either disable evictions or enable persistence for data regions with TRANSACTIONAL_SNAPSHOT caches. [cacheName=" + cc.getName() + ", dataRegionName=" + memPlcName + ", pageEvictionMode=" + (Object)((Object)dataRegion.config().getPageEvictionMode()) + ']');
            }
            IndexingSpi idxSpi = ctx.config().getIndexingSpi();
            ValidationOnNodeJoinUtils.apply(assertParam, idxSpi == null || idxSpi instanceof NoopIndexingSpi, "Custom IndexingSpi cannot be used with TRANSACTIONAL_SNAPSHOT atomicity mode");
        }
        ClusterNode clusterNode = locNode = ctx.discovery().localNode() != null ? ctx.discovery().localNode() : new DetachedClusterNode(ctx.pdsFolderResolver().resolveFolders().consistentId(), ctx.nodeAttributes());
        if (cc.isWriteBehindEnabled() && ctx.discovery().cacheAffinityNode(locNode, cc.getName())) {
            if (cfgStore == null) {
                throw new IgniteCheckedException("Cannot enable write-behind (writer or store is not provided) for cache: " + U.maskName(cc.getName()));
            }
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getWriteBehindBatchSize() > 0, "writeBehindBatchSize > 0");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getWriteBehindFlushSize() >= 0, "writeBehindFlushSize >= 0");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getWriteBehindFlushFrequency() >= 0L, "writeBehindFlushFrequency >= 0");
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getWriteBehindFlushThreadCount() > 0, "writeBehindFlushThreadCount > 0");
            if (cc.getWriteBehindFlushSize() == 0 && cc.getWriteBehindFlushFrequency() == 0L) {
                throw new IgniteCheckedException("Cannot set both 'writeBehindFlushFrequency' and 'writeBehindFlushSize' parameters to 0 for cache: " + U.maskName(cc.getName()));
            }
        }
        if (cc.isReadThrough() && cfgStore == null && ctx.discovery().cacheAffinityNode(locNode, cc.getName())) {
            throw new IgniteCheckedException("Cannot enable read-through (loader or store is not provided) for cache: " + U.maskName(cc.getName()));
        }
        if (cc.isWriteThrough() && cfgStore == null && ctx.discovery().cacheAffinityNode(locNode, cc.getName())) {
            throw new IgniteCheckedException("Cannot enable write-through (writer or store is not provided) for cache: " + U.maskName(cc.getName()));
        }
        long delay = cc.getRebalanceDelay();
        if (delay != 0L) {
            if (cc.getCacheMode() != CacheMode.PARTITIONED) {
                U.warn(log, "Rebalance delay is supported only for partitioned caches (will ignore): " + cc.getName());
            } else if (cc.getRebalanceMode() == CacheRebalanceMode.SYNC) {
                if (delay < 0L) {
                    U.warn(log, "Ignoring SYNC rebalance mode with manual rebalance start (node will not wait for rebalancing to be finished): " + U.maskName(cc.getName()));
                } else {
                    U.warn(log, "Using SYNC rebalance mode with rebalance delay (node will wait until rebalancing is initiated for " + delay + "ms) for cache: " + U.maskName(cc.getName()));
                }
            }
        }
        ctx.coordinators().validateCacheConfiguration(cc);
        if (cc.getAtomicityMode() == CacheAtomicityMode.ATOMIC) {
            ValidationOnNodeJoinUtils.apply(assertParam, cc.getTransactionManagerLookupClassName() == null, "transaction manager can not be used with ATOMIC cache");
        }
        if (!(cc.getEvictionPolicyFactory() == null && cc.getEvictionPolicy() == null || cc.isOnheapCacheEnabled())) {
            throw new IgniteCheckedException("Onheap cache must be enabled if eviction policy is configured [cacheName=" + U.maskName(cc.getName()) + "]");
        }
        if (cacheType != CacheType.DATA_STRUCTURES && DataStructuresProcessor.isDataStructureCache(cc.getName())) {
            throw new IgniteCheckedException("Using cache names reserved for datastructures is not allowed for other cache types [cacheName=" + cc.getName() + ", cacheType=" + (Object)((Object)cacheType) + "]");
        }
        if (cacheType != CacheType.DATA_STRUCTURES && DataStructuresProcessor.isReservedGroup(cc.getGroupName())) {
            throw new IgniteCheckedException("Using cache group names reserved for datastructures is not allowed for other cache types [cacheName=" + cc.getName() + ", groupName=" + cc.getGroupName() + ", cacheType=" + (Object)((Object)cacheType) + "]");
        }
        if (ctx.query().moduleEnabled() && F.eq(schema = QueryUtils.normalizeSchemaName(cc.getName(), cc.getSqlSchema()), QueryUtils.sysSchemaName())) {
            if (cc.getSqlSchema() == null) {
                throw new IgniteCheckedException("SQL schema name derived from cache name is reserved (please set explicit SQL schema name through CacheConfiguration.setSqlSchema() or choose another cache name) [cacheName=" + cc.getName() + ", schemaName=" + cc.getSqlSchema() + "]");
            }
            throw new IgniteCheckedException("SQL schema name is reserved (please choose another one) [cacheName=" + cc.getName() + ", schemaName=" + cc.getSqlSchema() + ']');
        }
        if (cc.isEncryptionEnabled() && !ctx.clientNode()) {
            StringBuilder cacheSpec = new StringBuilder("[cacheName=").append(cc.getName()).append(", groupName=").append(cc.getGroupName()).append(", cacheType=").append((Object)cacheType).append(']');
            if (!CU.isPersistentCache(cc, c.getDataStorageConfiguration())) {
                throw new IgniteCheckedException("Using encryption is not allowed for not persistent cache " + cacheSpec.toString());
            }
            EncryptionSpi encSpi = c.getEncryptionSpi();
            if (encSpi == null) {
                throw new IgniteCheckedException("EncryptionSpi should be configured to use encrypted cache " + cacheSpec.toString());
            }
        }
        Collection<QueryEntity> ents = cc.getQueryEntities();
        if (ctx.discovery().discoCache() != null && (nonDfltPrecScaleExists = ents.stream().anyMatch(e -> !F.isEmpty(e.getFieldsPrecision()) || !F.isEmpty(e.getFieldsScale()))) && PRECISION_SCALE_SINCE_VER.compareTo((oldestNode = ctx.discovery().discoCache().oldestServerNode()).version()) > 0) {
            throw new IgniteCheckedException("Non default precision and scale is supported since version 2.7. The node with oldest version [node=" + oldestNode + ']');
        }
    }

    static void checkConsistency(GridKernalContext ctx, IgniteLogger log) throws IgniteCheckedException {
        Collection<ClusterNode> rmtNodes = ctx.discovery().remoteNodes();
        boolean changeablePoolSize = IgniteFeatures.allNodesSupports(ctx, rmtNodes, IgniteFeatures.DIFFERENT_REBALANCE_POOL_SIZE);
        for (ClusterNode n : rmtNodes) {
            if (Boolean.TRUE.equals(n.attribute("org.apache.ignite.consistency.check.skipped"))) continue;
            if (!changeablePoolSize) {
                ValidationOnNodeJoinUtils.checkRebalanceConfiguration(n, ctx);
            }
            ValidationOnNodeJoinUtils.checkTransactionConfiguration(n, ctx, log);
            ValidationOnNodeJoinUtils.checkMemoryConfiguration(n, ctx);
            DeploymentMode locDepMode = ctx.config().getDeploymentMode();
            DeploymentMode rmtDepMode = (DeploymentMode)((Object)n.attribute("org.apache.ignite.ignite.dep.mode"));
            CU.checkAttributeMismatch(log, null, n.id(), "deploymentMode", "Deployment mode", (Object)locDepMode, (Object)rmtDepMode, true);
        }
    }

    private static List<String> validateRmtRegions(ClusterNode rmtNode, GridKernalContext ctx) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        DataStorageConfiguration rmtStorageCfg = ValidationOnNodeJoinUtils.extractDataStorage(rmtNode, ctx);
        Map<String, DataRegionConfiguration> rmtRegionCfgs = ValidationOnNodeJoinUtils.dataRegionCfgs(rmtStorageCfg);
        DataStorageConfiguration locStorageCfg = ctx.config().getDataStorageConfiguration();
        if (GridCacheUtils.isDefaultDataRegionPersistent(locStorageCfg) != GridCacheUtils.isDefaultDataRegionPersistent(rmtStorageCfg)) {
            errorMessages.add(String.format(INVALID_REGION_CONFIGURATION_MESSAGE, "DEFAULT", ctx.localNodeId(), GridCacheUtils.isDefaultDataRegionPersistent(locStorageCfg), rmtNode.id(), GridCacheUtils.isDefaultDataRegionPersistent(rmtStorageCfg)));
        }
        for (ClusterNode clusterNode : ctx.discovery().aliveServerNodes()) {
            Map<String, DataRegionConfiguration> nodeRegionCfg = ValidationOnNodeJoinUtils.dataRegionCfgs(ValidationOnNodeJoinUtils.extractDataStorage(clusterNode, ctx));
            for (Map.Entry<String, DataRegionConfiguration> nodeRegionCfgEntry : nodeRegionCfg.entrySet()) {
                String regionName = nodeRegionCfgEntry.getKey();
                DataRegionConfiguration rmtRegionCfg = rmtRegionCfgs.get(regionName);
                if (rmtRegionCfg == null || rmtRegionCfg.isPersistenceEnabled() == nodeRegionCfgEntry.getValue().isPersistenceEnabled()) continue;
                errorMessages.add(String.format(INVALID_REGION_CONFIGURATION_MESSAGE, regionName, ctx.localNodeId(), nodeRegionCfgEntry.getValue().isPersistenceEnabled(), rmtNode.id(), rmtRegionCfg.isPersistenceEnabled()));
            }
        }
        return errorMessages;
    }

    private static void apply(BiFunction<Boolean, String, IgniteCheckedException> assertParam, Boolean cond, String condDesc) throws IgniteCheckedException {
        IgniteCheckedException apply = assertParam.apply(cond, condDesc);
        if (apply != null) {
            throw apply;
        }
    }

    private static boolean storesLocallyOnClient(IgniteConfiguration c, CacheConfiguration cc, GridKernalContext ctx) {
        if (c.isClientMode().booleanValue() && c.getDataStorageConfiguration() == null) {
            if (cc.getCacheMode() == CacheMode.LOCAL) {
                return true;
            }
            return ctx.discovery().cacheAffinityNode(ctx.discovery().localNode(), cc.getName());
        }
        return false;
    }

    private static void checkRebalanceConfiguration(ClusterNode rmt, GridKernalContext ctx) throws IgniteCheckedException {
        ClusterNode locNode = ctx.discovery().localNode();
        if (ctx.config().isClientMode().booleanValue() || locNode.isDaemon() || rmt.isClient() || rmt.isDaemon()) {
            return;
        }
        Integer rebalanceThreadPoolSize = (Integer)rmt.attribute("org.apache.ignite.rebalance.pool.size");
        if (rebalanceThreadPoolSize != null && rebalanceThreadPoolSize.intValue() != ctx.config().getRebalanceThreadPoolSize()) {
            throw new IgniteCheckedException("Rebalance configuration mismatch (fix configuration or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property). Different values of such parameter may lead to rebalance process instability and hanging.  [rmtNodeId=" + rmt.id() + ", locRebalanceThreadPoolSize = " + ctx.config().getRebalanceThreadPoolSize() + ", rmtRebalanceThreadPoolSize = " + rebalanceThreadPoolSize + "]");
        }
    }

    private static void checkTransactionConfiguration(ClusterNode rmt, GridKernalContext ctx, IgniteLogger log) throws IgniteCheckedException {
        TransactionConfiguration rmtTxCfg = (TransactionConfiguration)rmt.attribute("org.apache.ignite.tx");
        if (rmtTxCfg != null) {
            TransactionConfiguration locTxCfg = ctx.config().getTransactionConfiguration();
            ValidationOnNodeJoinUtils.checkDeadlockDetectionConfig(rmt, rmtTxCfg, locTxCfg, log);
            ValidationOnNodeJoinUtils.checkSerializableEnabledConfig(rmt, rmtTxCfg, locTxCfg);
        }
    }

    private static void checkDeadlockDetectionConfig(ClusterNode rmt, TransactionConfiguration rmtTxCfg, TransactionConfiguration locTxCfg, IgniteLogger log) {
        boolean rmtDeadlockDetectionEnabled;
        boolean locDeadlockDetectionEnabled = locTxCfg.getDeadlockTimeout() > 0L;
        boolean bl = rmtDeadlockDetectionEnabled = rmtTxCfg.getDeadlockTimeout() > 0L;
        if (locDeadlockDetectionEnabled != rmtDeadlockDetectionEnabled) {
            U.warn(log, "Deadlock detection is enabled on one node and disabled on another. Disabled detection on one node can lead to undetected deadlocks. [rmtNodeId=" + rmt.id() + ", locDeadlockTimeout=" + locTxCfg.getDeadlockTimeout() + ", rmtDeadlockTimeout=" + rmtTxCfg.getDeadlockTimeout());
        }
    }

    private static void checkSerializableEnabledConfig(ClusterNode rmt, TransactionConfiguration rmtTxCfg, TransactionConfiguration locTxCfg) throws IgniteCheckedException {
        if (locTxCfg.isTxSerializableEnabled() != rmtTxCfg.isTxSerializableEnabled()) {
            throw new IgniteCheckedException("Serializable transactions enabled mismatch (fix txSerializableEnabled property or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property) [rmtNodeId=" + rmt.id() + ", locTxSerializableEnabled=" + locTxCfg.isTxSerializableEnabled() + ", rmtTxSerializableEnabled=" + rmtTxCfg.isTxSerializableEnabled() + ']');
        }
    }

    private static void checkMemoryConfiguration(ClusterNode rmt, GridKernalContext ctx) throws IgniteCheckedException {
        MemoryConfiguration memCfg;
        ClusterNode locNode = ctx.discovery().localNode();
        if (ctx.config().isClientMode().booleanValue() || locNode.isDaemon() || rmt.isClient() || rmt.isDaemon()) {
            return;
        }
        DataStorageConfiguration dsCfg = null;
        Object dsCfgBytes = rmt.attribute("org.apache.ignite.data.storage.config");
        if (dsCfgBytes instanceof byte[]) {
            dsCfg = (DataStorageConfiguration)new JdkMarshaller().unmarshal((byte[])dsCfgBytes, U.resolveClassLoader(ctx.config()));
        }
        if (dsCfg == null && (memCfg = (MemoryConfiguration)rmt.attribute("org.apache.ignite.memory")) != null) {
            dsCfg = new DataStorageConfiguration();
            dsCfg.setPageSize(memCfg.getPageSize());
        }
        if (dsCfg != null) {
            DataStorageConfiguration locDsCfg = ctx.config().getDataStorageConfiguration();
            if (dsCfg.getPageSize() != locDsCfg.getPageSize()) {
                throw new IgniteCheckedException("Memory configuration mismatch (fix configuration or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property) [rmtNodeId=" + rmt.id() + ", locPageSize = " + locDsCfg.getPageSize() + ", rmtPageSize = " + dsCfg.getPageSize() + "]");
            }
        }
    }

    @Nullable
    static IgniteNodeValidationResult validateHashIdResolvers(ClusterNode node, GridKernalContext ctx, Map<String, DynamicCacheDescriptor> map) {
        if (!node.isClient()) {
            for (DynamicCacheDescriptor desc : map.values()) {
                CacheConfiguration cfg = desc.cacheConfiguration();
                if (!(cfg.getAffinity() instanceof RendezvousAffinityFunction)) continue;
                RendezvousAffinityFunction aff = (RendezvousAffinityFunction)cfg.getAffinity();
                Object nodeHashObj = aff.resolveNodeHash(node);
                for (ClusterNode topNode : ctx.discovery().aliveServerNodes()) {
                    Object topNodeHashObj = aff.resolveNodeHash(topNode);
                    if (nodeHashObj.hashCode() != topNodeHashObj.hashCode()) continue;
                    String errMsg = "Failed to add node to topology because it has the same hash code for partitioned affinity as one of existing nodes [cacheName=" + cfg.getName() + ", existingNodeId=" + topNode.id() + ']';
                    String sndMsg = "Failed to add node to topology because it has the same hash code for partitioned affinity as one of existing nodes [cacheName=" + cfg.getName() + ", existingNodeId=" + topNode.id() + ']';
                    return new IgniteNodeValidationResult(topNode.id(), errMsg, sndMsg);
                }
            }
        }
        return null;
    }

    private static DataStorageConfiguration extractDataStorage(ClusterNode rmtNode, GridKernalContext ctx) {
        return GridCacheUtils.extractDataStorage(rmtNode, ctx.marshallerContext().jdkMarshaller(), U.resolveClassLoader(ctx.config()));
    }

    private static Map<String, DataRegionConfiguration> dataRegionCfgs(DataStorageConfiguration dataStorageCfg) {
        if (dataStorageCfg != null) {
            return Optional.ofNullable(dataStorageCfg.getDataRegionConfigurations()).map(Stream::of).orElseGet(Stream::empty).collect(Collectors.toMap(DataRegionConfiguration::getName, e -> e));
        }
        return Collections.emptyMap();
    }
}

