/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryFieldImpl;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.binary.streams.BinaryOffheapInputStream;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.CacheDefaultBinaryAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectByteArrayImpl;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IncompleteCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataFileStore;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataHolder;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataTransport;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataUpdatedListener;
import org.apache.ignite.internal.processors.cache.binary.IgniteBinaryImpl;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateResult;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.cacheobject.UserCacheObjectByteArrayImpl;
import org.apache.ignite.internal.processors.cacheobject.UserCacheObjectImpl;
import org.apache.ignite.internal.processors.cacheobject.UserKeyCacheObjectImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.MutableSingletonList;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridMapEntry;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.IgniteDiscoveryThread;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class CacheObjectBinaryProcessorImpl
extends GridProcessorAdapter
implements IgniteCacheObjectProcessor {
    private static final Collection<Class<?>> IMMUTABLE_CLS = new HashSet();
    private volatile boolean discoveryStarted;
    private volatile IgniteFuture<?> reconnectFut;
    private BinaryContext binaryCtx;
    private Marshaller marsh;
    private GridBinaryMarshaller binaryMarsh;
    private BinaryMetadataFileStore metadataFileStore;
    @Nullable
    private File binaryMetadataFileStoreDir;
    private long waitSchemaTimeout = IgniteSystemProperties.getLong("IGNITE_WAIT_SCHEMA_UPDATE", 30000L);
    public static boolean useTestBinaryCtx;
    @GridToStringExclude
    private IgniteBinary binaries;
    private final ConcurrentMap<Integer, BinaryMetadataHolder> metadataLocCache = new ConcurrentHashMap<Integer, BinaryMetadataHolder>();
    private BinaryMetadataTransport transport;
    private final ConcurrentHashMap<Integer, T1<BinaryField>> affKeyFields = new ConcurrentHashMap();

    public CacheObjectBinaryProcessorImpl(GridKernalContext ctx) {
        super(ctx);
        this.marsh = ctx.grid().configuration().getMarshaller();
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.marsh instanceof BinaryMarshaller) {
            BinaryConfiguration bCfg;
            if (!this.ctx.clientNode()) {
                this.metadataFileStore = new BinaryMetadataFileStore(this.metadataLocCache, this.ctx, this.log, this.binaryMetadataFileStoreDir);
            }
            BinaryMetadataHandler metaHnd = new BinaryMetadataHandler(){

                @Override
                public void addMeta(int typeId, BinaryType newMeta, boolean failIfUnregistered) throws BinaryObjectException {
                    assert (newMeta != null);
                    assert (newMeta instanceof BinaryTypeImpl);
                    if (!CacheObjectBinaryProcessorImpl.this.discoveryStarted) {
                        BinaryMetadata mergedMeta;
                        BinaryMetadataHolder holder = (BinaryMetadataHolder)CacheObjectBinaryProcessorImpl.this.metadataLocCache.get(typeId);
                        BinaryMetadata oldMeta = holder != null ? holder.metadata() : null;
                        if (oldMeta != (mergedMeta = BinaryUtils.mergeMetadata(oldMeta, ((BinaryTypeImpl)newMeta).metadata()))) {
                            CacheObjectBinaryProcessorImpl.this.metadataLocCache.put(typeId, new BinaryMetadataHolder(mergedMeta, 0, 0));
                        }
                        return;
                    }
                    BinaryMetadata newMeta0 = ((BinaryTypeImpl)newMeta).metadata();
                    CacheObjectBinaryProcessorImpl.this.addMeta(typeId, newMeta0.wrap(CacheObjectBinaryProcessorImpl.this.binaryCtx), failIfUnregistered);
                }

                @Override
                public BinaryType metadata(int typeId) throws BinaryObjectException {
                    return CacheObjectBinaryProcessorImpl.this.metadata(typeId);
                }

                @Override
                public BinaryMetadata metadata0(int typeId) throws BinaryObjectException {
                    return CacheObjectBinaryProcessorImpl.this.metadata0(typeId);
                }

                @Override
                public BinaryType metadata(int typeId, int schemaId) throws BinaryObjectException {
                    return CacheObjectBinaryProcessorImpl.this.metadata(typeId, schemaId);
                }

                @Override
                public Collection<BinaryType> metadata() throws BinaryObjectException {
                    return CacheObjectBinaryProcessorImpl.this.metadata();
                }
            };
            BinaryMarshaller bMarsh0 = (BinaryMarshaller)this.marsh;
            this.binaryCtx = useTestBinaryCtx ? new TestBinaryContext(metaHnd, this.ctx.config(), this.ctx.log(BinaryContext.class)) : new BinaryContext(metaHnd, this.ctx.config(), this.ctx.log(BinaryContext.class));
            this.transport = new BinaryMetadataTransport(this.metadataLocCache, this.metadataFileStore, this.binaryCtx, this.ctx, this.log);
            IgniteUtils.invoke(BinaryMarshaller.class, (Object)bMarsh0, "setBinaryContext", this.binaryCtx, this.ctx.config());
            this.binaryMarsh = new GridBinaryMarshaller(this.binaryCtx);
            this.binaries = new IgniteBinaryImpl(this.ctx, this);
            if (!IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK") && (bCfg = this.ctx.config().getBinaryConfiguration()) != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("globIdMapper", bCfg.getIdMapper() != null ? bCfg.getIdMapper().getClass().getName() : null);
                map.put("globSerializer", bCfg.getSerializer() != null ? bCfg.getSerializer().getClass() : null);
                map.put("compactFooter", bCfg.isCompactFooter());
                if (bCfg.getTypeConfigurations() != null) {
                    HashMap<Boolean, List<Serializable>> typeCfgsMap = new HashMap<Boolean, List<Serializable>>();
                    for (BinaryTypeConfiguration c : bCfg.getTypeConfigurations()) {
                        typeCfgsMap.put(c.getTypeName() != null, Arrays.asList(c.getIdMapper() != null ? c.getIdMapper().getClass() : null, c.getSerializer() != null ? c.getSerializer().getClass() : null, c.isEnum()));
                        if (!c.isEnum()) continue;
                        BinaryUtils.validateEnumValues(c.getTypeName(), c.getEnumValues());
                    }
                    map.put("typeCfgs", typeCfgsMap);
                }
                this.ctx.addNodeAttribute("org.apache.ignite.binary.config", map);
            }
            if (!this.ctx.clientNode()) {
                this.metadataFileStore.restoreMetadata();
            }
        }
    }

    public void addBinaryMetadataUpdateListener(BinaryMetadataUpdatedListener lsnr) {
        if (this.transport != null) {
            this.transport.addBinaryMetadataUpdateListener(lsnr);
        }
    }

    @Override
    public void stop(boolean cancel) {
        if (this.transport != null) {
            this.transport.stop();
        }
        if (this.metadataFileStore != null) {
            this.metadataFileStore.stop();
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.reconnectFut = reconnectFut;
        if (this.transport != null) {
            this.transport.onDisconnected();
        }
        this.binaryContext().unregisterUserTypeDescriptors();
        this.binaryContext().unregisterBinarySchemas();
        this.metadataLocCache.clear();
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        this.reconnectFut = null;
        return super.onReconnected(clusterRestarted);
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        super.onKernalStart(active);
        this.discoveryStarted = true;
    }

    @Override
    @Nullable
    public CacheObject prepareForCache(@Nullable CacheObject obj, GridCacheContext cctx) {
        if (obj == null) {
            return null;
        }
        return obj.prepareForCache(cctx.cacheObjectContext());
    }

    @Override
    public int typeId(String typeName) {
        if (this.binaryCtx == null) {
            return 0;
        }
        return this.binaryCtx.typeId(typeName);
    }

    @Override
    public boolean immutable(Object obj) {
        assert (obj != null);
        return IMMUTABLE_CLS.contains(obj.getClass());
    }

    @Override
    public void onContinuousProcessorStarted(GridKernalContext ctx) {
    }

    public byte[] marshal(@Nullable Object obj) throws BinaryObjectException {
        byte[] arr = this.binaryMarsh.marshal(obj, false);
        assert (arr.length > 0);
        return arr;
    }

    public Object unmarshal(long ptr, boolean forceHeap) throws BinaryObjectException {
        byte type;
        assert (ptr > 0L) : ptr;
        int size = GridUnsafe.getInt(ptr);
        ptr += 4L;
        if ((type = GridUnsafe.getByte(ptr++)) != 2) {
            assert (size > 0) : size;
            BinaryOffheapInputStream in = new BinaryOffheapInputStream(ptr, size, forceHeap);
            return this.binaryMarsh.unmarshal(in);
        }
        return U.copyMemory(ptr, size);
    }

    @Override
    public Object marshalToBinary(@Nullable Object obj, boolean failIfUnregistered) throws BinaryObjectException {
        if (obj == null) {
            return null;
        }
        if (BinaryUtils.isBinaryType(obj.getClass())) {
            return obj;
        }
        if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            Object[] pArr = new Object[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                pArr[i] = this.marshalToBinary(arr[i], failIfUnregistered);
            }
            return pArr;
        }
        if (obj instanceof IgniteBiTuple) {
            IgniteBiTuple tup = (IgniteBiTuple)obj;
            if (obj instanceof T2) {
                return new T2<Object, Object>(this.marshalToBinary(tup.get1(), failIfUnregistered), this.marshalToBinary(tup.get2(), failIfUnregistered));
            }
            return new IgniteBiTuple<Object, Object>(this.marshalToBinary(tup.get1(), failIfUnregistered), this.marshalToBinary(tup.get2(), failIfUnregistered));
        }
        Collection pCol = BinaryUtils.newKnownCollection(obj);
        if (pCol != null) {
            Collection col = (Collection)obj;
            for (Object item : col) {
                pCol.add(this.marshalToBinary(item, failIfUnregistered));
            }
            return pCol instanceof MutableSingletonList ? U.convertToSingletonList(pCol) : pCol;
        }
        Map<Object, Object> pMap = BinaryUtils.newKnownMap(obj);
        if (pMap != null) {
            Map map = (Map)obj;
            for (Map.Entry e : map.entrySet()) {
                pMap.put(this.marshalToBinary(e.getKey(), failIfUnregistered), this.marshalToBinary(e.getValue(), failIfUnregistered));
            }
            return pMap;
        }
        if (obj instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)obj;
            return new GridMapEntry<Object, Object>(this.marshalToBinary(e.getKey(), failIfUnregistered), this.marshalToBinary(e.getValue(), failIfUnregistered));
        }
        if (this.binaryMarsh.mustDeserialize(obj)) {
            return obj;
        }
        byte[] arr = this.binaryMarsh.marshal(obj, failIfUnregistered);
        assert (arr.length > 0);
        Object obj0 = this.binaryMarsh.unmarshal(arr, null);
        if (obj0 instanceof BinaryObjectImpl) {
            ((BinaryObjectImpl)obj0).detachAllowed(true);
        }
        return obj0;
    }

    public GridBinaryMarshaller marshaller() {
        return this.binaryMarsh;
    }

    @Override
    public BinaryObjectBuilder builder(String clsName) {
        return new BinaryObjectBuilderImpl(this.binaryCtx, clsName);
    }

    @Override
    public BinaryObjectBuilder builder(BinaryObject binaryObj) {
        return BinaryObjectBuilderImpl.wrap(binaryObj);
    }

    @Override
    public void updateMetadata(int typeId, String typeName, @Nullable String affKeyFieldName, Map<String, BinaryFieldMetadata> fieldTypeIds, boolean isEnum, @Nullable Map<String, Integer> enumMap) throws BinaryObjectException {
        BinaryMetadata meta = new BinaryMetadata(typeId, typeName, fieldTypeIds, affKeyFieldName, null, isEnum, enumMap);
        this.binaryCtx.updateMetadata(typeId, meta, false);
    }

    @Override
    public void addMeta(int typeId, BinaryType newMeta, boolean failIfUnregistered) throws BinaryObjectException {
        assert (newMeta != null);
        assert (newMeta instanceof BinaryTypeImpl);
        BinaryMetadata newMeta0 = ((BinaryTypeImpl)newMeta).metadata();
        if (failIfUnregistered) {
            this.failIfUnregistered(typeId, newMeta0);
            return;
        }
        try {
            GridFutureAdapter<MetadataUpdateResult> fut = this.transport.requestMetadataUpdate(newMeta0);
            if (fut == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Metadata update was skipped [typeId=" + typeId + ", typeName=" + newMeta.typeName() + ']');
                }
                return;
            }
            long t0 = System.nanoTime();
            MetadataUpdateResult res = fut.get();
            if (this.log.isDebugEnabled()) {
                IgniteInternalTx tx = (IgniteInternalTx)this.ctx.cache().context().tm().tx();
                this.log.debug("Completed metadata update [typeId=" + typeId + ", typeName=" + newMeta.typeName() + ", waitTime=" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - t0, TimeUnit.NANOSECONDS) + "ms, fut=" + fut + ", tx=" + CU.txString(tx) + ']');
            }
            assert (res != null);
            if (res.rejected()) {
                throw res.error();
            }
            if (!this.ctx.clientNode()) {
                this.metadataFileStore.waitForWriteCompletion(typeId, res.typeVersion());
            }
        }
        catch (IgniteCheckedException e) {
            IgniteCheckedException ex = e;
            if (this.ctx.isStopping()) {
                ex = new NodeStoppingException("Node is stopping.");
                ex.addSuppressed(e);
            }
            throw new BinaryObjectException("Failed to update metadata for type: " + newMeta.typeName(), ex);
        }
    }

    private void failIfUnregistered(int typeId, BinaryMetadata newMeta0) {
        BinaryMetadataHolder metaHolder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
        BinaryMetadata oldMeta = metaHolder != null ? metaHolder.metadata() : null;
        BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta0);
        if (mergedMeta != oldMeta) {
            throw new UnregisteredBinaryTypeException(typeId, mergedMeta);
        }
        if (metaHolder.pendingVersion() == metaHolder.acceptedVersion()) {
            return;
        }
        GridFutureAdapter<MetadataUpdateResult> fut = this.transport.awaitMetadataUpdate(typeId, metaHolder.pendingVersion());
        if (!fut.isDone()) {
            throw new UnregisteredBinaryTypeException(typeId, fut);
        }
    }

    @Override
    public void addMetaLocally(int typeId, BinaryType newMeta) throws BinaryObjectException {
        assert (newMeta != null);
        assert (newMeta instanceof BinaryTypeImpl);
        BinaryMetadata newMeta0 = ((BinaryTypeImpl)newMeta).metadata();
        BinaryMetadataHolder metaHolder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
        BinaryMetadata oldMeta = metaHolder != null ? metaHolder.metadata() : null;
        try {
            BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta0);
            if (!this.ctx.clientNode()) {
                this.metadataFileStore.mergeAndWriteMetadata(mergedMeta);
            }
            this.metadataLocCache.put(typeId, new BinaryMetadataHolder(mergedMeta, 0, 0));
        }
        catch (BinaryObjectException e) {
            throw new BinaryObjectException("New binary metadata is incompatible with binary metadata persisted locally. Consider cleaning up persisted metadata from <workDir>/db/binary_meta directory.", e);
        }
    }

    @Override
    @Nullable
    public BinaryType metadata(int typeId) {
        BinaryMetadata meta = this.metadata0(typeId);
        return meta != null ? meta.wrap(this.binaryCtx) : null;
    }

    public void waitMetadataWriteIfNeeded(int typeId) {
        if (this.metadataFileStore == null) {
            return;
        }
        BinaryMetadataHolder hldr = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
        if (hldr != null) {
            try {
                this.metadataFileStore.waitForWriteCompletion(typeId, hldr.pendingVersion());
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Failed to wait for metadata write operation for [typeId=" + typeId + ", typeVer=" + hldr.acceptedVersion() + ']', e);
            }
        }
    }

    @Nullable
    public BinaryMetadata metadata0(int typeId) {
        BinaryMetadataHolder holder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
        IgniteThread curThread = IgniteThread.current();
        if (holder == null && (curThread == null || !curThread.isForbiddenToRequestBinaryMetadata()) && this.ctx.clientNode()) {
            try {
                this.transport.requestUpToDateMetadata(typeId).get();
                holder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
        }
        if (holder != null) {
            if (holder.removing()) {
                GridFutureAdapter<MetadataUpdateResult> fut = this.transport.awaitMetadataRemove(typeId);
                try {
                    fut.get();
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
                return null;
            }
            if (curThread instanceof IgniteDiscoveryThread || curThread != null && curThread.isForbiddenToRequestBinaryMetadata()) {
                return holder.metadata();
            }
            if (holder.pendingVersion() - holder.acceptedVersion() > 0) {
                GridFutureAdapter<MetadataUpdateResult> fut = this.transport.awaitMetadataUpdate(typeId, holder.pendingVersion());
                if (this.log.isDebugEnabled() && !fut.isDone()) {
                    this.log.debug("Waiting for update for [typeId=" + typeId + ", pendingVer=" + holder.pendingVersion() + ", acceptedVer=" + holder.acceptedVersion() + "]");
                }
                try {
                    fut.get();
                }
                catch (IgniteCheckedException igniteCheckedException) {}
            } else if (this.metadataFileStore != null) {
                try {
                    this.metadataFileStore.waitForWriteCompletion(typeId, holder.pendingVersion());
                }
                catch (IgniteCheckedException e) {
                    this.log.warning("Failed to wait for metadata write operation for [typeId=" + typeId + ", typeVer=" + holder.acceptedVersion() + ']', e);
                    return null;
                }
            }
            return holder.metadata();
        }
        return null;
    }

    @Override
    @Nullable
    public BinaryType metadata(int typeId, int schemaId) {
        BinaryMetadataHolder holder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
        if (this.ctx.clientNode()) {
            if (holder == null || !holder.metadata().hasSchema(schemaId)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Waiting for client metadata update [typeId=" + typeId + ", schemaId=" + schemaId + ", pendingVer=" + (holder == null ? "NA" : Integer.valueOf(holder.pendingVersion())) + ", acceptedVer=" + (holder == null ? "NA" : Integer.valueOf(holder.acceptedVersion())) + ']');
                }
                try {
                    this.transport.requestUpToDateMetadata(typeId).get();
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
                holder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
                IgniteFuture<?> reconnectFut0 = this.reconnectFut;
                if (holder == null && reconnectFut0 != null) {
                    throw new IgniteClientDisconnectedException(reconnectFut0, "Client node disconnected.");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Finished waiting for client metadata update [typeId=" + typeId + ", schemaId=" + schemaId + ", pendingVer=" + (holder == null ? "NA" : Integer.valueOf(holder.pendingVersion())) + ", acceptedVer=" + (holder == null ? "NA" : Integer.valueOf(holder.acceptedVersion())) + ']');
                }
            }
        } else {
            if (holder != null && IgniteThread.current() instanceof IgniteDiscoveryThread) {
                return holder.metadata().wrap(this.binaryCtx);
            }
            if (holder != null && holder.pendingVersion() - holder.acceptedVersion() > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Waiting for metadata update [typeId=" + typeId + ", schemaId=" + schemaId + ", pendingVer=" + holder.pendingVersion() + ", acceptedVer=" + holder.acceptedVersion() + ']');
                }
                long t0 = System.nanoTime();
                GridFutureAdapter<MetadataUpdateResult> fut = this.transport.awaitMetadataUpdate(typeId, holder.pendingVersion());
                try {
                    fut.get();
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Failed to wait for metadata update [typeId=" + typeId + ", schemaId=" + schemaId + ']', e);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Finished waiting for metadata update [typeId=" + typeId + ", waitTime=" + TimeUnit.NANOSECONDS.convert(System.nanoTime() - t0, TimeUnit.MILLISECONDS) + "ms, schemaId=" + schemaId + ", pendingVer=" + holder.pendingVersion() + ", acceptedVer=" + holder.acceptedVersion() + ']');
                }
                holder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
            } else if (holder == null || !holder.metadata().hasSchema(schemaId)) {
                U.warn(this.log, "Schema is missing while no metadata updates are in progress (will wait for schema update within timeout defined by IGNITE_WAIT_SCHEMA_UPDATE system property) [typeId=" + typeId + ", missingSchemaId=" + schemaId + ", pendingVer=" + (holder == null ? "NA" : Integer.valueOf(holder.pendingVersion())) + ", acceptedVer=" + (holder == null ? "NA" : Integer.valueOf(holder.acceptedVersion())) + ", binMetaUpdateTimeout=" + this.waitSchemaTimeout + ']');
                long t0 = System.nanoTime();
                GridFutureAdapter<?> fut = this.transport.awaitSchemaUpdate(typeId, schemaId);
                try {
                    fut.get(this.waitSchemaTimeout);
                }
                catch (IgniteFutureTimeoutCheckedException e) {
                    this.log.error("Timed out while waiting for schema update [typeId=" + typeId + ", schemaId=" + schemaId + ']');
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
                holder = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
                if (this.log.isDebugEnabled() && holder != null && holder.metadata().hasSchema(schemaId)) {
                    this.log.debug("Found the schema after wait [typeId=" + typeId + ", waitTime=" + TimeUnit.NANOSECONDS.convert(System.nanoTime() - t0, TimeUnit.MILLISECONDS) + "ms, schemaId=" + schemaId + ", pendingVer=" + holder.pendingVersion() + ", acceptedVer=" + holder.acceptedVersion() + ']');
                }
            }
        }
        if (holder != null && this.metadataFileStore != null) {
            try {
                this.metadataFileStore.waitForWriteCompletion(typeId, holder.pendingVersion());
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Failed to wait for metadata write operation for [typeId=" + typeId + ", typeVer=" + holder.acceptedVersion() + ']', e);
                return null;
            }
        }
        return holder != null ? holder.metadata().wrap(this.binaryCtx) : null;
    }

    @Override
    public Map<Integer, BinaryType> metadata(Collection<Integer> typeIds) throws BinaryObjectException {
        try {
            HashMap<Integer, BinaryType> res = U.newHashMap(this.metadataLocCache.size());
            for (Map.Entry e : this.metadataLocCache.entrySet()) {
                res.put((Integer)e.getKey(), ((BinaryMetadataHolder)e.getValue()).metadata().wrap(this.binaryCtx));
            }
            return res;
        }
        catch (CacheException e) {
            throw new BinaryObjectException(e);
        }
    }

    @Override
    public Collection<BinaryType> metadata() throws BinaryObjectException {
        return F.viewReadOnly(this.metadataLocCache.values(), new IgniteClosure<BinaryMetadataHolder, BinaryType>(){

            @Override
            public BinaryType apply(BinaryMetadataHolder metaHolder) {
                return metaHolder.metadata().wrap(CacheObjectBinaryProcessorImpl.this.binaryCtx);
            }
        }, new IgnitePredicate[0]);
    }

    public Collection<BinaryMetadata> binaryMetadata() throws BinaryObjectException {
        return F.viewReadOnly(this.metadataLocCache.values(), new IgniteClosure<BinaryMetadataHolder, BinaryMetadata>(){

            @Override
            public BinaryMetadata apply(BinaryMetadataHolder metaHolder) {
                return metaHolder.metadata();
            }
        }, new IgnitePredicate[0]);
    }

    public BinaryMetadata binaryMetadata(int typeId) throws BinaryObjectException {
        BinaryMetadataHolder hld = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
        return hld != null ? hld.metadata() : null;
    }

    @Override
    public BinaryObject buildEnum(String typeName, int ord) throws BinaryObjectException {
        A.notNullOrEmpty(typeName, "enum type name");
        int typeId = this.binaryCtx.typeId(typeName);
        typeName = this.binaryCtx.userTypeName(typeName);
        this.updateMetadata(typeId, typeName, null, null, true, null);
        return new BinaryEnumObjectImpl(this.binaryCtx, typeId, null, ord);
    }

    @Override
    public BinaryObject buildEnum(String typeName, String name) throws BinaryObjectException {
        A.notNullOrEmpty(typeName, "enum type name");
        A.notNullOrEmpty(name, "enum name");
        int typeId = this.binaryCtx.typeId(typeName);
        BinaryMetadata metadata = this.metadata0(typeId);
        if (metadata == null) {
            throw new BinaryObjectException("Failed to get metadata for type [typeId=" + typeId + ", typeName='" + typeName + "']");
        }
        Integer ordinal = metadata.getEnumOrdinalByName(name);
        typeName = this.binaryCtx.userTypeName(typeName);
        if (ordinal == null) {
            throw new BinaryObjectException("Failed to resolve enum ordinal by name [typeId=" + typeId + ", typeName='" + typeName + "', name='" + name + "']");
        }
        return new BinaryEnumObjectImpl(this.binaryCtx, typeId, null, ordinal);
    }

    @Override
    public BinaryType registerEnum(String typeName, Map<String, Integer> vals) throws BinaryObjectException {
        A.notNullOrEmpty(typeName, "enum type name");
        int typeId = this.binaryCtx.typeId(typeName);
        typeName = this.binaryCtx.userTypeName(typeName);
        BinaryUtils.validateEnumValues(typeName, vals);
        this.updateMetadata(typeId, typeName, null, null, true, vals);
        return this.binaryCtx.metadata(typeId);
    }

    @Override
    public IgniteBinary binary() throws IgniteException {
        return this.binaries;
    }

    @Override
    public boolean isBinaryObject(Object obj) {
        return obj instanceof BinaryObject;
    }

    @Override
    public boolean isBinaryEnabled(CacheConfiguration<?, ?> ccfg) {
        return this.marsh instanceof BinaryMarshaller;
    }

    public BinaryField affinityKeyField(int typeId) {
        T1<BinaryField> fieldHolder = this.affKeyFields.get(typeId);
        if (fieldHolder != null) {
            return (BinaryField)fieldHolder.get();
        }
        String name = this.binaryCtx.affinityKeyFieldName(typeId);
        if (name != null) {
            BinaryFieldImpl field = this.binaryCtx.createField(typeId, name);
            this.affKeyFields.putIfAbsent(typeId, new T1<BinaryFieldImpl>(field));
            return field;
        }
        this.affKeyFields.putIfAbsent(typeId, new T1<Object>(null));
        return null;
    }

    @Override
    public int typeId(Object obj) {
        if (obj == null) {
            return 0;
        }
        return this.isBinaryObject(obj) ? ((BinaryObjectEx)obj).typeId() : this.typeId(obj.getClass().getSimpleName());
    }

    @Override
    public Object field(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        return this.isBinaryObject(obj) ? ((BinaryObject)obj).field(fieldName) : null;
    }

    @Override
    public boolean hasField(Object obj, String fieldName) {
        return obj != null && ((BinaryObject)obj).hasField(fieldName);
    }

    public BinaryContext binaryContext() {
        return this.binaryCtx;
    }

    @Override
    public CacheObjectContext contextForCache(CacheConfiguration ccfg) throws IgniteCheckedException {
        assert (ccfg != null);
        boolean storeVal = !ccfg.isCopyOnRead() || !this.isBinaryEnabled(ccfg) && (QueryUtils.isEnabled(ccfg) || this.ctx.config().isPeerClassLoadingEnabled());
        boolean binaryEnabled = this.marsh instanceof BinaryMarshaller && !GridCacheUtils.isSystemCache(ccfg.getName());
        AffinityKeyMapper cacheAffMapper = ccfg.getAffinityMapper();
        GridCacheDefaultAffinityKeyMapper dfltAffMapper = binaryEnabled ? new CacheDefaultBinaryAffinityKeyMapper(ccfg.getKeyConfiguration()) : new GridCacheDefaultAffinityKeyMapper();
        this.ctx.resource().injectGeneric(dfltAffMapper);
        return new CacheObjectContext(this.ctx, ccfg.getName(), dfltAffMapper, QueryUtils.isCustomAffinityMapper(ccfg.getAffinityMapper()), ccfg.isCopyOnRead(), storeVal, this.ctx.config().isPeerClassLoadingEnabled() && !this.isBinaryEnabled(ccfg), binaryEnabled);
    }

    @Override
    public byte[] marshal(CacheObjectValueContext ctx, Object val) throws IgniteCheckedException {
        if (!ctx.binaryEnabled() || this.binaryMarsh == null) {
            return CU.marshal(ctx.kernalContext().cache().context(), ctx.addDeploymentInfo(), val);
        }
        byte[] arr = this.binaryMarsh.marshal(val, false);
        assert (arr.length > 0);
        return arr;
    }

    @Override
    public Object unmarshal(CacheObjectValueContext ctx, byte[] bytes, ClassLoader clsLdr) throws IgniteCheckedException {
        if (!ctx.binaryEnabled() || this.binaryMarsh == null) {
            return U.unmarshal(ctx.kernalContext(), bytes, U.resolveClassLoader(clsLdr, ctx.kernalContext().config()));
        }
        return this.binaryMarsh.unmarshal(bytes, clsLdr);
    }

    @Override
    public KeyCacheObject toCacheKeyObject(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj, boolean userObj) {
        if (!ctx.binaryEnabled()) {
            if (obj instanceof KeyCacheObject) {
                KeyCacheObject key = (KeyCacheObject)obj;
                if (key.partition() == -1) {
                    key.partition(this.partition(ctx, cctx, key));
                }
                return (KeyCacheObject)obj;
            }
            return this.toCacheKeyObject0(ctx, cctx, obj, userObj);
        }
        if (obj instanceof KeyCacheObject) {
            KeyCacheObject key = (KeyCacheObject)obj;
            if (key instanceof BinaryObjectImpl) {
                key = key.copy(this.partition(ctx, cctx, key));
            } else if (key.partition() == -1) {
                key.partition(this.partition(ctx, cctx, key));
            }
            return key;
        }
        if ((obj = this.toBinary(obj, false)) instanceof BinaryObjectImpl) {
            ((KeyCacheObject)obj).partition(this.partition(ctx, cctx, obj));
            return (KeyCacheObject)obj;
        }
        return this.toCacheKeyObject0(ctx, cctx, obj, userObj);
    }

    protected KeyCacheObject toCacheKeyObject0(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj, boolean userObj) {
        int part = this.partition(ctx, cctx, obj);
        if (!userObj) {
            return new KeyCacheObjectImpl(obj, null, part);
        }
        return new UserKeyCacheObjectImpl(obj, part);
    }

    @Override
    @Nullable
    public CacheObject toCacheObject(CacheObjectContext ctx, @Nullable Object obj, boolean userObj, boolean failIfUnregistered) {
        if (!ctx.binaryEnabled()) {
            if (obj == null || obj instanceof CacheObject) {
                return (CacheObject)obj;
            }
            return this.toCacheObject0(obj, userObj);
        }
        if (obj == null || obj instanceof CacheObject) {
            return (CacheObject)obj;
        }
        if ((obj = this.toBinary(obj, failIfUnregistered)) instanceof CacheObject) {
            return (CacheObject)obj;
        }
        return this.toCacheObject0(obj, userObj);
    }

    private CacheObject toCacheObject0(@Nullable Object obj, boolean userObj) {
        assert (obj != null);
        if (obj instanceof byte[]) {
            if (!userObj) {
                return new CacheObjectByteArrayImpl((byte[])obj);
            }
            return new UserCacheObjectByteArrayImpl((byte[])obj);
        }
        if (!userObj) {
            return new CacheObjectImpl(obj, null);
        }
        return new UserCacheObjectImpl(obj, null);
    }

    private int partition(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj) {
        try {
            return cctx != null ? cctx.affinity().partition(obj, false) : ctx.kernalContext().affinity().partition0(ctx.cacheName(), obj, null);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to get partition", e);
            return -1;
        }
    }

    @Override
    public CacheObject toCacheObject(CacheObjectContext ctx, byte type, byte[] bytes) {
        switch (type) {
            case 100: {
                return new BinaryObjectImpl(this.binaryContext(), bytes, 0);
            }
            case 101: {
                return new BinaryEnumObjectImpl(this.binaryContext(), bytes);
            }
            case 2: {
                return new CacheObjectByteArrayImpl(bytes);
            }
            case 1: {
                return new CacheObjectImpl(null, bytes);
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + type);
    }

    @Override
    public KeyCacheObject toKeyCacheObject(CacheObjectContext ctx, byte type, byte[] bytes) throws IgniteCheckedException {
        switch (type) {
            case 100: {
                return new BinaryObjectImpl(this.binaryContext(), bytes, 0);
            }
            case 2: {
                throw new IllegalArgumentException("Byte arrays cannot be used as cache keys.");
            }
            case 1: {
                return new KeyCacheObjectImpl(ctx.kernalContext().cacheObjects().unmarshal(ctx, bytes, null), bytes, -1);
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + type);
    }

    @Override
    public CacheObject toCacheObject(CacheObjectContext ctx, ByteBuffer buf) {
        int len = buf.getInt();
        assert (len >= 0) : len;
        byte type = buf.get();
        byte[] data = new byte[len];
        buf.get(data);
        return this.toCacheObject(ctx, type, data);
    }

    @Override
    public IncompleteCacheObject toCacheObject(CacheObjectContext ctx, ByteBuffer buf, @Nullable IncompleteCacheObject incompleteObj) {
        if (incompleteObj == null) {
            incompleteObj = new IncompleteCacheObject(buf);
        }
        if (incompleteObj.isReady()) {
            return incompleteObj;
        }
        incompleteObj.readData(buf);
        if (incompleteObj.isReady()) {
            incompleteObj.object(this.toCacheObject(ctx, incompleteObj.type(), incompleteObj.data()));
        }
        return incompleteObj;
    }

    @Override
    public IncompleteCacheObject toKeyCacheObject(CacheObjectContext ctx, ByteBuffer buf, @Nullable IncompleteCacheObject incompleteObj) throws IgniteCheckedException {
        if (incompleteObj == null) {
            incompleteObj = new IncompleteCacheObject(buf);
        }
        if (incompleteObj.isReady()) {
            return incompleteObj;
        }
        incompleteObj.readData(buf);
        if (incompleteObj.isReady()) {
            incompleteObj.object(this.toKeyCacheObject(ctx, incompleteObj.type(), incompleteObj.data()));
        }
        return incompleteObj;
    }

    @Override
    @Nullable
    public CacheObject toCacheObject(CacheObjectContext ctx, @Nullable Object obj, boolean userObj) {
        return this.toCacheObject(ctx, obj, userObj, false);
    }

    @Override
    public Object unwrapTemporary(GridCacheContext ctx, Object obj) throws BinaryObjectException {
        if (!ctx.cacheObjectContext().binaryEnabled()) {
            return obj;
        }
        if (obj instanceof BinaryObjectOffheapImpl) {
            return ((BinaryObjectOffheapImpl)obj).heapCopy();
        }
        return obj;
    }

    @Nullable
    public Object toBinary(@Nullable Object obj, boolean failIfUnregistered) throws IgniteException {
        if (obj == null) {
            return null;
        }
        if (this.isBinaryObject(obj)) {
            return obj;
        }
        return this.marshalToBinary(obj, failIfUnregistered);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode rmtNode, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        if (IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK") || !(this.marsh instanceof BinaryMarshaller)) {
            return null;
        }
        IgniteNodeValidationResult res = this.validateBinaryConfiguration(rmtNode);
        if (res != null) {
            return res;
        }
        return this.validateBinaryMetadata(rmtNode.id(), (Map)((Object)discoData.joiningNodeData()));
    }

    private IgniteNodeValidationResult validateBinaryConfiguration(ClusterNode rmtNode) {
        Object rmtBinaryCfg = rmtNode.attribute("org.apache.ignite.binary.config");
        ClusterNode locNode = this.ctx.discovery().localNode();
        Object locBinaryCfg = locNode.attribute("org.apache.ignite.binary.config");
        if (!F.eq(locBinaryCfg, rmtBinaryCfg)) {
            String msg = "Local node's binary configuration is not equal to remote node's binary configuration [locNodeId=%s, rmtNodeId=%s, locBinaryCfg=%s, rmtBinaryCfg=%s]";
            return new IgniteNodeValidationResult(rmtNode.id(), String.format(msg, locNode.id(), rmtNode.id(), locBinaryCfg, rmtBinaryCfg), String.format(msg, rmtNode.id(), locNode.id(), rmtBinaryCfg, locBinaryCfg));
        }
        return null;
    }

    private IgniteNodeValidationResult validateBinaryMetadata(UUID rmtNodeId, Map<Integer, BinaryMetadataHolder> newNodeMeta) {
        if (newNodeMeta == null) {
            return null;
        }
        for (Map.Entry<Integer, BinaryMetadataHolder> metaEntry : newNodeMeta.entrySet()) {
            if (!this.metadataLocCache.containsKey(metaEntry.getKey())) continue;
            BinaryMetadata locMeta = ((BinaryMetadataHolder)this.metadataLocCache.get(metaEntry.getKey())).metadata();
            BinaryMetadata rmtMeta = metaEntry.getValue().metadata();
            if (locMeta == null || rmtMeta == null) continue;
            try {
                BinaryUtils.mergeMetadata(locMeta, rmtMeta);
            }
            catch (Exception e) {
                String locMsg = "Exception was thrown when merging binary metadata from node %s: %s";
                String rmtMsg = "Exception was thrown on coordinator when merging binary metadata from this node: %s";
                return new IgniteNodeValidationResult(rmtNodeId, String.format(locMsg, rmtNodeId.toString(), e.getMessage()), String.format(rmtMsg, e.getMessage()));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.BINARY_PROC;
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (!dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.BINARY_PROC.ordinal())) {
            HashMap res = U.newHashMap(this.metadataLocCache.size());
            for (Map.Entry e : this.metadataLocCache.entrySet()) {
                if (((BinaryMetadataHolder)e.getValue()).removing()) continue;
                res.put(e.getKey(), e.getValue());
            }
            dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.BINARY_PROC.ordinal(), res);
        }
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        HashMap res = U.newHashMap(this.metadataLocCache.size());
        for (Map.Entry e : this.metadataLocCache.entrySet()) {
            res.put(e.getKey(), e.getValue());
        }
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.BINARY_PROC.ordinal(), res);
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        Map newNodeMeta = (Map)((Object)data.joiningNodeData());
        if (newNodeMeta == null) {
            return;
        }
        UUID joiningNode = data.joiningNodeId();
        for (Map.Entry metaEntry : newNodeMeta.entrySet()) {
            BinaryMetadata newMeta;
            if (this.metadataLocCache.containsKey(metaEntry.getKey())) {
                BinaryMetadataHolder localMetaHolder = (BinaryMetadataHolder)this.metadataLocCache.get(metaEntry.getKey());
                newMeta = ((BinaryMetadataHolder)metaEntry.getValue()).metadata();
                BinaryMetadata localMeta = localMetaHolder.metadata();
                BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(localMeta, newMeta);
                if (mergedMeta == localMeta) continue;
                U.log(this.log, String.format("Newer version of existing BinaryMetadata[typeId=%d, typeName=%s] is received from node %s; updating it locally", mergedMeta.typeId(), mergedMeta.typeName(), joiningNode));
                this.metadataLocCache.put((Integer)metaEntry.getKey(), new BinaryMetadataHolder(mergedMeta, localMetaHolder.pendingVersion(), localMetaHolder.acceptedVersion()));
                if (this.ctx.clientNode()) continue;
                this.metadataFileStore.writeMetadata(mergedMeta);
                continue;
            }
            BinaryMetadataHolder newMetaHolder = (BinaryMetadataHolder)metaEntry.getValue();
            newMeta = newMetaHolder.metadata();
            U.log(this.log, String.format("New BinaryMetadata[typeId=%d, typeName=%s] is received from node %s; adding it locally", newMeta.typeId(), newMeta.typeName(), joiningNode));
            this.metadataLocCache.put((Integer)metaEntry.getKey(), newMetaHolder);
            if (this.ctx.clientNode()) continue;
            this.metadataFileStore.writeMetadata(newMeta);
        }
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        Map receivedData = (Map)((Object)data.commonData());
        if (receivedData != null) {
            for (Map.Entry e : receivedData.entrySet()) {
                BinaryMetadataHolder holder = (BinaryMetadataHolder)e.getValue();
                BinaryMetadataHolder localHolder = new BinaryMetadataHolder(holder.metadata(), holder.pendingVersion(), holder.pendingVersion());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received metadata on join: " + localHolder);
                }
                this.metadataLocCache.put((Integer)e.getKey(), localHolder);
                if (this.ctx.clientNode()) continue;
                this.metadataFileStore.writeMetadata(holder.metadata());
            }
        }
    }

    public void setBinaryMetadataFileStoreDir(@Nullable File binaryMetadataFileStoreDir) {
        this.binaryMetadataFileStoreDir = binaryMetadataFileStoreDir;
    }

    @Override
    public void removeType(int typeId) {
        BinaryMetadataHolder oldHld = (BinaryMetadataHolder)this.metadataLocCache.get(typeId);
        if (oldHld == null) {
            throw new IgniteException("Failed to remove metadata, type not found: " + typeId);
        }
        if (oldHld.removing()) {
            throw new IgniteException("Failed to remove metadata, type is being removed: " + typeId);
        }
        if (!IgniteFeatures.allNodesSupport(this.ctx, IgniteFeatures.REMOVE_METADATA)) {
            throw new IgniteException("Failed to remove metadata, all cluster nodes must support the remove type feature");
        }
        try {
            GridFutureAdapter<MetadataUpdateResult> fut = this.transport.requestMetadataRemove(typeId);
            MetadataUpdateResult res = fut.get();
            if (res.rejected()) {
                throw res.error();
            }
        }
        catch (IgniteCheckedException e) {
            IgniteCheckedException ex = e;
            if (this.ctx.isStopping()) {
                ex = new NodeStoppingException("Node is stopping.");
                ex.addSuppressed(e);
            }
            throw new BinaryObjectException("Failed to remove metadata for type: " + typeId, ex);
        }
    }

    static {
        IMMUTABLE_CLS.add(String.class);
        IMMUTABLE_CLS.add(Boolean.class);
        IMMUTABLE_CLS.add(Byte.class);
        IMMUTABLE_CLS.add(Short.class);
        IMMUTABLE_CLS.add(Character.class);
        IMMUTABLE_CLS.add(Integer.class);
        IMMUTABLE_CLS.add(Long.class);
        IMMUTABLE_CLS.add(Float.class);
        IMMUTABLE_CLS.add(Double.class);
        IMMUTABLE_CLS.add(UUID.class);
        IMMUTABLE_CLS.add(IgniteUuid.class);
        IMMUTABLE_CLS.add(BigDecimal.class);
    }

    public static class TestBinaryContext
    extends BinaryContext {
        private List<TestBinaryContextListener> listeners;

        public TestBinaryContext(BinaryMetadataHandler metaHnd, IgniteConfiguration igniteCfg, IgniteLogger log) {
            super(metaHnd, igniteCfg, log);
        }

        @Override
        @Nullable
        public BinaryType metadata(int typeId) throws BinaryObjectException {
            BinaryType metadata = super.metadata(typeId);
            if (this.listeners != null) {
                for (TestBinaryContextListener listener : this.listeners) {
                    listener.onAfterMetadataRequest(typeId, metadata);
                }
            }
            return metadata;
        }

        @Override
        public void updateMetadata(int typeId, BinaryMetadata meta, boolean failIfUnregistered) throws BinaryObjectException {
            if (this.listeners != null) {
                for (TestBinaryContextListener listener : this.listeners) {
                    listener.onBeforeMetadataUpdate(typeId, meta);
                }
            }
            super.updateMetadata(typeId, meta, failIfUnregistered);
        }

        public void addListener(TestBinaryContextListener lsnr) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<TestBinaryContextListener>();
            }
            if (!this.listeners.contains(lsnr)) {
                this.listeners.add(lsnr);
            }
        }

        public void clearAllListener() {
            if (this.listeners != null) {
                this.listeners.clear();
            }
        }

        public static interface TestBinaryContextListener {
            public void onAfterMetadataRequest(int var1, BinaryType var2);

            public void onBeforeMetadataUpdate(int var1, BinaryMetadata var2);
        }
    }
}

