/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.util;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cache.checker.objects.VersionedValue;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationDataRowMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationKeyMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationValueMeta;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ConsistencyCheckUtils {
    public static final String RECONCILIATION_DIR = "reconciliation";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss_SSS");

    public static Map<KeyCacheObject, Map<UUID, GridCacheVersion>> checkConflicts(Map<KeyCacheObject, Map<UUID, GridCacheVersion>> oldKeys, Map<KeyCacheObject, Map<UUID, VersionedValue>> actualKeys, GridCacheContext cctx, AffinityTopologyVersion startTopVer) {
        HashMap<KeyCacheObject, Map<UUID, GridCacheVersion>> keysWithConflicts = new HashMap<KeyCacheObject, Map<UUID, GridCacheVersion>>();
        for (Map.Entry<KeyCacheObject, Map<UUID, GridCacheVersion>> keyEntry : oldKeys.entrySet()) {
            KeyCacheObject key = keyEntry.getKey();
            Map<UUID, GridCacheVersion> oldKeyVers = keyEntry.getValue();
            Map<UUID, VersionedValue> newKeyVers = actualKeys.get(key);
            if (newKeyVers == null) continue;
            int ownerSize = cctx.topology().owners(cctx.affinity().partition(key), startTopVer).size();
            if (oldKeyVers.size() != ownerSize) {
                boolean maxVerChanged;
                boolean rmv = oldKeyVers.keySet().stream().anyMatch(nodeId -> !newKeyVers.containsKey(nodeId));
                if (rmv || (maxVerChanged = ConsistencyCheckUtils.findMaxVersionSet(oldKeyVers).stream().anyMatch(nodeId -> ((VersionedValue)newKeyVers.get(nodeId)).version().isGreater((GridCacheVersion)oldKeyVers.get(nodeId))))) continue;
                GridCacheVersion maxOldVer = oldKeyVers.values().stream().max(GridCacheVersion::compareTo).orElseThrow(NoSuchElementException::new);
                boolean missingMaxElement = newKeyVers.values().stream().map(VersionedValue::version).anyMatch(v -> v.isGreater(maxOldVer));
                if (missingMaxElement) {
                    keysWithConflicts.put(keyEntry.getKey(), newKeyVers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((VersionedValue)v.getValue()).version())));
                    continue;
                }
            }
            if ((oldKeyVers.size() != ownerSize || oldKeyVers.size() == newKeyVers.size()) && ConsistencyCheckUtils.checkConsistency(oldKeyVers, newKeyVers, ownerSize)) continue;
            keysWithConflicts.put(keyEntry.getKey(), oldKeyVers);
        }
        return keysWithConflicts;
    }

    public static boolean checkConsistency(Map<UUID, GridCacheVersion> oldKeyVers, Map<UUID, VersionedValue> actualKeyVers, int ownerSize) {
        assert (!oldKeyVers.isEmpty());
        if (actualKeyVers.isEmpty()) {
            return true;
        }
        Set<UUID> maxVersions = ConsistencyCheckUtils.findMaxVersionSet(oldKeyVers);
        GridCacheVersion maxVer = oldKeyVers.get(maxVersions.iterator().next());
        for (UUID maxVerOwner : maxVersions) {
            VersionedValue verVal = actualKeyVers.get(maxVerOwner);
            if (verVal != null && !maxVer.isLess(verVal.version())) continue;
            return true;
        }
        if (ownerSize != actualKeyVers.size()) {
            return false;
        }
        boolean allNonMaxChanged = true;
        for (Map.Entry<UUID, GridCacheVersion> oldEntry : oldKeyVers.entrySet()) {
            if (actualKeyVers.containsKey(oldEntry.getKey())) continue;
            return true;
        }
        for (VersionedValue actualKeyVer : actualKeyVers.values()) {
            if (actualKeyVer.version().isGreater(maxVer)) {
                return true;
            }
            if (!actualKeyVer.version().isLess(maxVer)) continue;
            allNonMaxChanged = false;
            break;
        }
        return allNonMaxChanged;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static CacheObject calculateValueToFixWith(RepairAlgorithm repairAlg, Map<UUID, VersionedValue> nodeToVersionedValues, UUID primaryNodeID, CacheObjectContext cacheObjCtx, int affinityNodesCnt) throws IgniteCheckedException {
        CacheObject valToFixWith = null;
        switch (repairAlg) {
            case PRIMARY: {
                VersionedValue versionedVal = nodeToVersionedValues.get(primaryNodeID);
                return versionedVal != null ? versionedVal.value() : null;
            }
            case REMOVE: {
                return null;
            }
            case MAJORITY: {
                if (affinityNodesCnt > nodeToVersionedValues.size() * 2) {
                    return null;
                }
                HashMap<String, T2<Integer, Object>> majorityCntr = new HashMap<String, T2<Integer, Object>>();
                majorityCntr.put("", new T2<Integer, Object>(affinityNodesCnt - nodeToVersionedValues.size(), null));
                for (VersionedValue versionedValue : nodeToVersionedValues.values()) {
                    byte[] valBytes = versionedValue.value().valueBytes(cacheObjCtx);
                    String valBytesStr = Arrays.toString(valBytes);
                    if (majorityCntr.putIfAbsent(valBytesStr, new T2<Integer, CacheObject>(1, versionedValue.value())) == null) continue;
                    T2 valTuple = (T2)majorityCntr.get(valBytesStr);
                    valTuple.set1((Integer)valTuple.getKey() + 1);
                }
                int maxMajority = -1;
                for (T2 majorityValues : majorityCntr.values()) {
                    if ((Integer)majorityValues.get1() <= maxMajority) continue;
                    maxMajority = (Integer)majorityValues.get1();
                    valToFixWith = (CacheObject)majorityValues.get2();
                }
                return valToFixWith;
            }
            case LATEST: {
                GridCacheVersion gridCacheVersion = new GridCacheVersion(0, 0, 0L);
                for (VersionedValue versionedValue : nodeToVersionedValues.values()) {
                    void var9_13;
                    if (versionedValue.version().compareTo((GridCacheVersion)var9_13) <= 0) continue;
                    GridCacheVersion gridCacheVersion2 = versionedValue.version();
                    valToFixWith = versionedValue.value();
                }
                return valToFixWith;
            }
        }
        throw new IllegalArgumentException("Unsupported repair algorithm=[" + (Object)((Object)repairAlg) + ']');
    }

    public static Set<UUID> findMaxVersionSet(Map<UUID, GridCacheVersion> verSet) {
        HashSet<UUID> maxVersions = new HashSet<UUID>();
        maxVersions.add(verSet.keySet().iterator().next());
        for (Map.Entry<UUID, GridCacheVersion> entry : verSet.entrySet()) {
            GridCacheVersion lastMaxVer = verSet.get(maxVersions.iterator().next());
            GridCacheVersion curVer = entry.getValue();
            if (curVer.isGreater(lastMaxVer)) {
                maxVersions.clear();
                maxVersions.add(entry.getKey());
                continue;
            }
            if (!curVer.equals(lastMaxVer)) continue;
            maxVersions.add(entry.getKey());
        }
        return maxVersions;
    }

    public static KeyCacheObject unmarshalKey(KeyCacheObject unmarshalKey, GridCacheContext<Object, Object> cctx) throws IgniteCheckedException {
        if (unmarshalKey == null) {
            return null;
        }
        unmarshalKey.finishUnmarshal(cctx.cacheObjectContext(), null);
        return unmarshalKey;
    }

    public static List<PartitionReconciliationDataRowMeta> mapPartitionReconciliation(Map<KeyCacheObject, Map<UUID, GridCacheVersion>> conflicts, Map<KeyCacheObject, Map<UUID, VersionedValue>> actualKeys, CacheObjectContext ctx) throws IgniteCheckedException {
        ArrayList<PartitionReconciliationDataRowMeta> brokenKeys = new ArrayList<PartitionReconciliationDataRowMeta>();
        for (Map.Entry<KeyCacheObject, Map<UUID, GridCacheVersion>> entry : conflicts.entrySet()) {
            KeyCacheObject key = entry.getKey();
            HashMap<UUID, PartitionReconciliationValueMeta> valMap = new HashMap<UUID, PartitionReconciliationValueMeta>();
            for (Map.Entry<UUID, GridCacheVersion> versionEntry : entry.getValue().entrySet()) {
                UUID nodeId = versionEntry.getKey();
                Optional<CacheObject> cacheObjOpt = Optional.ofNullable(actualKeys.get(key)).flatMap(keyVersions -> Optional.ofNullable(keyVersions.get(nodeId))).map(VersionedValue::value);
                valMap.put(nodeId, cacheObjOpt.isPresent() ? new PartitionReconciliationValueMeta(cacheObjOpt.get().valueBytes(ctx), cacheObjOpt.map(o -> ConsistencyCheckUtils.objectStringView(ctx, o)).orElse(null), versionEntry.getValue()) : null);
            }
            brokenKeys.add(new PartitionReconciliationDataRowMeta(new PartitionReconciliationKeyMeta(key.valueBytes(ctx), ConsistencyCheckUtils.objectStringView(ctx, key)), valMap));
        }
        return brokenKeys;
    }

    public static File createLocalResultFile(ClusterNode locNode, LocalDateTime startTime) throws IgniteCheckedException, IOException {
        File file;
        String maskId = U.maskForFileName(locNode.consistentId().toString());
        File dir = new File(U.defaultWorkDirectory() + File.separatorChar + RECONCILIATION_DIR);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(file = new File(dir.getPath() + File.separatorChar + maskId + "_" + startTime.format(TIME_FORMATTER) + ".txt")).exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static String objectStringView(CacheObjectContext ctx, CacheObject obj) {
        if (obj instanceof KeyCacheObjectImpl || obj instanceof CacheObjectImpl) {
            return Objects.toString(obj.value(ctx, false));
        }
        return Objects.toString(obj);
    }
}

